package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a State Machine.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact inputArtifact = new Artifact();
 * Pass startState = new Pass(this, "StartState");
 * StateMachine simpleStateMachine = StateMachine.Builder.create(this, "SimpleStateMachine")
 *         .definition(startState)
 *         .build();
 * StepFunctionInvokeAction stepFunctionAction = StepFunctionInvokeAction.Builder.create()
 *         .actionName("Invoke")
 *         .stateMachine(simpleStateMachine)
 *         .stateMachineInput(StateMachineInput.filePath(inputArtifact.atPath("assets/input.json")))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("StepFunctions")
 *         .actions(List.of(stepFunctionAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:23.576Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.StateMachineProps")
@software.amazon.jsii.Jsii.Proxy(StateMachineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StateMachineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Comment that describes this state machine.
     * <p>
     * Default: - No comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * (deprecated) Definition for this state machine.
     * <p>
     * @deprecated use definitionBody: DefinitionBody.fromChainable()
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.IChainable getDefinition() {
        return null;
    }

    /**
     * Definition for this state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.DefinitionBody getDefinitionBody() {
        return null;
    }

    /**
     * substitutions for the definition body as a key-value map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDefinitionSubstitutions() {
        return null;
    }

    /**
     * Configures server-side encryption of the state machine definition and execution history.
     * <p>
     * Default: - data is transparently encrypted using an AWS owned key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration getEncryptionConfiguration() {
        return null;
    }

    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * Default: No logging
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.LogOptions getLogs() {
        return null;
    }

    /**
     * The name of the query language used by the state machine.
     * <p>
     * If the state does not contain a <code>queryLanguage</code> field,
     * then it will use the query language specified in this <code>queryLanguage</code> field.
     * <p>
     * Default: - JSON_PATH
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
        return null;
    }

    /**
     * The removal policy to apply to state machine.
     * <p>
     * Default: RemovalPolicy.DESTROY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * The execution role for the state machine service.
     * <p>
     * Default: A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * A name for the state machine.
     * <p>
     * Default: A name is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStateMachineName() {
        return null;
    }

    /**
     * Type of the state machine.
     * <p>
     * Default: StateMachineType.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateMachineType getStateMachineType() {
        return null;
    }

    /**
     * Maximum run time for this state machine.
     * <p>
     * Default: No timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * Specifies whether Amazon X-Ray tracing is enabled for this state machine.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTracingEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StateMachineProps> {
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.IChainable definition;
        software.amazon.awscdk.services.stepfunctions.DefinitionBody definitionBody;
        java.util.Map<java.lang.String, java.lang.String> definitionSubstitutions;
        software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration encryptionConfiguration;
        software.amazon.awscdk.services.stepfunctions.LogOptions logs;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String stateMachineName;
        software.amazon.awscdk.services.stepfunctions.StateMachineType stateMachineType;
        software.amazon.awscdk.Duration timeout;
        java.lang.Boolean tracingEnabled;

        /**
         * Sets the value of {@link StateMachineProps#getComment}
         * @param comment Comment that describes this state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getDefinition}
         * @param definition Definition for this state machine.
         * @return {@code this}
         * @deprecated use definitionBody: DefinitionBody.fromChainable()
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder definition(software.amazon.awscdk.services.stepfunctions.IChainable definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getDefinitionBody}
         * @param definitionBody Definition for this state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionBody(software.amazon.awscdk.services.stepfunctions.DefinitionBody definitionBody) {
            this.definitionBody = definitionBody;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getDefinitionSubstitutions}
         * @param definitionSubstitutions substitutions for the definition body as a key-value map.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(java.util.Map<java.lang.String, java.lang.String> definitionSubstitutions) {
            this.definitionSubstitutions = definitionSubstitutions;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getEncryptionConfiguration}
         * @param encryptionConfiguration Configures server-side encryption of the state machine definition and execution history.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getLogs}
         * @param logs Defines what execution history events are logged and where they are logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logs(software.amazon.awscdk.services.stepfunctions.LogOptions logs) {
            this.logs = logs;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state machine.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in this <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getRole}
         * @param role The execution role for the state machine service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getStateMachineName}
         * @param stateMachineName A name for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineName(java.lang.String stateMachineName) {
            this.stateMachineName = stateMachineName;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getStateMachineType}
         * @param stateMachineType Type of the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineType(software.amazon.awscdk.services.stepfunctions.StateMachineType stateMachineType) {
            this.stateMachineType = stateMachineType;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getTimeout}
         * @param timeout Maximum run time for this state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link StateMachineProps#getTracingEnabled}
         * @param tracingEnabled Specifies whether Amazon X-Ray tracing is enabled for this state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StateMachineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StateMachineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StateMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StateMachineProps {
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.IChainable definition;
        private final software.amazon.awscdk.services.stepfunctions.DefinitionBody definitionBody;
        private final java.util.Map<java.lang.String, java.lang.String> definitionSubstitutions;
        private final software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration encryptionConfiguration;
        private final software.amazon.awscdk.services.stepfunctions.LogOptions logs;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String stateMachineName;
        private final software.amazon.awscdk.services.stepfunctions.StateMachineType stateMachineType;
        private final software.amazon.awscdk.Duration timeout;
        private final java.lang.Boolean tracingEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IChainable.class));
            this.definitionBody = software.amazon.jsii.Kernel.get(this, "definitionBody", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class));
            this.definitionSubstitutions = software.amazon.jsii.Kernel.get(this, "definitionSubstitutions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration.class));
            this.logs = software.amazon.jsii.Kernel.get(this, "logs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.LogOptions.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.stateMachineName = software.amazon.jsii.Kernel.get(this, "stateMachineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stateMachineType = software.amazon.jsii.Kernel.get(this, "stateMachineType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineType.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.tracingEnabled = software.amazon.jsii.Kernel.get(this, "tracingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.definition = builder.definition;
            this.definitionBody = builder.definitionBody;
            this.definitionSubstitutions = builder.definitionSubstitutions;
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.logs = builder.logs;
            this.queryLanguage = builder.queryLanguage;
            this.removalPolicy = builder.removalPolicy;
            this.role = builder.role;
            this.stateMachineName = builder.stateMachineName;
            this.stateMachineType = builder.stateMachineType;
            this.timeout = builder.timeout;
            this.tracingEnabled = builder.tracingEnabled;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IChainable getDefinition() {
            return this.definition;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.DefinitionBody getDefinitionBody() {
            return this.definitionBody;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDefinitionSubstitutions() {
            return this.definitionSubstitutions;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.LogOptions getLogs() {
            return this.logs;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getStateMachineName() {
            return this.stateMachineName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.StateMachineType getStateMachineType() {
            return this.stateMachineType;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Boolean getTracingEnabled() {
            return this.tracingEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getDefinitionBody() != null) {
                data.set("definitionBody", om.valueToTree(this.getDefinitionBody()));
            }
            if (this.getDefinitionSubstitutions() != null) {
                data.set("definitionSubstitutions", om.valueToTree(this.getDefinitionSubstitutions()));
            }
            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getLogs() != null) {
                data.set("logs", om.valueToTree(this.getLogs()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getStateMachineName() != null) {
                data.set("stateMachineName", om.valueToTree(this.getStateMachineName()));
            }
            if (this.getStateMachineType() != null) {
                data.set("stateMachineType", om.valueToTree(this.getStateMachineType()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getTracingEnabled() != null) {
                data.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.StateMachineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StateMachineProps.Jsii$Proxy that = (StateMachineProps.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            if (this.definitionBody != null ? !this.definitionBody.equals(that.definitionBody) : that.definitionBody != null) return false;
            if (this.definitionSubstitutions != null ? !this.definitionSubstitutions.equals(that.definitionSubstitutions) : that.definitionSubstitutions != null) return false;
            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.stateMachineName != null ? !this.stateMachineName.equals(that.stateMachineName) : that.stateMachineName != null) return false;
            if (this.stateMachineType != null ? !this.stateMachineType.equals(that.stateMachineType) : that.stateMachineType != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.tracingEnabled != null ? this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
            result = 31 * result + (this.definitionBody != null ? this.definitionBody.hashCode() : 0);
            result = 31 * result + (this.definitionSubstitutions != null ? this.definitionSubstitutions.hashCode() : 0);
            result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.logs != null ? this.logs.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.stateMachineName != null ? this.stateMachineName.hashCode() : 0);
            result = 31 * result + (this.stateMachineType != null ? this.stateMachineType.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
            return result;
        }
    }
}
