package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for starting an AWS Glue job as a task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GlueStartJobRun.Builder.create(this, "Task")
 *         .glueJobName("my-glue-job")
 *         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                 .workerTypeV2(WorkerTypeV2.G_1X) // Worker type
 *                 .numberOfWorkers(2)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:23.949Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.GlueStartJobRunProps")
@software.amazon.jsii.Jsii.Proxy(GlueStartJobRunProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GlueStartJobRunProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * Glue job name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getGlueJobName();

    /**
     * The job arguments specifically for this run.
     * <p>
     * For this job run, they replace the default arguments set in the job
     * definition itself.
     * <p>
     * Default: - Default arguments set in the job definition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getArguments() {
        return null;
    }

    /**
     * The excecution class of the job.
     * <p>
     * Default: - STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ExecutionClass getExecutionClass() {
        return null;
    }

    /**
     * After a job run starts, the number of minutes to wait before sending a job run delay notification.
     * <p>
     * Must be at least 1 minute.
     * <p>
     * Default: - Default delay set in the job definition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getNotifyDelayAfter() {
        return null;
    }

    /**
     * The name of the SecurityConfiguration structure to be used with this job run.
     * <p>
     * This must match the Glue API
     * <p>
     * Default: - Default configuration set in the job definition
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-oneLine">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-oneLine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return null;
    }

    /**
     * The worker configuration for this run.
     * <p>
     * Default: - Default worker configuration in the job definition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.WorkerConfigurationProperty getWorkerConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GlueStartJobRunProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GlueStartJobRunProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GlueStartJobRunProps> {
        java.lang.String glueJobName;
        software.amazon.awscdk.services.stepfunctions.TaskInput arguments;
        software.amazon.awscdk.services.stepfunctions.tasks.ExecutionClass executionClass;
        software.amazon.awscdk.Duration notifyDelayAfter;
        java.lang.String securityConfiguration;
        software.amazon.awscdk.services.stepfunctions.tasks.WorkerConfigurationProperty workerConfiguration;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.String inputPath;
        java.lang.String outputPath;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link GlueStartJobRunProps#getGlueJobName}
         * @param glueJobName Glue job name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder glueJobName(java.lang.String glueJobName) {
            this.glueJobName = glueJobName;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getArguments}
         * @param arguments The job arguments specifically for this run.
         *                  For this job run, they replace the default arguments set in the job
         *                  definition itself.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arguments(software.amazon.awscdk.services.stepfunctions.TaskInput arguments) {
            this.arguments = arguments;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getExecutionClass}
         * @param executionClass The excecution class of the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionClass(software.amazon.awscdk.services.stepfunctions.tasks.ExecutionClass executionClass) {
            this.executionClass = executionClass;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getNotifyDelayAfter}
         * @param notifyDelayAfter After a job run starts, the number of minutes to wait before sending a job run delay notification.
         *                         Must be at least 1 minute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyDelayAfter(software.amazon.awscdk.Duration notifyDelayAfter) {
            this.notifyDelayAfter = notifyDelayAfter;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getSecurityConfiguration}
         * @param securityConfiguration The name of the SecurityConfiguration structure to be used with this job run.
         *                              This must match the Glue API
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfiguration(java.lang.String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getWorkerConfiguration}
         * @param workerConfiguration The worker configuration for this run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerConfiguration(software.amazon.awscdk.services.stepfunctions.tasks.WorkerConfigurationProperty workerConfiguration) {
            this.workerConfiguration = workerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link GlueStartJobRunProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GlueStartJobRunProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GlueStartJobRunProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GlueStartJobRunProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueStartJobRunProps {
        private final java.lang.String glueJobName;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput arguments;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ExecutionClass executionClass;
        private final software.amazon.awscdk.Duration notifyDelayAfter;
        private final java.lang.String securityConfiguration;
        private final software.amazon.awscdk.services.stepfunctions.tasks.WorkerConfigurationProperty workerConfiguration;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.glueJobName = software.amazon.jsii.Kernel.get(this, "glueJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.arguments = software.amazon.jsii.Kernel.get(this, "arguments", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.executionClass = software.amazon.jsii.Kernel.get(this, "executionClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ExecutionClass.class));
            this.notifyDelayAfter = software.amazon.jsii.Kernel.get(this, "notifyDelayAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workerConfiguration = software.amazon.jsii.Kernel.get(this, "workerConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.WorkerConfigurationProperty.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.glueJobName = java.util.Objects.requireNonNull(builder.glueJobName, "glueJobName is required");
            this.arguments = builder.arguments;
            this.executionClass = builder.executionClass;
            this.notifyDelayAfter = builder.notifyDelayAfter;
            this.securityConfiguration = builder.securityConfiguration;
            this.workerConfiguration = builder.workerConfiguration;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
            this.outputs = builder.outputs;
        }

        @Override
        public final java.lang.String getGlueJobName() {
            return this.glueJobName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getArguments() {
            return this.arguments;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.ExecutionClass getExecutionClass() {
            return this.executionClass;
        }

        @Override
        public final software.amazon.awscdk.Duration getNotifyDelayAfter() {
            return this.notifyDelayAfter;
        }

        @Override
        public final java.lang.String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.WorkerConfigurationProperty getWorkerConfiguration() {
            return this.workerConfiguration;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("glueJobName", om.valueToTree(this.getGlueJobName()));
            if (this.getArguments() != null) {
                data.set("arguments", om.valueToTree(this.getArguments()));
            }
            if (this.getExecutionClass() != null) {
                data.set("executionClass", om.valueToTree(this.getExecutionClass()));
            }
            if (this.getNotifyDelayAfter() != null) {
                data.set("notifyDelayAfter", om.valueToTree(this.getNotifyDelayAfter()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getWorkerConfiguration() != null) {
                data.set("workerConfiguration", om.valueToTree(this.getWorkerConfiguration()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.GlueStartJobRunProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GlueStartJobRunProps.Jsii$Proxy that = (GlueStartJobRunProps.Jsii$Proxy) o;

            if (!glueJobName.equals(that.glueJobName)) return false;
            if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) return false;
            if (this.executionClass != null ? !this.executionClass.equals(that.executionClass) : that.executionClass != null) return false;
            if (this.notifyDelayAfter != null ? !this.notifyDelayAfter.equals(that.notifyDelayAfter) : that.notifyDelayAfter != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.workerConfiguration != null ? !this.workerConfiguration.equals(that.workerConfiguration) : that.workerConfiguration != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.glueJobName.hashCode();
            result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
            result = 31 * result + (this.executionClass != null ? this.executionClass.hashCode() : 0);
            result = 31 * result + (this.notifyDelayAfter != null ? this.notifyDelayAfter.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.workerConfiguration != null ? this.workerConfiguration.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
