package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Schedule for EventBridge Scheduler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.scheduler.*;
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * CfnScheduleGroup scheduleGroup;
 * Queue targetQueue;
 * Queue deadLetterQueue;
 * Role schedulerRole = Role.Builder.create(this, "SchedulerRole")
 *         .assumedBy(new ServicePrincipal("scheduler.amazonaws.com"))
 *         .build();
 * // To send the message to the queue
 * // This policy changes depending on the type of target.
 * schedulerRole.addToPrincipalPolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("sqs:SendMessage"))
 *         .resources(List.of(targetQueue.getQueueArn()))
 *         .build());
 * EventBridgeSchedulerCreateScheduleTask createScheduleTask1 = EventBridgeSchedulerCreateScheduleTask.Builder.create(this, "createSchedule")
 *         .scheduleName("TestSchedule")
 *         .actionAfterCompletion(ActionAfterCompletion.NONE)
 *         .clientToken("testToken")
 *         .description("TestDescription")
 *         .startDate(new Date())
 *         .endDate(new Date(new Date().getTime() + 1000 * 60 * 60))
 *         .flexibleTimeWindow(Duration.minutes(5))
 *         .groupName(scheduleGroup.getRef())
 *         .kmsKey(key)
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .timezone("UTC")
 *         .enabled(true)
 *         .target(EventBridgeSchedulerTarget.Builder.create()
 *                 .arn(targetQueue.getQueueArn())
 *                 .role(schedulerRole)
 *                 .retryPolicy(RetryPolicy.builder()
 *                         .maximumRetryAttempts(2)
 *                         .maximumEventAge(Duration.minutes(5))
 *                         .build())
 *                 .deadLetterQueue(deadLetterQueue)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:24.032Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.Schedule")
public class Schedule extends software.amazon.jsii.JsiiObject {

    protected Schedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Create a cron-based schedule from a set of cron fields.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.Schedule cron(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.CronOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.Schedule.class, "cron", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Schedule.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Construct a one-time schedule from a Date.
     * <p>
     * @param time This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.Schedule oneTime(final @org.jetbrains.annotations.NotNull java.time.Instant time) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.Schedule.class, "oneTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Schedule.class), new Object[] { java.util.Objects.requireNonNull(time, "time is required") });
    }

    /**
     * Construct a rate-based schedule from an interval.
     * <p>
     * The minimum interval is 1 minute.
     * <p>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.Schedule rate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.Schedule.class, "rate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Schedule.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * The Schedule expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExpressionString() {
        return software.amazon.jsii.Kernel.get(this, "expressionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
