package software.amazon.awscdk.services.timestream;

/**
 * Properties for defining a <code>CfnScheduledQuery</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.timestream.*;
 * CfnScheduledQueryProps cfnScheduledQueryProps = CfnScheduledQueryProps.builder()
 *         .errorReportConfiguration(ErrorReportConfigurationProperty.builder()
 *                 .s3Configuration(S3ConfigurationProperty.builder()
 *                         .bucketName("bucketName")
 *                         // the properties below are optional
 *                         .encryptionOption("encryptionOption")
 *                         .objectKeyPrefix("objectKeyPrefix")
 *                         .build())
 *                 .build())
 *         .notificationConfiguration(NotificationConfigurationProperty.builder()
 *                 .snsConfiguration(SnsConfigurationProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .build())
 *         .queryString("queryString")
 *         .scheduleConfiguration(ScheduleConfigurationProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .scheduledQueryExecutionRoleArn("scheduledQueryExecutionRoleArn")
 *         // the properties below are optional
 *         .clientToken("clientToken")
 *         .kmsKeyId("kmsKeyId")
 *         .scheduledQueryName("scheduledQueryName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetConfiguration(TargetConfigurationProperty.builder()
 *                 .timestreamConfiguration(TimestreamConfigurationProperty.builder()
 *                         .databaseName("databaseName")
 *                         .dimensionMappings(List.of(DimensionMappingProperty.builder()
 *                                 .dimensionValueType("dimensionValueType")
 *                                 .name("name")
 *                                 .build()))
 *                         .tableName("tableName")
 *                         .timeColumn("timeColumn")
 *                         // the properties below are optional
 *                         .measureNameColumn("measureNameColumn")
 *                         .mixedMeasureMappings(List.of(MixedMeasureMappingProperty.builder()
 *                                 .measureValueType("measureValueType")
 *                                 // the properties below are optional
 *                                 .measureName("measureName")
 *                                 .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
 *                                         .measureValueType("measureValueType")
 *                                         .sourceColumn("sourceColumn")
 *                                         // the properties below are optional
 *                                         .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
 *                                         .build()))
 *                                 .sourceColumn("sourceColumn")
 *                                 .targetMeasureName("targetMeasureName")
 *                                 .build()))
 *                         .multiMeasureMappings(MultiMeasureMappingsProperty.builder()
 *                                 .multiMeasureAttributeMappings(List.of(MultiMeasureAttributeMappingProperty.builder()
 *                                         .measureValueType("measureValueType")
 *                                         .sourceColumn("sourceColumn")
 *                                         // the properties below are optional
 *                                         .targetMultiMeasureAttributeName("targetMultiMeasureAttributeName")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .targetMultiMeasureName("targetMultiMeasureName")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:24.141Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnScheduledQueryProps")
@software.amazon.jsii.Jsii.Proxy(CfnScheduledQueryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScheduledQueryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration for error reporting.
     * <p>
     * Error reports will be generated when a problem is encountered when writing the query results.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-errorreportconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-errorreportconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getErrorReportConfiguration();

    /**
     * Notification configuration for the scheduled query.
     * <p>
     * A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-notificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-notificationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNotificationConfiguration();

    /**
     * The query string to run.
     * <p>
     * Parameter names can be specified in the query string <code>&#64;</code> character followed by an identifier. The named Parameter <code>&#64;scheduled_runtime</code> is reserved and can be used in the query to get the time at which the query is scheduled to run.
     * <p>
     * The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of <code>&#64;scheduled_runtime</code> paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the <code>&#64;scheduled_runtime</code> parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-querystring</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQueryString();

    /**
     * Schedule configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduleconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getScheduleConfiguration();

    /**
     * The ARN for the IAM role that Timestream will assume when running the scheduled query.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryexecutionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduledQueryExecutionRoleArn();

    /**
     * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result.
     * <p>
     * Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.
     * <p>
     * <ul>
     * <li>If CreateScheduledQuery is called without a <code>ClientToken</code> , the Query SDK generates a <code>ClientToken</code> on your behalf.</li>
     * <li>After 8 hours, any request with the same <code>ClientToken</code> is treated as a new request.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-clienttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-clienttoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * The Amazon KMS key used to encrypt the scheduled query resource, at-rest.
     * <p>
     * If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with <em>alias/</em>
     * <p>
     * If ErrorReportConfiguration uses <code>SSE_KMS</code> as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * A name for the query.
     * <p>
     * Scheduled query names must be unique within each Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-scheduledqueryname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduledQueryName() {
        return null;
    }

    /**
     * A list of key-value pairs to label the scheduled query.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Scheduled query target store configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-scheduledquery.html#cfn-timestream-scheduledquery-targetconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScheduledQueryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScheduledQueryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScheduledQueryProps> {
        java.lang.Object errorReportConfiguration;
        java.lang.Object notificationConfiguration;
        java.lang.String queryString;
        java.lang.Object scheduleConfiguration;
        java.lang.String scheduledQueryExecutionRoleArn;
        java.lang.String clientToken;
        java.lang.String kmsKeyId;
        java.lang.String scheduledQueryName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object targetConfiguration;

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getErrorReportConfiguration}
         * @param errorReportConfiguration Configuration for error reporting. This parameter is required.
         *                                 Error reports will be generated when a problem is encountered when writing the query results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorReportConfiguration(software.amazon.awscdk.IResolvable errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getErrorReportConfiguration}
         * @param errorReportConfiguration Configuration for error reporting. This parameter is required.
         *                                 Error reports will be generated when a problem is encountered when writing the query results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorReportConfiguration(software.amazon.awscdk.services.timestream.CfnScheduledQuery.ErrorReportConfigurationProperty errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getNotificationConfiguration}
         * @param notificationConfiguration Notification configuration for the scheduled query. This parameter is required.
         *                                  A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.IResolvable notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getNotificationConfiguration}
         * @param notificationConfiguration Notification configuration for the scheduled query. This parameter is required.
         *                                  A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.services.timestream.CfnScheduledQuery.NotificationConfigurationProperty notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getQueryString}
         * @param queryString The query string to run. This parameter is required.
         *                    Parameter names can be specified in the query string <code>&#64;</code> character followed by an identifier. The named Parameter <code>&#64;scheduled_runtime</code> is reserved and can be used in the query to get the time at which the query is scheduled to run.
         *                    <p>
         *                    The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of <code>&#64;scheduled_runtime</code> paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the <code>&#64;scheduled_runtime</code> parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryString(java.lang.String queryString) {
            this.queryString = queryString;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getScheduleConfiguration}
         * @param scheduleConfiguration Schedule configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleConfiguration(software.amazon.awscdk.IResolvable scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getScheduleConfiguration}
         * @param scheduleConfiguration Schedule configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleConfiguration(software.amazon.awscdk.services.timestream.CfnScheduledQuery.ScheduleConfigurationProperty scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getScheduledQueryExecutionRoleArn}
         * @param scheduledQueryExecutionRoleArn The ARN for the IAM role that Timestream will assume when running the scheduled query. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledQueryExecutionRoleArn(java.lang.String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getClientToken}
         * @param clientToken Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result.
         *                    Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.
         *                    <p>
         *                    <ul>
         *                    <li>If CreateScheduledQuery is called without a <code>ClientToken</code> , the Query SDK generates a <code>ClientToken</code> on your behalf.</li>
         *                    <li>After 8 hours, any request with the same <code>ClientToken</code> is treated as a new request.</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getKmsKeyId}
         * @param kmsKeyId The Amazon KMS key used to encrypt the scheduled query resource, at-rest.
         *                 If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with <em>alias/</em>
         *                 <p>
         *                 If ErrorReportConfiguration uses <code>SSE_KMS</code> as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getScheduledQueryName}
         * @param scheduledQueryName A name for the query.
         *                           Scheduled query names must be unique within each Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledQueryName(java.lang.String scheduledQueryName) {
            this.scheduledQueryName = scheduledQueryName;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getTags}
         * @param tags A list of key-value pairs to label the scheduled query.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getTargetConfiguration}
         * @param targetConfiguration Scheduled query target store configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(software.amazon.awscdk.IResolvable targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScheduledQueryProps#getTargetConfiguration}
         * @param targetConfiguration Scheduled query target store configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(software.amazon.awscdk.services.timestream.CfnScheduledQuery.TargetConfigurationProperty targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScheduledQueryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScheduledQueryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScheduledQueryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScheduledQueryProps {
        private final java.lang.Object errorReportConfiguration;
        private final java.lang.Object notificationConfiguration;
        private final java.lang.String queryString;
        private final java.lang.Object scheduleConfiguration;
        private final java.lang.String scheduledQueryExecutionRoleArn;
        private final java.lang.String clientToken;
        private final java.lang.String kmsKeyId;
        private final java.lang.String scheduledQueryName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object targetConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.errorReportConfiguration = software.amazon.jsii.Kernel.get(this, "errorReportConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationConfiguration = software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleConfiguration = software.amazon.jsii.Kernel.get(this, "scheduleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scheduledQueryExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "scheduledQueryExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduledQueryName = software.amazon.jsii.Kernel.get(this, "scheduledQueryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.targetConfiguration = software.amazon.jsii.Kernel.get(this, "targetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.errorReportConfiguration = java.util.Objects.requireNonNull(builder.errorReportConfiguration, "errorReportConfiguration is required");
            this.notificationConfiguration = java.util.Objects.requireNonNull(builder.notificationConfiguration, "notificationConfiguration is required");
            this.queryString = java.util.Objects.requireNonNull(builder.queryString, "queryString is required");
            this.scheduleConfiguration = java.util.Objects.requireNonNull(builder.scheduleConfiguration, "scheduleConfiguration is required");
            this.scheduledQueryExecutionRoleArn = java.util.Objects.requireNonNull(builder.scheduledQueryExecutionRoleArn, "scheduledQueryExecutionRoleArn is required");
            this.clientToken = builder.clientToken;
            this.kmsKeyId = builder.kmsKeyId;
            this.scheduledQueryName = builder.scheduledQueryName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.targetConfiguration = builder.targetConfiguration;
        }

        @Override
        public final java.lang.Object getErrorReportConfiguration() {
            return this.errorReportConfiguration;
        }

        @Override
        public final java.lang.Object getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final java.lang.String getQueryString() {
            return this.queryString;
        }

        @Override
        public final java.lang.Object getScheduleConfiguration() {
            return this.scheduleConfiguration;
        }

        @Override
        public final java.lang.String getScheduledQueryExecutionRoleArn() {
            return this.scheduledQueryExecutionRoleArn;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getScheduledQueryName() {
            return this.scheduledQueryName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTargetConfiguration() {
            return this.targetConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("errorReportConfiguration", om.valueToTree(this.getErrorReportConfiguration()));
            data.set("notificationConfiguration", om.valueToTree(this.getNotificationConfiguration()));
            data.set("queryString", om.valueToTree(this.getQueryString()));
            data.set("scheduleConfiguration", om.valueToTree(this.getScheduleConfiguration()));
            data.set("scheduledQueryExecutionRoleArn", om.valueToTree(this.getScheduledQueryExecutionRoleArn()));
            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getScheduledQueryName() != null) {
                data.set("scheduledQueryName", om.valueToTree(this.getScheduledQueryName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetConfiguration() != null) {
                data.set("targetConfiguration", om.valueToTree(this.getTargetConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnScheduledQueryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScheduledQueryProps.Jsii$Proxy that = (CfnScheduledQueryProps.Jsii$Proxy) o;

            if (!errorReportConfiguration.equals(that.errorReportConfiguration)) return false;
            if (!notificationConfiguration.equals(that.notificationConfiguration)) return false;
            if (!queryString.equals(that.queryString)) return false;
            if (!scheduleConfiguration.equals(that.scheduleConfiguration)) return false;
            if (!scheduledQueryExecutionRoleArn.equals(that.scheduledQueryExecutionRoleArn)) return false;
            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.scheduledQueryName != null ? !this.scheduledQueryName.equals(that.scheduledQueryName) : that.scheduledQueryName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.targetConfiguration != null ? this.targetConfiguration.equals(that.targetConfiguration) : that.targetConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.errorReportConfiguration.hashCode();
            result = 31 * result + (this.notificationConfiguration.hashCode());
            result = 31 * result + (this.queryString.hashCode());
            result = 31 * result + (this.scheduleConfiguration.hashCode());
            result = 31 * result + (this.scheduledQueryExecutionRoleArn.hashCode());
            result = 31 * result + (this.clientToken != null ? this.clientToken.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.scheduledQueryName != null ? this.scheduledQueryName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetConfiguration != null ? this.targetConfiguration.hashCode() : 0);
            return result;
        }
    }
}
