package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnAIAgent</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIAgentProps cfnAIAgentProps = CfnAIAgentProps.builder()
 *         .assistantId("assistantId")
 *         .configuration(AIAgentConfigurationProperty.builder()
 *                 .answerRecommendationAiAgentConfiguration(AnswerRecommendationAIAgentConfigurationProperty.builder()
 *                         .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
 *                         .answerGenerationAiPromptId("answerGenerationAiPromptId")
 *                         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
 *                                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
 *                                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
 *                                                 .contentTagFilter(TagFilterProperty.builder()
 *                                                         .andConditions(List.of(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .orConditions(List.of(OrConditionProperty.builder()
 *                                                                 .andConditions(List.of(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .tagCondition(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .tagCondition(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .maxResults(123)
 *                                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
 *                                                 .build())
 *                                         .build())
 *                                 .associationId("associationId")
 *                                 .associationType("associationType")
 *                                 .build()))
 *                         .intentLabelingGenerationAiPromptId("intentLabelingGenerationAiPromptId")
 *                         .locale("locale")
 *                         .queryReformulationAiPromptId("queryReformulationAiPromptId")
 *                         .build())
 *                 .manualSearchAiAgentConfiguration(ManualSearchAIAgentConfigurationProperty.builder()
 *                         .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
 *                         .answerGenerationAiPromptId("answerGenerationAiPromptId")
 *                         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
 *                                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
 *                                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
 *                                                 .contentTagFilter(TagFilterProperty.builder()
 *                                                         .andConditions(List.of(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .orConditions(List.of(OrConditionProperty.builder()
 *                                                                 .andConditions(List.of(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .tagCondition(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .tagCondition(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .maxResults(123)
 *                                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
 *                                                 .build())
 *                                         .build())
 *                                 .associationId("associationId")
 *                                 .associationType("associationType")
 *                                 .build()))
 *                         .locale("locale")
 *                         .build())
 *                 .selfServiceAiAgentConfiguration(SelfServiceAIAgentConfigurationProperty.builder()
 *                         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
 *                                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
 *                                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
 *                                                 .contentTagFilter(TagFilterProperty.builder()
 *                                                         .andConditions(List.of(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .orConditions(List.of(OrConditionProperty.builder()
 *                                                                 .andConditions(List.of(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .tagCondition(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .tagCondition(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .maxResults(123)
 *                                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
 *                                                 .build())
 *                                         .build())
 *                                 .associationId("associationId")
 *                                 .associationType("associationType")
 *                                 .build()))
 *                         .selfServiceAiGuardrailId("selfServiceAiGuardrailId")
 *                         .selfServiceAnswerGenerationAiPromptId("selfServiceAnswerGenerationAiPromptId")
 *                         .selfServicePreProcessingAiPromptId("selfServicePreProcessingAiPromptId")
 *                         .build())
 *                 .build())
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:24.552Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgentProps")
@software.amazon.jsii.Jsii.Proxy(CfnAIAgentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAIAgentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon Q in Connect assistant.
     * <p>
     * Can be either the ID or the ARN. URLs cannot contain the ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-assistantid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * Configuration for the AI Agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * The type of the AI Agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The description of the AI Agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the AI Agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAIAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAIAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAIAgentProps> {
        java.lang.String assistantId;
        java.lang.Object configuration;
        java.lang.String type;
        java.lang.String description;
        java.lang.String name;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnAIAgentProps#getAssistantId}
         * @param assistantId The identifier of the Amazon Q in Connect assistant. This parameter is required.
         *                    Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentProps#getConfiguration}
         * @param configuration Configuration for the AI Agent. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentProps#getConfiguration}
         * @param configuration Configuration for the AI Agent. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.wisdom.CfnAIAgent.AIAgentConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentProps#getType}
         * @param type The type of the AI Agent. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentProps#getDescription}
         * @param description The description of the AI Agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentProps#getName}
         * @param name The name of the AI Agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIAgentProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAIAgentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAIAgentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAIAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAIAgentProps {
        private final java.lang.String assistantId;
        private final java.lang.Object configuration;
        private final java.lang.String type;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.description = builder.description;
            this.name = builder.name;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assistantId", om.valueToTree(this.getAssistantId()));
            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAIAgentProps.Jsii$Proxy that = (CfnAIAgentProps.Jsii$Proxy) o;

            if (!assistantId.equals(that.assistantId)) return false;
            if (!configuration.equals(that.configuration)) return false;
            if (!type.equals(that.type)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assistantId.hashCode();
            result = 31 * result + (this.configuration.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
