package software.amazon.awscdk.services.workspacesweb;

/**
 * This resource specifies a web portal, which users use to start browsing sessions.
 * <p>
 * A <code>Standard</code> web portal can't start browsing sessions unless you have at defined and associated an <code>IdentityProvider</code> and <code>NetworkSettings</code> resource. An <code>IAM Identity Center</code> web portal does not require an <code>IdentityProvider</code> resource.
 * <p>
 * For more information about web portals, see <a href="https://docs.aws.amazon.com/workspaces-web/latest/adminguide/what-is-workspaces-web.html.html">What is Amazon WorkSpaces Secure Browser?</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesweb.*;
 * CfnPortal cfnPortal = CfnPortal.Builder.create(this, "MyCfnPortal")
 *         .additionalEncryptionContext(Map.of(
 *                 "additionalEncryptionContextKey", "additionalEncryptionContext"))
 *         .authenticationType("authenticationType")
 *         .browserSettingsArn("browserSettingsArn")
 *         .customerManagedKey("customerManagedKey")
 *         .dataProtectionSettingsArn("dataProtectionSettingsArn")
 *         .displayName("displayName")
 *         .instanceType("instanceType")
 *         .ipAccessSettingsArn("ipAccessSettingsArn")
 *         .maxConcurrentSessions(123)
 *         .networkSettingsArn("networkSettingsArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trustStoreArn("trustStoreArn")
 *         .userAccessLoggingSettingsArn("userAccessLoggingSettingsArn")
 *         .userSettingsArn("userSettingsArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:24.662Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnPortal")
public class CfnPortal extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnPortal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPortal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.workspacesweb.CfnPortal.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPortal(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.workspacesweb.CfnPortalProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPortal(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The browser that users see when using a streaming session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBrowserType() {
        return software.amazon.jsii.Kernel.get(this, "attrBrowserType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The creation date of the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPortalArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPortalArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint URL of the web portal that users access in order to start streaming sessions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPortalEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrPortalEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPortalStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrPortalStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The renderer that is used in streaming sessions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRendererType() {
        return software.amazon.jsii.Kernel.get(this, "attrRendererType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The SAML metadata of the service provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceProviderSamlMetadata() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceProviderSamlMetadata", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message that explains why the web portal is in its current status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusReason() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The additional encryption context of the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalEncryptionContext() {
        return software.amazon.jsii.Kernel.get(this, "additionalEncryptionContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The additional encryption context of the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalEncryptionContext(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "additionalEncryptionContext", value);
    }

    /**
     * The additional encryption context of the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalEncryptionContext(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalEncryptionContext", value);
    }

    /**
     * The type of authentication integration points used when signing into the web portal.
     * <p>
     * Defaults to <code>Standard</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
        return software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of authentication integration points used when signing into the web portal.
     * <p>
     * Defaults to <code>Standard</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authenticationType", value);
    }

    /**
     * The ARN of the browser settings that is associated with this web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBrowserSettingsArn() {
        return software.amazon.jsii.Kernel.get(this, "browserSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the browser settings that is associated with this web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBrowserSettingsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "browserSettingsArn", value);
    }

    /**
     * The customer managed key of the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomerManagedKey() {
        return software.amazon.jsii.Kernel.get(this, "customerManagedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The customer managed key of the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerManagedKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customerManagedKey", value);
    }

    /**
     * The ARN of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataProtectionSettingsArn() {
        return software.amazon.jsii.Kernel.get(this, "dataProtectionSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataProtectionSettingsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataProtectionSettingsArn", value);
    }

    /**
     * The name of the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * The type and resources of the underlying instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type and resources of the underlying instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceType", value);
    }

    /**
     * The ARN of the IP access settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpAccessSettingsArn() {
        return software.amazon.jsii.Kernel.get(this, "ipAccessSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IP access settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpAccessSettingsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipAccessSettingsArn", value);
    }

    /**
     * The maximum number of concurrent sessions for the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentSessions() {
        return software.amazon.jsii.Kernel.get(this, "maxConcurrentSessions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of concurrent sessions for the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxConcurrentSessions(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxConcurrentSessions", value);
    }

    /**
     * The ARN of the network settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNetworkSettingsArn() {
        return software.amazon.jsii.Kernel.get(this, "networkSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the network settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkSettingsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "networkSettingsArn", value);
    }

    /**
     * The tags to add to the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to add to the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The ARN of the trust store that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTrustStoreArn() {
        return software.amazon.jsii.Kernel.get(this, "trustStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the trust store that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrustStoreArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trustStoreArn", value);
    }

    /**
     * The ARN of the user access logging settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserAccessLoggingSettingsArn() {
        return software.amazon.jsii.Kernel.get(this, "userAccessLoggingSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the user access logging settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserAccessLoggingSettingsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userAccessLoggingSettingsArn", value);
    }

    /**
     * The ARN of the user settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserSettingsArn() {
        return software.amazon.jsii.Kernel.get(this, "userSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the user settings that is associated with the web portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserSettingsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userSettingsArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.workspacesweb.CfnPortal}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.workspacesweb.CfnPortal> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.workspacesweb.CfnPortalProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The additional encryption context of the portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-additionalencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-additionalencryptioncontext</a>
         * @param additionalEncryptionContext The additional encryption context of the portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(final java.util.Map<java.lang.String, java.lang.String> additionalEncryptionContext) {
            this.props().additionalEncryptionContext(additionalEncryptionContext);
            return this;
        }
        /**
         * The additional encryption context of the portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-additionalencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-additionalencryptioncontext</a>
         * @param additionalEncryptionContext The additional encryption context of the portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(final software.amazon.awscdk.IResolvable additionalEncryptionContext) {
            this.props().additionalEncryptionContext(additionalEncryptionContext);
            return this;
        }

        /**
         * The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code> .
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider (IdP). User and group access to your web portal is controlled through your IdP. You need to include an IdP resource in your template to integrate your IdP with your web portal. Completing the configuration for your IdP requires exchanging WorkSpaces Secure Browser’s SP metadata with your IdP’s IdP metadata. If your IdP requires the SP metadata first before returning the IdP metadata, you should follow these steps:
         * <p>
         * <ol>
         * <li>Create and deploy a CloudFormation template with a <code>Standard</code> portal with no <code>IdentityProvider</code> resource.</li>
         * <li>Retrieve the SP metadata using <code>Fn:GetAtt</code> , the WorkSpaces Secure Browser console, or by the calling the <code>GetPortalServiceProviderMetadata</code> API.</li>
         * <li>Submit the data to your IdP.</li>
         * <li>Add an <code>IdentityProvider</code> resource to your CloudFormation template.</li>
         * </ol>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through AWS IAM Identity Center . They provide additional features, such as IdP-initiated authentication. Identity sources (including external identity provider integration) and other identity provider information must be configured in IAM Identity Center . User and group assignment must be done through the WorkSpaces Secure Browser console. These cannot be configured in CloudFormation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-authenticationtype</a>
         * @param authenticationType The type of authentication integration points used when signing into the web portal. Defaults to <code>Standard</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(final java.lang.String authenticationType) {
            this.props().authenticationType(authenticationType);
            return this;
        }

        /**
         * The ARN of the browser settings that is associated with this web portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-browsersettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-browsersettingsarn</a>
         * @param browserSettingsArn The ARN of the browser settings that is associated with this web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder browserSettingsArn(final java.lang.String browserSettingsArn) {
            this.props().browserSettingsArn(browserSettingsArn);
            return this;
        }

        /**
         * The customer managed key of the web portal.
         * <p>
         * <em>Pattern</em> : <code>^arn:[\w+=\/,.&#64;-]+:kms:[a-zA-Z0-9\-]*:[a-zA-Z0-9]{1,12}:key\/[a-zA-Z0-9-]+$</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-customermanagedkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-customermanagedkey</a>
         * @param customerManagedKey The customer managed key of the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerManagedKey(final java.lang.String customerManagedKey) {
            this.props().customerManagedKey(customerManagedKey);
            return this;
        }

        /**
         * The ARN of the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-dataprotectionsettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-dataprotectionsettingsarn</a>
         * @param dataProtectionSettingsArn The ARN of the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionSettingsArn(final java.lang.String dataProtectionSettingsArn) {
            this.props().dataProtectionSettingsArn(dataProtectionSettingsArn);
            return this;
        }

        /**
         * The name of the web portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-displayname</a>
         * @param displayName The name of the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * The type and resources of the underlying instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-instancetype</a>
         * @param instanceType The type and resources of the underlying instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        /**
         * The ARN of the IP access settings that is associated with the web portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-ipaccesssettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-ipaccesssettingsarn</a>
         * @param ipAccessSettingsArn The ARN of the IP access settings that is associated with the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAccessSettingsArn(final java.lang.String ipAccessSettingsArn) {
            this.props().ipAccessSettingsArn(ipAccessSettingsArn);
            return this;
        }

        /**
         * The maximum number of concurrent sessions for the portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-maxconcurrentsessions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-maxconcurrentsessions</a>
         * @param maxConcurrentSessions The maximum number of concurrent sessions for the portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrentSessions(final java.lang.Number maxConcurrentSessions) {
            this.props().maxConcurrentSessions(maxConcurrentSessions);
            return this;
        }

        /**
         * The ARN of the network settings that is associated with the web portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-networksettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-networksettingsarn</a>
         * @param networkSettingsArn The ARN of the network settings that is associated with the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkSettingsArn(final java.lang.String networkSettingsArn) {
            this.props().networkSettingsArn(networkSettingsArn);
            return this;
        }

        /**
         * The tags to add to the web portal.
         * <p>
         * A tag is a key-value pair.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-tags</a>
         * @param tags The tags to add to the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The ARN of the trust store that is associated with the web portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-truststorearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-truststorearn</a>
         * @param trustStoreArn The ARN of the trust store that is associated with the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trustStoreArn(final java.lang.String trustStoreArn) {
            this.props().trustStoreArn(trustStoreArn);
            return this;
        }

        /**
         * The ARN of the user access logging settings that is associated with the web portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-useraccessloggingsettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-useraccessloggingsettingsarn</a>
         * @param userAccessLoggingSettingsArn The ARN of the user access logging settings that is associated with the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAccessLoggingSettingsArn(final java.lang.String userAccessLoggingSettingsArn) {
            this.props().userAccessLoggingSettingsArn(userAccessLoggingSettingsArn);
            return this;
        }

        /**
         * The ARN of the user settings that is associated with the web portal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-usersettingsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-portal.html#cfn-workspacesweb-portal-usersettingsarn</a>
         * @param userSettingsArn The ARN of the user settings that is associated with the web portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userSettingsArn(final java.lang.String userSettingsArn) {
            this.props().userSettingsArn(userSettingsArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.workspacesweb.CfnPortal}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.workspacesweb.CfnPortal build() {
            return new software.amazon.awscdk.services.workspacesweb.CfnPortal(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.workspacesweb.CfnPortalProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.workspacesweb.CfnPortalProps.Builder();
            }
            return this.props;
        }
    }
}
