/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.cxapi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.cloud_assembly_schema.ArtifactManifest;
import software.amazon.awscdk.cloud_assembly_schema.ArtifactType;
import software.amazon.awscdk.cloud_assembly_schema.AssetManifestProperties;
import software.amazon.awscdk.cloud_assembly_schema.AwsCloudFormationStackProperties;
import software.amazon.awscdk.cloud_assembly_schema.BootstrapRole;
import software.amazon.awscdk.cloud_assembly_schema.FeatureFlagReportProperties;
import software.amazon.awscdk.cloud_assembly_schema.MetadataEntry;
import software.amazon.awscdk.cloud_assembly_schema.NestedCloudAssemblyProperties;
import software.amazon.awscdk.cloud_assembly_schema.TreeArtifactProperties;
import software.amazon.awscdk.cxapi.CloudArtifact;
import software.amazon.awscdk.cxapi.CloudAssembly;
import software.amazon.awscdk.cxapi.Environment;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.cx_api.CloudFormationStackArtifact")
public class CloudFormationStackArtifact
extends CloudArtifact {
    protected CloudFormationStackArtifact(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationStackArtifact(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudFormationStackArtifact(@NotNull CloudAssembly assembly, @NotNull String artifactId, @NotNull ArtifactManifest artifact) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(assembly, "assembly is required"), Objects.requireNonNull(artifactId, "artifactId is required"), Objects.requireNonNull(artifact, "artifact is required")});
    }

    @NotNull
    public static Boolean isCloudFormationStackArtifact(@NotNull Object art) {
        return (Boolean)JsiiObject.jsiiStaticCall(CloudFormationStackArtifact.class, (String)"isCloudFormationStackArtifact", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{art});
    }

    @NotNull
    public List<Object> getAssets() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"assets", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getDisplayName() {
        return (String)Kernel.get((Object)((Object)this), (String)"displayName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Environment getEnvironment() {
        return (Environment)Kernel.get((Object)((Object)this), (String)"environment", (NativeType)NativeType.forClass(Environment.class));
    }

    @NotNull
    public String getOriginalName() {
        return (String)Kernel.get((Object)((Object)this), (String)"originalName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"parameters", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getStackName() {
        return (String)Kernel.get((Object)((Object)this), (String)"stackName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Map<String, String> getTags() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Object getTemplate() {
        return Kernel.get((Object)((Object)this), (String)"template", (NativeType)NativeType.forClass(Object.class));
    }

    @NotNull
    public String getTemplateFile() {
        return (String)Kernel.get((Object)((Object)this), (String)"templateFile", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getTemplateFullPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"templateFullPath", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Map<String, Object> getAssumeRoleAdditionalOptions() {
        return Optional.ofNullable((Map)Kernel.get((Object)((Object)this), (String)"assumeRoleAdditionalOptions", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public String getAssumeRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"assumeRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getAssumeRoleExternalId() {
        return (String)Kernel.get((Object)((Object)this), (String)"assumeRoleExternalId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getBootstrapStackVersionSsmParameter() {
        return (String)Kernel.get((Object)((Object)this), (String)"bootstrapStackVersionSsmParameter", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public String getCloudFormationExecutionRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"cloudFormationExecutionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public BootstrapRole getLookupRole() {
        return (BootstrapRole)Kernel.get((Object)((Object)this), (String)"lookupRole", (NativeType)NativeType.forClass(BootstrapRole.class));
    }

    @Nullable
    public List<String> getNotificationArns() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"notificationArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public Number getRequiresBootstrapStackVersion() {
        return (Number)Kernel.get((Object)((Object)this), (String)"requiresBootstrapStackVersion", (NativeType)NativeType.forClass(Number.class));
    }

    @Nullable
    public String getStackTemplateAssetObjectUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"stackTemplateAssetObjectUrl", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public Boolean getTerminationProtection() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"terminationProtection", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Nullable
    public Boolean getValidateOnSynth() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"validateOnSynth", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CloudFormationStackArtifact> {
        private final CloudAssembly assembly;
        private final String artifactId;
        private final ArtifactManifest.Builder artifact;

        public static Builder create(CloudAssembly assembly, String artifactId) {
            return new Builder(assembly, artifactId);
        }

        private Builder(CloudAssembly assembly, String artifactId) {
            this.assembly = assembly;
            this.artifactId = artifactId;
            this.artifact = new ArtifactManifest.Builder();
        }

        public Builder type(ArtifactType type) {
            this.artifact.type(type);
            return this;
        }

        public Builder dependencies(List<String> dependencies) {
            this.artifact.dependencies(dependencies);
            return this;
        }

        public Builder displayName(String displayName) {
            this.artifact.displayName(displayName);
            return this;
        }

        public Builder environment(String environment) {
            this.artifact.environment(environment);
            return this;
        }

        public Builder metadata(Map<String, ? extends List<? extends MetadataEntry>> metadata) {
            this.artifact.metadata(metadata);
            return this;
        }

        public Builder properties(AwsCloudFormationStackProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(AssetManifestProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(TreeArtifactProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(NestedCloudAssemblyProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public Builder properties(FeatureFlagReportProperties properties) {
            this.artifact.properties(properties);
            return this;
        }

        public CloudFormationStackArtifact build() {
            return new CloudFormationStackArtifact(this.assembly, this.artifactId, this.artifact.build());
        }
    }
}

