/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appconfig;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.appconfig.ConfigurationProps;
import software.amazon.awscdk.services.appconfig.ConfigurationSource;
import software.amazon.awscdk.services.appconfig.ConfigurationType;
import software.amazon.awscdk.services.appconfig.DeletionProtectionCheck;
import software.amazon.awscdk.services.appconfig.IApplication;
import software.amazon.awscdk.services.appconfig.IDeploymentStrategy;
import software.amazon.awscdk.services.appconfig.IEnvironment;
import software.amazon.awscdk.services.appconfig.IValidator;
import software.amazon.awscdk.services.appconfig.SourcedConfigurationProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appconfig.SourcedConfigurationProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface SourcedConfigurationProps
extends JsiiSerializable,
ConfigurationProps {
    @NotNull
    public ConfigurationSource getLocation();

    @Nullable
    default public IRole getRetrievalRole() {
        return null;
    }

    @Nullable
    default public String getVersionNumber() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SourcedConfigurationProps> {
        ConfigurationSource location;
        IRole retrievalRole;
        String versionNumber;
        IApplication application;
        DeletionProtectionCheck deletionProtectionCheck;
        IKey deploymentKey;
        IDeploymentStrategy deploymentStrategy;
        List<IEnvironment> deployTo;
        String description;
        String name;
        ConfigurationType type;
        List<IValidator> validators;

        public Builder location(ConfigurationSource location) {
            this.location = location;
            return this;
        }

        public Builder retrievalRole(IRole retrievalRole) {
            this.retrievalRole = retrievalRole;
            return this;
        }

        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder application(IApplication application) {
            this.application = application;
            return this;
        }

        public Builder deletionProtectionCheck(DeletionProtectionCheck deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
            return this;
        }

        public Builder deploymentKey(IKey deploymentKey) {
            this.deploymentKey = deploymentKey;
            return this;
        }

        public Builder deploymentStrategy(IDeploymentStrategy deploymentStrategy) {
            this.deploymentStrategy = deploymentStrategy;
            return this;
        }

        public Builder deployTo(List<? extends IEnvironment> deployTo) {
            this.deployTo = deployTo;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(ConfigurationType type) {
            this.type = type;
            return this;
        }

        public Builder validators(List<? extends IValidator> validators) {
            this.validators = validators;
            return this;
        }

        public SourcedConfigurationProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

