/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.batch.EcsJobDefinitionProps;
import software.amazon.awscdk.services.batch.IEcsContainerDefinition;
import software.amazon.awscdk.services.batch.IJobDefinition;
import software.amazon.awscdk.services.batch.IJobQueue;
import software.amazon.awscdk.services.batch.RetryStrategy;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.EcsJobDefinition")
public class EcsJobDefinition
extends Resource
implements IJobDefinition {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(EcsJobDefinition.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected EcsJobDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsJobDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EcsJobDefinition(@NotNull Construct scope, @NotNull String id, @NotNull EcsJobDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IJobDefinition fromJobDefinitionArn(@NotNull Construct scope, @NotNull String id, @NotNull String jobDefinitionArn) {
        return (IJobDefinition)JsiiObject.jsiiStaticCall(EcsJobDefinition.class, (String)"fromJobDefinitionArn", (NativeType)NativeType.forClass(IJobDefinition.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required")});
    }

    @Override
    public void addRetryStrategy(@NotNull RetryStrategy strategy) {
        Kernel.call((Object)this, (String)"addRetryStrategy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(strategy, "strategy is required")});
    }

    public void grantSubmitJob(@NotNull IGrantable identity, @NotNull IJobQueue queue) {
        Kernel.call((Object)this, (String)"grantSubmitJob", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(identity, "identity is required"), Objects.requireNonNull(queue, "queue is required")});
    }

    @NotNull
    public IEcsContainerDefinition getContainer() {
        return (IEcsContainerDefinition)Kernel.get((Object)this, (String)"container", (NativeType)NativeType.forClass(IEcsContainerDefinition.class));
    }

    @Override
    @NotNull
    public String getJobDefinitionArn() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getJobDefinitionName() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public List<RetryStrategy> getRetryStrategies() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"retryStrategies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(RetryStrategy.class))));
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public Boolean getPropagateTags() {
        return (Boolean)Kernel.get((Object)this, (String)"propagateTags", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Number getRetryAttempts() {
        return (Number)Kernel.get((Object)this, (String)"retryAttempts", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Number getSchedulingPriority() {
        return (Number)Kernel.get((Object)this, (String)"schedulingPriority", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Duration.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsJobDefinition> {
        private final Construct scope;
        private final String id;
        private final EcsJobDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EcsJobDefinitionProps.Builder();
        }

        public Builder jobDefinitionName(String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        public Builder parameters(Map<String, ? extends Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder retryStrategies(List<? extends RetryStrategy> retryStrategies) {
            this.props.retryStrategies(retryStrategies);
            return this;
        }

        public Builder schedulingPriority(Number schedulingPriority) {
            this.props.schedulingPriority(schedulingPriority);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder container(IEcsContainerDefinition container) {
            this.props.container(container);
            return this;
        }

        public Builder propagateTags(Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public EcsJobDefinition build() {
            return new EcsJobDefinition(this.scope, this.id, this.props.build());
        }
    }
}

