/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cassandra;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.cassandra.CfnTable;
import software.amazon.awscdk.services.cassandra.CfnTableProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable")
public class CfnTable
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTable.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnTable(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTable(@NotNull Construct scope, @NotNull String id, @NotNull CfnTableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getKeyspaceName() {
        return (String)Kernel.get((Object)this, (String)"keyspaceName", (NativeType)NativeType.forClass(String.class));
    }

    public void setKeyspaceName(@NotNull String value) {
        Kernel.set((Object)this, (String)"keyspaceName", (Object)Objects.requireNonNull(value, "keyspaceName is required"));
    }

    @NotNull
    public Object getPartitionKeyColumns() {
        return Kernel.get((Object)this, (String)"partitionKeyColumns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPartitionKeyColumns(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"partitionKeyColumns", (Object)Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    public void setPartitionKeyColumns(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ColumnProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"partitionKeyColumns", Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    @Nullable
    public Object getAutoScalingSpecifications() {
        return Kernel.get((Object)this, (String)"autoScalingSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoScalingSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoScalingSpecifications", (Object)value);
    }

    public void setAutoScalingSpecifications(@Nullable AutoScalingSpecificationProperty value) {
        Kernel.set((Object)this, (String)"autoScalingSpecifications", (Object)value);
    }

    @Nullable
    public Object getBillingMode() {
        return Kernel.get((Object)this, (String)"billingMode", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBillingMode(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"billingMode", (Object)value);
    }

    public void setBillingMode(@Nullable BillingModeProperty value) {
        Kernel.set((Object)this, (String)"billingMode", (Object)value);
    }

    @Nullable
    public Object getCdcSpecification() {
        return Kernel.get((Object)this, (String)"cdcSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCdcSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"cdcSpecification", (Object)value);
    }

    public void setCdcSpecification(@Nullable CdcSpecificationProperty value) {
        Kernel.set((Object)this, (String)"cdcSpecification", (Object)value);
    }

    @Nullable
    public Object getClientSideTimestampsEnabled() {
        return Kernel.get((Object)this, (String)"clientSideTimestampsEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClientSideTimestampsEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"clientSideTimestampsEnabled", (Object)value);
    }

    public void setClientSideTimestampsEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"clientSideTimestampsEnabled", (Object)value);
    }

    @Nullable
    public Object getClusteringKeyColumns() {
        return Kernel.get((Object)this, (String)"clusteringKeyColumns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setClusteringKeyColumns(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"clusteringKeyColumns", (Object)value);
    }

    public void setClusteringKeyColumns(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ClusteringKeyColumnProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ClusteringKeyColumnProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"clusteringKeyColumns", value);
    }

    @Nullable
    public Number getDefaultTimeToLive() {
        return (Number)Kernel.get((Object)this, (String)"defaultTimeToLive", (NativeType)NativeType.forClass(Number.class));
    }

    public void setDefaultTimeToLive(@Nullable Number value) {
        Kernel.set((Object)this, (String)"defaultTimeToLive", (Object)value);
    }

    @Nullable
    public Object getEncryptionSpecification() {
        return Kernel.get((Object)this, (String)"encryptionSpecification", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryptionSpecification(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"encryptionSpecification", (Object)value);
    }

    public void setEncryptionSpecification(@Nullable EncryptionSpecificationProperty value) {
        Kernel.set((Object)this, (String)"encryptionSpecification", (Object)value);
    }

    @Nullable
    public Object getPointInTimeRecoveryEnabled() {
        return Kernel.get((Object)this, (String)"pointInTimeRecoveryEnabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPointInTimeRecoveryEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"pointInTimeRecoveryEnabled", (Object)value);
    }

    public void setPointInTimeRecoveryEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"pointInTimeRecoveryEnabled", (Object)value);
    }

    @Nullable
    public Object getRegularColumns() {
        return Kernel.get((Object)this, (String)"regularColumns", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRegularColumns(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"regularColumns", (Object)value);
    }

    public void setRegularColumns(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ColumnProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"regularColumns", value);
    }

    @Nullable
    public Object getReplicaSpecifications() {
        return Kernel.get((Object)this, (String)"replicaSpecifications", (NativeType)NativeType.forClass(Object.class));
    }

    public void setReplicaSpecifications(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"replicaSpecifications", (Object)value);
    }

    public void setReplicaSpecifications(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof ReplicaSpecificationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cassandra.CfnTable.ReplicaSpecificationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"replicaSpecifications", value);
    }

    @Nullable
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    public void setTableName(@Nullable String value) {
        Kernel.set((Object)this, (String)"tableName", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.ColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ColumnProperty
    extends JsiiSerializable {
        @NotNull
        public String getColumnName();

        @NotNull
        public String getColumnType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ColumnProperty> {
            String columnName;
            String columnType;

            public Builder columnName(String columnName) {
                this.columnName = columnName;
                return this;
            }

            public Builder columnType(String columnType) {
                this.columnType = columnType;
                return this;
            }

            public ColumnProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.ClusteringKeyColumnProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusteringKeyColumnProperty
    extends JsiiSerializable {
        @NotNull
        public Object getColumn();

        @Nullable
        default public String getOrderBy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusteringKeyColumnProperty> {
            Object column;
            String orderBy;

            public Builder column(IResolvable column) {
                this.column = column;
                return this;
            }

            public Builder column(ColumnProperty column) {
                this.column = column;
                return this;
            }

            public Builder orderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public ClusteringKeyColumnProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.ReplicaSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ReplicaSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getRegion();

        @Nullable
        default public Object getReadCapacityAutoScaling() {
            return null;
        }

        @Nullable
        default public Number getReadCapacityUnits() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ReplicaSpecificationProperty> {
            String region;
            Object readCapacityAutoScaling;
            Number readCapacityUnits;

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder readCapacityAutoScaling(IResolvable readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            public Builder readCapacityAutoScaling(AutoScalingSettingProperty readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            public Builder readCapacityUnits(Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            public ReplicaSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTable> {
        private final Construct scope;
        private final String id;
        private final CfnTableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTableProps.Builder();
        }

        public Builder keyspaceName(String keyspaceName) {
            this.props.keyspaceName(keyspaceName);
            return this;
        }

        public Builder partitionKeyColumns(IResolvable partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }

        public Builder partitionKeyColumns(List<? extends Object> partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }

        public Builder autoScalingSpecifications(IResolvable autoScalingSpecifications) {
            this.props.autoScalingSpecifications(autoScalingSpecifications);
            return this;
        }

        public Builder autoScalingSpecifications(AutoScalingSpecificationProperty autoScalingSpecifications) {
            this.props.autoScalingSpecifications(autoScalingSpecifications);
            return this;
        }

        public Builder billingMode(IResolvable billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder billingMode(BillingModeProperty billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        public Builder cdcSpecification(IResolvable cdcSpecification) {
            this.props.cdcSpecification(cdcSpecification);
            return this;
        }

        public Builder cdcSpecification(CdcSpecificationProperty cdcSpecification) {
            this.props.cdcSpecification(cdcSpecification);
            return this;
        }

        public Builder clientSideTimestampsEnabled(Boolean clientSideTimestampsEnabled) {
            this.props.clientSideTimestampsEnabled(clientSideTimestampsEnabled);
            return this;
        }

        public Builder clientSideTimestampsEnabled(IResolvable clientSideTimestampsEnabled) {
            this.props.clientSideTimestampsEnabled(clientSideTimestampsEnabled);
            return this;
        }

        public Builder clusteringKeyColumns(IResolvable clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }

        public Builder clusteringKeyColumns(List<? extends Object> clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }

        public Builder defaultTimeToLive(Number defaultTimeToLive) {
            this.props.defaultTimeToLive(defaultTimeToLive);
            return this;
        }

        public Builder encryptionSpecification(IResolvable encryptionSpecification) {
            this.props.encryptionSpecification(encryptionSpecification);
            return this;
        }

        public Builder encryptionSpecification(EncryptionSpecificationProperty encryptionSpecification) {
            this.props.encryptionSpecification(encryptionSpecification);
            return this;
        }

        public Builder pointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }

        public Builder pointInTimeRecoveryEnabled(IResolvable pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }

        public Builder regularColumns(IResolvable regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }

        public Builder regularColumns(List<? extends Object> regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }

        public Builder replicaSpecifications(IResolvable replicaSpecifications) {
            this.props.replicaSpecifications(replicaSpecifications);
            return this;
        }

        public Builder replicaSpecifications(List<? extends Object> replicaSpecifications) {
            this.props.replicaSpecifications(replicaSpecifications);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnTable build() {
            return new CfnTable(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.TargetTrackingScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetTrackingScalingPolicyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getTargetValue();

        @Nullable
        default public Object getDisableScaleIn() {
            return null;
        }

        @Nullable
        default public Number getScaleInCooldown() {
            return null;
        }

        @Nullable
        default public Number getScaleOutCooldown() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetTrackingScalingPolicyConfigurationProperty> {
            Number targetValue;
            Object disableScaleIn;
            Number scaleInCooldown;
            Number scaleOutCooldown;

            public Builder targetValue(Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            public Builder disableScaleIn(Boolean disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            public Builder disableScaleIn(IResolvable disableScaleIn) {
                this.disableScaleIn = disableScaleIn;
                return this;
            }

            public Builder scaleInCooldown(Number scaleInCooldown) {
                this.scaleInCooldown = scaleInCooldown;
                return this;
            }

            public Builder scaleOutCooldown(Number scaleOutCooldown) {
                this.scaleOutCooldown = scaleOutCooldown;
                return this;
            }

            public TargetTrackingScalingPolicyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.ScalingPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingPolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getTargetTrackingScalingPolicyConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingPolicyProperty> {
            Object targetTrackingScalingPolicyConfiguration;

            public Builder targetTrackingScalingPolicyConfiguration(IResolvable targetTrackingScalingPolicyConfiguration) {
                this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
                return this;
            }

            public Builder targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty targetTrackingScalingPolicyConfiguration) {
                this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
                return this;
            }

            public ScalingPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisionedThroughputProperty
    extends JsiiSerializable {
        @NotNull
        public Number getReadCapacityUnits();

        @NotNull
        public Number getWriteCapacityUnits();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProvisionedThroughputProperty> {
            Number readCapacityUnits;
            Number writeCapacityUnits;

            public Builder readCapacityUnits(Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            public Builder writeCapacityUnits(Number writeCapacityUnits) {
                this.writeCapacityUnits = writeCapacityUnits;
                return this;
            }

            public ProvisionedThroughputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.EncryptionSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getEncryptionType();

        @Nullable
        default public String getKmsKeyIdentifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionSpecificationProperty> {
            String encryptionType;
            String kmsKeyIdentifier;

            public Builder encryptionType(String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            public Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
                this.kmsKeyIdentifier = kmsKeyIdentifier;
                return this;
            }

            public EncryptionSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.CdcSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CdcSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getStatus();

        @Nullable
        default public String getViewType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CdcSpecificationProperty> {
            String status;
            String viewType;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder viewType(String viewType) {
                this.viewType = viewType;
                return this;
            }

            public CdcSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.BillingModeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BillingModeProperty
    extends JsiiSerializable {
        @NotNull
        public String getMode();

        @Nullable
        default public Object getProvisionedThroughput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BillingModeProperty> {
            String mode;
            Object provisionedThroughput;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder provisionedThroughput(IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public Builder provisionedThroughput(ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            public BillingModeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.AutoScalingSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getReadCapacityAutoScaling() {
            return null;
        }

        @Nullable
        default public Object getWriteCapacityAutoScaling() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingSpecificationProperty> {
            Object readCapacityAutoScaling;
            Object writeCapacityAutoScaling;

            public Builder readCapacityAutoScaling(IResolvable readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            public Builder readCapacityAutoScaling(AutoScalingSettingProperty readCapacityAutoScaling) {
                this.readCapacityAutoScaling = readCapacityAutoScaling;
                return this;
            }

            public Builder writeCapacityAutoScaling(IResolvable writeCapacityAutoScaling) {
                this.writeCapacityAutoScaling = writeCapacityAutoScaling;
                return this;
            }

            public Builder writeCapacityAutoScaling(AutoScalingSettingProperty writeCapacityAutoScaling) {
                this.writeCapacityAutoScaling = writeCapacityAutoScaling;
                return this;
            }

            public AutoScalingSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cassandra.CfnTable.AutoScalingSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingSettingProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoScalingDisabled() {
            return null;
        }

        @Nullable
        default public Number getMaximumUnits() {
            return null;
        }

        @Nullable
        default public Number getMinimumUnits() {
            return null;
        }

        @Nullable
        default public Object getScalingPolicy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingSettingProperty> {
            Object autoScalingDisabled;
            Number maximumUnits;
            Number minimumUnits;
            Object scalingPolicy;

            public Builder autoScalingDisabled(Boolean autoScalingDisabled) {
                this.autoScalingDisabled = autoScalingDisabled;
                return this;
            }

            public Builder autoScalingDisabled(IResolvable autoScalingDisabled) {
                this.autoScalingDisabled = autoScalingDisabled;
                return this;
            }

            public Builder maximumUnits(Number maximumUnits) {
                this.maximumUnits = maximumUnits;
                return this;
            }

            public Builder minimumUnits(Number minimumUnits) {
                this.minimumUnits = minimumUnits;
                return this;
            }

            public Builder scalingPolicy(IResolvable scalingPolicy) {
                this.scalingPolicy = scalingPolicy;
                return this;
            }

            public Builder scalingPolicy(ScalingPolicyProperty scalingPolicy) {
                this.scalingPolicy = scalingPolicy;
                return this;
            }

            public AutoScalingSettingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

