/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codebuild;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.codebuild.CfnFleet;
import software.amazon.awscdk.services.codebuild.CfnFleetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.CfnFleet")
public class CfnFleet
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFleet.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFleet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFleet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFleet(@NotNull Construct scope, @NotNull String id, @Nullable CfnFleetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnFleet(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Nullable
    public Number getBaseCapacity() {
        return (Number)Kernel.get((Object)this, (String)"baseCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    public void setBaseCapacity(@Nullable Number value) {
        Kernel.set((Object)this, (String)"baseCapacity", (Object)value);
    }

    @Nullable
    public Object getComputeConfiguration() {
        return Kernel.get((Object)this, (String)"computeConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setComputeConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"computeConfiguration", (Object)value);
    }

    public void setComputeConfiguration(@Nullable ComputeConfigurationProperty value) {
        Kernel.set((Object)this, (String)"computeConfiguration", (Object)value);
    }

    @Nullable
    public String getComputeType() {
        return (String)Kernel.get((Object)this, (String)"computeType", (NativeType)NativeType.forClass(String.class));
    }

    public void setComputeType(@Nullable String value) {
        Kernel.set((Object)this, (String)"computeType", (Object)value);
    }

    @Nullable
    public String getEnvironmentType() {
        return (String)Kernel.get((Object)this, (String)"environmentType", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnvironmentType(@Nullable String value) {
        Kernel.set((Object)this, (String)"environmentType", (Object)value);
    }

    @Nullable
    public Object getFleetProxyConfiguration() {
        return Kernel.get((Object)this, (String)"fleetProxyConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFleetProxyConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"fleetProxyConfiguration", (Object)value);
    }

    public void setFleetProxyConfiguration(@Nullable ProxyConfigurationProperty value) {
        Kernel.set((Object)this, (String)"fleetProxyConfiguration", (Object)value);
    }

    @Nullable
    public String getFleetServiceRole() {
        return (String)Kernel.get((Object)this, (String)"fleetServiceRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setFleetServiceRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"fleetServiceRole", (Object)value);
    }

    @Nullable
    public Object getFleetVpcConfig() {
        return Kernel.get((Object)this, (String)"fleetVpcConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFleetVpcConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"fleetVpcConfig", (Object)value);
    }

    public void setFleetVpcConfig(@Nullable VpcConfigProperty value) {
        Kernel.set((Object)this, (String)"fleetVpcConfig", (Object)value);
    }

    @Nullable
    public String getImageId() {
        return (String)Kernel.get((Object)this, (String)"imageId", (NativeType)NativeType.forClass(String.class));
    }

    public void setImageId(@Nullable String value) {
        Kernel.set((Object)this, (String)"imageId", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public String getOverflowBehavior() {
        return (String)Kernel.get((Object)this, (String)"overflowBehavior", (NativeType)NativeType.forClass(String.class));
    }

    public void setOverflowBehavior(@Nullable String value) {
        Kernel.set((Object)this, (String)"overflowBehavior", (Object)value);
    }

    @Nullable
    public Object getScalingConfiguration() {
        return Kernel.get((Object)this, (String)"scalingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setScalingConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"scalingConfiguration", (Object)value);
    }

    public void setScalingConfiguration(@Nullable ScalingConfigurationInputProperty value) {
        Kernel.set((Object)this, (String)"scalingConfiguration", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFleet> {
        private final Construct scope;
        private final String id;
        private CfnFleetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder baseCapacity(Number baseCapacity) {
            this.props().baseCapacity(baseCapacity);
            return this;
        }

        public Builder computeConfiguration(IResolvable computeConfiguration) {
            this.props().computeConfiguration(computeConfiguration);
            return this;
        }

        public Builder computeConfiguration(ComputeConfigurationProperty computeConfiguration) {
            this.props().computeConfiguration(computeConfiguration);
            return this;
        }

        public Builder computeType(String computeType) {
            this.props().computeType(computeType);
            return this;
        }

        public Builder environmentType(String environmentType) {
            this.props().environmentType(environmentType);
            return this;
        }

        public Builder fleetProxyConfiguration(IResolvable fleetProxyConfiguration) {
            this.props().fleetProxyConfiguration(fleetProxyConfiguration);
            return this;
        }

        public Builder fleetProxyConfiguration(ProxyConfigurationProperty fleetProxyConfiguration) {
            this.props().fleetProxyConfiguration(fleetProxyConfiguration);
            return this;
        }

        public Builder fleetServiceRole(String fleetServiceRole) {
            this.props().fleetServiceRole(fleetServiceRole);
            return this;
        }

        public Builder fleetVpcConfig(IResolvable fleetVpcConfig) {
            this.props().fleetVpcConfig(fleetVpcConfig);
            return this;
        }

        public Builder fleetVpcConfig(VpcConfigProperty fleetVpcConfig) {
            this.props().fleetVpcConfig(fleetVpcConfig);
            return this;
        }

        public Builder imageId(String imageId) {
            this.props().imageId(imageId);
            return this;
        }

        public Builder name(String name) {
            this.props().name(name);
            return this;
        }

        public Builder overflowBehavior(String overflowBehavior) {
            this.props().overflowBehavior(overflowBehavior);
            return this;
        }

        public Builder scalingConfiguration(IResolvable scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }

        public Builder scalingConfiguration(ScalingConfigurationInputProperty scalingConfiguration) {
            this.props().scalingConfiguration(scalingConfiguration);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnFleet build() {
            return new CfnFleet(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnFleetProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnFleetProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.CfnFleet.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnets() {
            return null;
        }

        @Nullable
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            List<String> securityGroupIds;
            List<String> subnets;
            String vpcId;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.CfnFleet.TargetTrackingScalingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetTrackingScalingConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMetricType() {
            return null;
        }

        @Nullable
        default public Number getTargetValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetTrackingScalingConfigurationProperty> {
            String metricType;
            Number targetValue;

            public Builder metricType(String metricType) {
                this.metricType = metricType;
                return this;
            }

            public Builder targetValue(Number targetValue) {
                this.targetValue = targetValue;
                return this;
            }

            public TargetTrackingScalingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.CfnFleet.ScalingConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScalingConfigurationInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxCapacity() {
            return null;
        }

        @Nullable
        default public String getScalingType() {
            return null;
        }

        @Nullable
        default public Object getTargetTrackingScalingConfigs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScalingConfigurationInputProperty> {
            Number maxCapacity;
            String scalingType;
            Object targetTrackingScalingConfigs;

            public Builder maxCapacity(Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            public Builder scalingType(String scalingType) {
                this.scalingType = scalingType;
                return this;
            }

            public Builder targetTrackingScalingConfigs(IResolvable targetTrackingScalingConfigs) {
                this.targetTrackingScalingConfigs = targetTrackingScalingConfigs;
                return this;
            }

            public Builder targetTrackingScalingConfigs(List<? extends Object> targetTrackingScalingConfigs) {
                this.targetTrackingScalingConfigs = targetTrackingScalingConfigs;
                return this;
            }

            public ScalingConfigurationInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.CfnFleet.ProxyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProxyConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDefaultBehavior() {
            return null;
        }

        @Nullable
        default public Object getOrderedProxyRules() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProxyConfigurationProperty> {
            String defaultBehavior;
            Object orderedProxyRules;

            public Builder defaultBehavior(String defaultBehavior) {
                this.defaultBehavior = defaultBehavior;
                return this;
            }

            public Builder orderedProxyRules(IResolvable orderedProxyRules) {
                this.orderedProxyRules = orderedProxyRules;
                return this;
            }

            public Builder orderedProxyRules(List<? extends Object> orderedProxyRules) {
                this.orderedProxyRules = orderedProxyRules;
                return this;
            }

            public ProxyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.CfnFleet.FleetProxyRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetProxyRuleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getEffect() {
            return null;
        }

        @Nullable
        default public List<String> getEntities() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetProxyRuleProperty> {
            String effect;
            List<String> entities;
            String type;

            public Builder effect(String effect) {
                this.effect = effect;
                return this;
            }

            public Builder entities(List<String> entities) {
                this.entities = entities;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FleetProxyRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_codebuild.CfnFleet.ComputeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComputeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getDisk() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getMachineType() {
            return null;
        }

        @Nullable
        default public Number getMemory() {
            return null;
        }

        @Nullable
        default public Number getVCpu() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComputeConfigurationProperty> {
            Number disk;
            String instanceType;
            String machineType;
            Number memory;
            Number vCpu;

            public Builder disk(Number disk) {
                this.disk = disk;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder machineType(String machineType) {
                this.machineType = machineType;
                return this;
            }

            public Builder memory(Number memory) {
                this.memory = memory;
                return this;
            }

            public Builder vCpu(Number vCpu) {
                this.vCpu = vCpu;
                return this;
            }

            public ComputeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

