/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.deadline;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.deadline.CfnFleet;
import software.amazon.awscdk.services.deadline.CfnFleetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet")
public class CfnFleet
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFleet.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFleet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFleet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFleet(@NotNull Construct scope, @NotNull String id, @NotNull CfnFleetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrCapabilities() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrCapabilities", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrFleetId() {
        return (String)Kernel.get((Object)this, (String)"attrFleetId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Number getAttrWorkerCount() {
        return (Number)Kernel.get((Object)this, (String)"attrWorkerCount", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getConfiguration() {
        return Kernel.get((Object)this, (String)"configuration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"configuration", (Object)Objects.requireNonNull(value, "configuration is required"));
    }

    public void setConfiguration(@NotNull FleetConfigurationProperty value) {
        Kernel.set((Object)this, (String)"configuration", (Object)Objects.requireNonNull(value, "configuration is required"));
    }

    @NotNull
    public String getDisplayName() {
        return (String)Kernel.get((Object)this, (String)"displayName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDisplayName(@NotNull String value) {
        Kernel.set((Object)this, (String)"displayName", (Object)Objects.requireNonNull(value, "displayName is required"));
    }

    @NotNull
    public String getFarmId() {
        return (String)Kernel.get((Object)this, (String)"farmId", (NativeType)NativeType.forClass(String.class));
    }

    public void setFarmId(@NotNull String value) {
        Kernel.set((Object)this, (String)"farmId", (Object)Objects.requireNonNull(value, "farmId is required"));
    }

    @NotNull
    public Number getMaxWorkerCount() {
        return (Number)Kernel.get((Object)this, (String)"maxWorkerCount", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMaxWorkerCount(@NotNull Number value) {
        Kernel.set((Object)this, (String)"maxWorkerCount", (Object)Objects.requireNonNull(value, "maxWorkerCount is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getHostConfiguration() {
        return Kernel.get((Object)this, (String)"hostConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setHostConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"hostConfiguration", (Object)value);
    }

    public void setHostConfiguration(@Nullable HostConfigurationProperty value) {
        Kernel.set((Object)this, (String)"hostConfiguration", (Object)value);
    }

    @Nullable
    public Number getMinWorkerCount() {
        return (Number)Kernel.get((Object)this, (String)"minWorkerCount", (NativeType)NativeType.forClass(Number.class));
    }

    public void setMinWorkerCount(@Nullable Number value) {
        Kernel.set((Object)this, (String)"minWorkerCount", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFleet> {
        private final Construct scope;
        private final String id;
        private final CfnFleetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFleetProps.Builder();
        }

        public Builder configuration(IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder configuration(FleetConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder displayName(String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        public Builder farmId(String farmId) {
            this.props.farmId(farmId);
            return this;
        }

        public Builder maxWorkerCount(Number maxWorkerCount) {
            this.props.maxWorkerCount(maxWorkerCount);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder hostConfiguration(IResolvable hostConfiguration) {
            this.props.hostConfiguration(hostConfiguration);
            return this;
        }

        public Builder hostConfiguration(HostConfigurationProperty hostConfiguration) {
            this.props.hostConfiguration(hostConfiguration);
            return this;
        }

        public Builder minWorkerCount(Number minWorkerCount) {
            this.props.minWorkerCount(minWorkerCount);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnFleet build() {
            return new CfnFleet(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.VCpuCountRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VCpuCountRangeProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMin();

        @Nullable
        default public Number getMax() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VCpuCountRangeProperty> {
            Number min;
            Number max;

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public VCpuCountRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2InstanceMarketOptionsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceManagedEc2InstanceMarketOptionsProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceManagedEc2InstanceMarketOptionsProperty> {
            String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ServiceManagedEc2InstanceMarketOptionsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2InstanceCapabilitiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceManagedEc2InstanceCapabilitiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getCpuArchitectureType();

        @NotNull
        public Object getMemoryMiB();

        @NotNull
        public String getOsFamily();

        @NotNull
        public Object getVCpuCount();

        @Nullable
        default public Object getAcceleratorCapabilities() {
            return null;
        }

        @Nullable
        default public List<String> getAllowedInstanceTypes() {
            return null;
        }

        @Nullable
        default public Object getCustomAmounts() {
            return null;
        }

        @Nullable
        default public Object getCustomAttributes() {
            return null;
        }

        @Nullable
        default public List<String> getExcludedInstanceTypes() {
            return null;
        }

        @Nullable
        default public Object getRootEbsVolume() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceManagedEc2InstanceCapabilitiesProperty> {
            String cpuArchitectureType;
            Object memoryMiB;
            String osFamily;
            Object vCpuCount;
            Object acceleratorCapabilities;
            List<String> allowedInstanceTypes;
            Object customAmounts;
            Object customAttributes;
            List<String> excludedInstanceTypes;
            Object rootEbsVolume;

            public Builder cpuArchitectureType(String cpuArchitectureType) {
                this.cpuArchitectureType = cpuArchitectureType;
                return this;
            }

            public Builder memoryMiB(IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder memoryMiB(MemoryMiBRangeProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder osFamily(String osFamily) {
                this.osFamily = osFamily;
                return this;
            }

            public Builder vCpuCount(IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public Builder vCpuCount(VCpuCountRangeProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public Builder acceleratorCapabilities(IResolvable acceleratorCapabilities) {
                this.acceleratorCapabilities = acceleratorCapabilities;
                return this;
            }

            public Builder acceleratorCapabilities(AcceleratorCapabilitiesProperty acceleratorCapabilities) {
                this.acceleratorCapabilities = acceleratorCapabilities;
                return this;
            }

            public Builder allowedInstanceTypes(List<String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            public Builder customAmounts(IResolvable customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            public Builder customAmounts(List<? extends Object> customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            public Builder customAttributes(IResolvable customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            public Builder customAttributes(List<? extends Object> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            public Builder excludedInstanceTypes(List<String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            public Builder rootEbsVolume(IResolvable rootEbsVolume) {
                this.rootEbsVolume = rootEbsVolume;
                return this;
            }

            public Builder rootEbsVolume(Ec2EbsVolumeProperty rootEbsVolume) {
                this.rootEbsVolume = rootEbsVolume;
                return this;
            }

            public ServiceManagedEc2InstanceCapabilitiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.ServiceManagedEc2FleetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceManagedEc2FleetConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getInstanceCapabilities();

        @NotNull
        public Object getInstanceMarketOptions();

        @Nullable
        default public String getStorageProfileId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceManagedEc2FleetConfigurationProperty> {
            Object instanceCapabilities;
            Object instanceMarketOptions;
            String storageProfileId;

            public Builder instanceCapabilities(IResolvable instanceCapabilities) {
                this.instanceCapabilities = instanceCapabilities;
                return this;
            }

            public Builder instanceCapabilities(ServiceManagedEc2InstanceCapabilitiesProperty instanceCapabilities) {
                this.instanceCapabilities = instanceCapabilities;
                return this;
            }

            public Builder instanceMarketOptions(IResolvable instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder instanceMarketOptions(ServiceManagedEc2InstanceMarketOptionsProperty instanceMarketOptions) {
                this.instanceMarketOptions = instanceMarketOptions;
                return this;
            }

            public Builder storageProfileId(String storageProfileId) {
                this.storageProfileId = storageProfileId;
                return this;
            }

            public ServiceManagedEc2FleetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.MemoryMiBRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MemoryMiBRangeProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMin();

        @Nullable
        default public Number getMax() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MemoryMiBRangeProperty> {
            Number min;
            Number max;

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public MemoryMiBRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.HostConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HostConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getScriptBody();

        @Nullable
        default public Number getScriptTimeoutSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HostConfigurationProperty> {
            String scriptBody;
            Number scriptTimeoutSeconds;

            public Builder scriptBody(String scriptBody) {
                this.scriptBody = scriptBody;
                return this;
            }

            public Builder scriptTimeoutSeconds(Number scriptTimeoutSeconds) {
                this.scriptTimeoutSeconds = scriptTimeoutSeconds;
                return this;
            }

            public HostConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.FleetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCustomerManaged() {
            return null;
        }

        @Nullable
        default public Object getServiceManagedEc2() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetConfigurationProperty> {
            Object customerManaged;
            Object serviceManagedEc2;

            public Builder customerManaged(IResolvable customerManaged) {
                this.customerManaged = customerManaged;
                return this;
            }

            public Builder customerManaged(CustomerManagedFleetConfigurationProperty customerManaged) {
                this.customerManaged = customerManaged;
                return this;
            }

            public Builder serviceManagedEc2(IResolvable serviceManagedEc2) {
                this.serviceManagedEc2 = serviceManagedEc2;
                return this;
            }

            public Builder serviceManagedEc2(ServiceManagedEc2FleetConfigurationProperty serviceManagedEc2) {
                this.serviceManagedEc2 = serviceManagedEc2;
                return this;
            }

            public FleetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.FleetCapabilitiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetCapabilitiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAmounts() {
            return null;
        }

        @Nullable
        default public Object getAttributes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetCapabilitiesProperty> {
            Object amounts;
            Object attributes;

            public Builder amounts(IResolvable amounts) {
                this.amounts = amounts;
                return this;
            }

            public Builder amounts(List<? extends Object> amounts) {
                this.amounts = amounts;
                return this;
            }

            public Builder attributes(IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder attributes(List<? extends Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            public FleetCapabilitiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.FleetAttributeCapabilityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetAttributeCapabilityProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public List<String> getValues();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetAttributeCapabilityProperty> {
            String name;
            List<String> values;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public FleetAttributeCapabilityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.FleetAmountCapabilityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FleetAmountCapabilityProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMin();

        @NotNull
        public String getName();

        @Nullable
        default public Number getMax() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FleetAmountCapabilityProperty> {
            Number min;
            String name;
            Number max;

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public FleetAmountCapabilityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.Ec2EbsVolumeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface Ec2EbsVolumeProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getIops() {
            return null;
        }

        @Nullable
        default public Number getSizeGiB() {
            return null;
        }

        @Nullable
        default public Number getThroughputMiB() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<Ec2EbsVolumeProperty> {
            Number iops;
            Number sizeGiB;
            Number throughputMiB;

            public Builder iops(Number iops) {
                this.iops = iops;
                return this;
            }

            public Builder sizeGiB(Number sizeGiB) {
                this.sizeGiB = sizeGiB;
                return this;
            }

            public Builder throughputMiB(Number throughputMiB) {
                this.throughputMiB = throughputMiB;
                return this;
            }

            public Ec2EbsVolumeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.CustomerManagedWorkerCapabilitiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomerManagedWorkerCapabilitiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getCpuArchitectureType();

        @NotNull
        public Object getMemoryMiB();

        @NotNull
        public String getOsFamily();

        @NotNull
        public Object getVCpuCount();

        @Nullable
        default public Object getAcceleratorCount() {
            return null;
        }

        @Nullable
        default public Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        @Nullable
        default public List<String> getAcceleratorTypes() {
            return null;
        }

        @Nullable
        default public Object getCustomAmounts() {
            return null;
        }

        @Nullable
        default public Object getCustomAttributes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomerManagedWorkerCapabilitiesProperty> {
            String cpuArchitectureType;
            Object memoryMiB;
            String osFamily;
            Object vCpuCount;
            Object acceleratorCount;
            Object acceleratorTotalMemoryMiB;
            List<String> acceleratorTypes;
            Object customAmounts;
            Object customAttributes;

            public Builder cpuArchitectureType(String cpuArchitectureType) {
                this.cpuArchitectureType = cpuArchitectureType;
                return this;
            }

            public Builder memoryMiB(IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder memoryMiB(MemoryMiBRangeProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            public Builder osFamily(String osFamily) {
                this.osFamily = osFamily;
                return this;
            }

            public Builder vCpuCount(IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public Builder vCpuCount(VCpuCountRangeProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            public Builder acceleratorCount(IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorCount(AcceleratorCountRangeProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRangeProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            public Builder acceleratorTypes(List<String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            public Builder customAmounts(IResolvable customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            public Builder customAmounts(List<? extends Object> customAmounts) {
                this.customAmounts = customAmounts;
                return this;
            }

            public Builder customAttributes(IResolvable customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            public Builder customAttributes(List<? extends Object> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            public CustomerManagedWorkerCapabilitiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.CustomerManagedFleetConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomerManagedFleetConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getMode();

        @NotNull
        public Object getWorkerCapabilities();

        @Nullable
        default public String getStorageProfileId() {
            return null;
        }

        @Nullable
        default public String getTagPropagationMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomerManagedFleetConfigurationProperty> {
            String mode;
            Object workerCapabilities;
            String storageProfileId;
            String tagPropagationMode;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public Builder workerCapabilities(IResolvable workerCapabilities) {
                this.workerCapabilities = workerCapabilities;
                return this;
            }

            public Builder workerCapabilities(CustomerManagedWorkerCapabilitiesProperty workerCapabilities) {
                this.workerCapabilities = workerCapabilities;
                return this;
            }

            public Builder storageProfileId(String storageProfileId) {
                this.storageProfileId = storageProfileId;
                return this;
            }

            public Builder tagPropagationMode(String tagPropagationMode) {
                this.tagPropagationMode = tagPropagationMode;
                return this;
            }

            public CustomerManagedFleetConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorTotalMemoryMiBRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorTotalMemoryMiBRangeProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMin();

        @Nullable
        default public Number getMax() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRangeProperty> {
            Number min;
            Number max;

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public AcceleratorTotalMemoryMiBRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorSelectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorSelectionProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getRuntime() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorSelectionProperty> {
            String name;
            String runtime;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder runtime(String runtime) {
                this.runtime = runtime;
                return this;
            }

            public AcceleratorSelectionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorCountRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorCountRangeProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMin();

        @Nullable
        default public Number getMax() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorCountRangeProperty> {
            Number min;
            Number max;

            public Builder min(Number min) {
                this.min = min;
                return this;
            }

            public Builder max(Number max) {
                this.max = max;
                return this;
            }

            public AcceleratorCountRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_deadline.CfnFleet.AcceleratorCapabilitiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AcceleratorCapabilitiesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSelections();

        @Nullable
        default public Object getCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AcceleratorCapabilitiesProperty> {
            Object selections;
            Object count;

            public Builder selections(IResolvable selections) {
                this.selections = selections;
                return this;
            }

            public Builder selections(List<? extends Object> selections) {
                this.selections = selections;
                return this;
            }

            public Builder count(IResolvable count) {
                this.count = count;
                return this;
            }

            public Builder count(AcceleratorCountRangeProperty count) {
                this.count = count;
                return this;
            }

            public AcceleratorCapabilitiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

