/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rolesanywhere;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.rolesanywhere.CfnProfile;
import software.amazon.awscdk.services.rolesanywhere.CfnProfileProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_rolesanywhere.CfnProfile")
public class CfnProfile
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnProfile.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnProfile(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProfile(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnProfile(@NotNull Construct scope, @NotNull String id, @NotNull CfnProfileProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrProfileArn() {
        return (String)Kernel.get((Object)this, (String)"attrProfileArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProfileId() {
        return (String)Kernel.get((Object)this, (String)"attrProfileId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public List<String> getRoleArns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"roleArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    public void setRoleArns(@NotNull List<String> value) {
        Kernel.set((Object)this, (String)"roleArns", Objects.requireNonNull(value, "roleArns is required"));
    }

    @Nullable
    public Object getAcceptRoleSessionName() {
        return Kernel.get((Object)this, (String)"acceptRoleSessionName", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAcceptRoleSessionName(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"acceptRoleSessionName", (Object)value);
    }

    public void setAcceptRoleSessionName(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"acceptRoleSessionName", (Object)value);
    }

    @Nullable
    public Object getAttributeMappings() {
        return Kernel.get((Object)this, (String)"attributeMappings", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAttributeMappings(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"attributeMappings", (Object)value);
    }

    public void setAttributeMappings(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof AttributeMappingProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.rolesanywhere.CfnProfile.AttributeMappingProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"attributeMappings", value);
    }

    @Nullable
    public Number getDurationSeconds() {
        return (Number)Kernel.get((Object)this, (String)"durationSeconds", (NativeType)NativeType.forClass(Number.class));
    }

    public void setDurationSeconds(@Nullable Number value) {
        Kernel.set((Object)this, (String)"durationSeconds", (Object)value);
    }

    @Nullable
    public Object getEnabled() {
        return Kernel.get((Object)this, (String)"enabled", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnabled(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enabled", (Object)value);
    }

    public void setEnabled(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enabled", (Object)value);
    }

    @Nullable
    public List<String> getManagedPolicyArns() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"managedPolicyArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setManagedPolicyArns(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"managedPolicyArns", value);
    }

    @Nullable
    public Object getRequireInstanceProperties() {
        return Kernel.get((Object)this, (String)"requireInstanceProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRequireInstanceProperties(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"requireInstanceProperties", (Object)value);
    }

    public void setRequireInstanceProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"requireInstanceProperties", (Object)value);
    }

    @Nullable
    public String getSessionPolicy() {
        return (String)Kernel.get((Object)this, (String)"sessionPolicy", (NativeType)NativeType.forClass(String.class));
    }

    public void setSessionPolicy(@Nullable String value) {
        Kernel.set((Object)this, (String)"sessionPolicy", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_rolesanywhere.CfnProfile.AttributeMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AttributeMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getCertificateField();

        @NotNull
        public Object getMappingRules();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AttributeMappingProperty> {
            String certificateField;
            Object mappingRules;

            public Builder certificateField(String certificateField) {
                this.certificateField = certificateField;
                return this;
            }

            public Builder mappingRules(IResolvable mappingRules) {
                this.mappingRules = mappingRules;
                return this;
            }

            public Builder mappingRules(List<? extends Object> mappingRules) {
                this.mappingRules = mappingRules;
                return this;
            }

            public AttributeMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnProfile> {
        private final Construct scope;
        private final String id;
        private final CfnProfileProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnProfileProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder roleArns(List<String> roleArns) {
            this.props.roleArns(roleArns);
            return this;
        }

        public Builder acceptRoleSessionName(Boolean acceptRoleSessionName) {
            this.props.acceptRoleSessionName(acceptRoleSessionName);
            return this;
        }

        public Builder acceptRoleSessionName(IResolvable acceptRoleSessionName) {
            this.props.acceptRoleSessionName(acceptRoleSessionName);
            return this;
        }

        public Builder attributeMappings(IResolvable attributeMappings) {
            this.props.attributeMappings(attributeMappings);
            return this;
        }

        public Builder attributeMappings(List<? extends Object> attributeMappings) {
            this.props.attributeMappings(attributeMappings);
            return this;
        }

        public Builder durationSeconds(Number durationSeconds) {
            this.props.durationSeconds(durationSeconds);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder enabled(IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder managedPolicyArns(List<String> managedPolicyArns) {
            this.props.managedPolicyArns(managedPolicyArns);
            return this;
        }

        public Builder requireInstanceProperties(Boolean requireInstanceProperties) {
            this.props.requireInstanceProperties(requireInstanceProperties);
            return this;
        }

        public Builder requireInstanceProperties(IResolvable requireInstanceProperties) {
            this.props.requireInstanceProperties(requireInstanceProperties);
            return this;
        }

        public Builder sessionPolicy(String sessionPolicy) {
            this.props.sessionPolicy(sessionPolicy);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnProfile build() {
            return new CfnProfile(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_rolesanywhere.CfnProfile.MappingRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MappingRuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getSpecifier();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MappingRuleProperty> {
            String specifier;

            public Builder specifier(String specifier) {
                this.specifier = specifier;
                return this;
            }

            public MappingRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

