/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3express;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.s3express.CfnAccessPoint;
import software.amazon.awscdk.services.s3express.CfnAccessPointProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3express.CfnAccessPoint")
public class CfnAccessPoint
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnAccessPoint.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnAccessPoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAccessPoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnAccessPoint(@NotNull Construct scope, @NotNull String id, @NotNull CfnAccessPointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrNetworkOrigin() {
        return (String)Kernel.get((Object)this, (String)"attrNetworkOrigin", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getBucket() {
        return (String)Kernel.get((Object)this, (String)"bucket", (NativeType)NativeType.forClass(String.class));
    }

    public void setBucket(@NotNull String value) {
        Kernel.set((Object)this, (String)"bucket", (Object)Objects.requireNonNull(value, "bucket is required"));
    }

    @Nullable
    public String getBucketAccountId() {
        return (String)Kernel.get((Object)this, (String)"bucketAccountId", (NativeType)NativeType.forClass(String.class));
    }

    public void setBucketAccountId(@Nullable String value) {
        Kernel.set((Object)this, (String)"bucketAccountId", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getPolicy() {
        return Kernel.get((Object)this, (String)"policy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPolicy(@Nullable Object value) {
        Kernel.set((Object)this, (String)"policy", (Object)value);
    }

    @Nullable
    public Object getPublicAccessBlockConfiguration() {
        return Kernel.get((Object)this, (String)"publicAccessBlockConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPublicAccessBlockConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"publicAccessBlockConfiguration", (Object)value);
    }

    public void setPublicAccessBlockConfiguration(@Nullable PublicAccessBlockConfigurationProperty value) {
        Kernel.set((Object)this, (String)"publicAccessBlockConfiguration", (Object)value);
    }

    @Nullable
    public Object getScope() {
        return Kernel.get((Object)this, (String)"scope", (NativeType)NativeType.forClass(Object.class));
    }

    public void setScope(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"scope", (Object)value);
    }

    public void setScope(@Nullable ScopeProperty value) {
        Kernel.set((Object)this, (String)"scope", (Object)value);
    }

    @Nullable
    public Object getVpcConfiguration() {
        return Kernel.get((Object)this, (String)"vpcConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setVpcConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"vpcConfiguration", (Object)value);
    }

    public void setVpcConfiguration(@Nullable VpcConfigurationProperty value) {
        Kernel.set((Object)this, (String)"vpcConfiguration", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnAccessPoint> {
        private final Construct scope;
        private final String id;
        private final CfnAccessPointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAccessPointProps.Builder();
        }

        public Builder bucket(String bucket) {
            this.props.bucket(bucket);
            return this;
        }

        public Builder bucketAccountId(String bucketAccountId) {
            this.props.bucketAccountId(bucketAccountId);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder policy(Object policy) {
            this.props.policy(policy);
            return this;
        }

        public Builder publicAccessBlockConfiguration(IResolvable publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.props.publicAccessBlockConfiguration(publicAccessBlockConfiguration);
            return this;
        }

        public Builder scope(IResolvable scope) {
            this.props.scope(scope);
            return this;
        }

        public Builder scope(ScopeProperty scope) {
            this.props.scope(scope);
            return this;
        }

        public Builder vpcConfiguration(IResolvable vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        public Builder vpcConfiguration(VpcConfigurationProperty vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        public CfnAccessPoint build() {
            return new CfnAccessPoint(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3express.CfnAccessPoint.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            String vpcId;

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public VpcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3express.CfnAccessPoint.ScopeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScopeProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getPermissions() {
            return null;
        }

        @Nullable
        default public List<String> getPrefixes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScopeProperty> {
            List<String> permissions;
            List<String> prefixes;

            public Builder permissions(List<String> permissions) {
                this.permissions = permissions;
                return this;
            }

            public Builder prefixes(List<String> prefixes) {
                this.prefixes = prefixes;
                return this;
            }

            public ScopeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3express.CfnAccessPoint.PublicAccessBlockConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PublicAccessBlockConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBlockPublicAcls() {
            return null;
        }

        @Nullable
        default public Object getBlockPublicPolicy() {
            return null;
        }

        @Nullable
        default public Object getIgnorePublicAcls() {
            return null;
        }

        @Nullable
        default public Object getRestrictPublicBuckets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PublicAccessBlockConfigurationProperty> {
            Object blockPublicAcls;
            Object blockPublicPolicy;
            Object ignorePublicAcls;
            Object restrictPublicBuckets;

            public Builder blockPublicAcls(Boolean blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicAcls(IResolvable blockPublicAcls) {
                this.blockPublicAcls = blockPublicAcls;
                return this;
            }

            public Builder blockPublicPolicy(Boolean blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder blockPublicPolicy(IResolvable blockPublicPolicy) {
                this.blockPublicPolicy = blockPublicPolicy;
                return this;
            }

            public Builder ignorePublicAcls(Boolean ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder ignorePublicAcls(IResolvable ignorePublicAcls) {
                this.ignorePublicAcls = ignorePublicAcls;
                return this;
            }

            public Builder restrictPublicBuckets(Boolean restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public Builder restrictPublicBuckets(IResolvable restrictPublicBuckets) {
                this.restrictPublicBuckets = restrictPublicBuckets;
                return this;
            }

            public PublicAccessBlockConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

