/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3tables;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.s3tables.CfnTable;
import software.amazon.awscdk.services.s3tables.CfnTableProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3tables.CfnTable")
public class CfnTable
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnTable.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnTable(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnTable(@NotNull Construct scope, @NotNull String id, @NotNull CfnTableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrTableArn() {
        return (String)Kernel.get((Object)this, (String)"attrTableArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrVersionToken() {
        return (String)Kernel.get((Object)this, (String)"attrVersionToken", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrWarehouseLocation() {
        return (String)Kernel.get((Object)this, (String)"attrWarehouseLocation", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getNamespace() {
        return (String)Kernel.get((Object)this, (String)"namespace", (NativeType)NativeType.forClass(String.class));
    }

    public void setNamespace(@NotNull String value) {
        Kernel.set((Object)this, (String)"namespace", (Object)Objects.requireNonNull(value, "namespace is required"));
    }

    @NotNull
    public String getOpenTableFormat() {
        return (String)Kernel.get((Object)this, (String)"openTableFormat", (NativeType)NativeType.forClass(String.class));
    }

    public void setOpenTableFormat(@NotNull String value) {
        Kernel.set((Object)this, (String)"openTableFormat", (Object)Objects.requireNonNull(value, "openTableFormat is required"));
    }

    @NotNull
    public String getTableBucketArn() {
        return (String)Kernel.get((Object)this, (String)"tableBucketArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setTableBucketArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"tableBucketArn", (Object)Objects.requireNonNull(value, "tableBucketArn is required"));
    }

    @NotNull
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    public void setTableName(@NotNull String value) {
        Kernel.set((Object)this, (String)"tableName", (Object)Objects.requireNonNull(value, "tableName is required"));
    }

    @Nullable
    public Object getCompaction() {
        return Kernel.get((Object)this, (String)"compaction", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCompaction(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"compaction", (Object)value);
    }

    public void setCompaction(@Nullable CompactionProperty value) {
        Kernel.set((Object)this, (String)"compaction", (Object)value);
    }

    @Nullable
    public Object getIcebergMetadata() {
        return Kernel.get((Object)this, (String)"icebergMetadata", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIcebergMetadata(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"icebergMetadata", (Object)value);
    }

    public void setIcebergMetadata(@Nullable IcebergMetadataProperty value) {
        Kernel.set((Object)this, (String)"icebergMetadata", (Object)value);
    }

    @Nullable
    public Object getSnapshotManagement() {
        return Kernel.get((Object)this, (String)"snapshotManagement", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSnapshotManagement(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"snapshotManagement", (Object)value);
    }

    public void setSnapshotManagement(@Nullable SnapshotManagementProperty value) {
        Kernel.set((Object)this, (String)"snapshotManagement", (Object)value);
    }

    @Nullable
    public String getWithoutMetadata() {
        return (String)Kernel.get((Object)this, (String)"withoutMetadata", (NativeType)NativeType.forClass(String.class));
    }

    public void setWithoutMetadata(@Nullable String value) {
        Kernel.set((Object)this, (String)"withoutMetadata", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnTable> {
        private final Construct scope;
        private final String id;
        private final CfnTableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnTableProps.Builder();
        }

        public Builder namespace(String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        public Builder openTableFormat(String openTableFormat) {
            this.props.openTableFormat(openTableFormat);
            return this;
        }

        public Builder tableBucketArn(String tableBucketArn) {
            this.props.tableBucketArn(tableBucketArn);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Builder compaction(IResolvable compaction) {
            this.props.compaction(compaction);
            return this;
        }

        public Builder compaction(CompactionProperty compaction) {
            this.props.compaction(compaction);
            return this;
        }

        public Builder icebergMetadata(IResolvable icebergMetadata) {
            this.props.icebergMetadata(icebergMetadata);
            return this;
        }

        public Builder icebergMetadata(IcebergMetadataProperty icebergMetadata) {
            this.props.icebergMetadata(icebergMetadata);
            return this;
        }

        public Builder snapshotManagement(IResolvable snapshotManagement) {
            this.props.snapshotManagement(snapshotManagement);
            return this;
        }

        public Builder snapshotManagement(SnapshotManagementProperty snapshotManagement) {
            this.props.snapshotManagement(snapshotManagement);
            return this;
        }

        public Builder withoutMetadata(String withoutMetadata) {
            this.props.withoutMetadata(withoutMetadata);
            return this;
        }

        public CfnTable build() {
            return new CfnTable(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3tables.CfnTable.SnapshotManagementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SnapshotManagementProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxSnapshotAgeHours() {
            return null;
        }

        @Nullable
        default public Number getMinSnapshotsToKeep() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SnapshotManagementProperty> {
            Number maxSnapshotAgeHours;
            Number minSnapshotsToKeep;
            String status;

            public Builder maxSnapshotAgeHours(Number maxSnapshotAgeHours) {
                this.maxSnapshotAgeHours = maxSnapshotAgeHours;
                return this;
            }

            public Builder minSnapshotsToKeep(Number minSnapshotsToKeep) {
                this.minSnapshotsToKeep = minSnapshotsToKeep;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public SnapshotManagementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3tables.CfnTable.SchemaFieldProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SchemaFieldProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        @Nullable
        default public Object getRequired() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SchemaFieldProperty> {
            String name;
            String type;
            Object required;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder required(Boolean required) {
                this.required = required;
                return this;
            }

            public Builder required(IResolvable required) {
                this.required = required;
                return this;
            }

            public SchemaFieldProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3tables.CfnTable.IcebergSchemaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IcebergSchemaProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSchemaFieldList();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IcebergSchemaProperty> {
            Object schemaFieldList;

            public Builder schemaFieldList(IResolvable schemaFieldList) {
                this.schemaFieldList = schemaFieldList;
                return this;
            }

            public Builder schemaFieldList(List<? extends Object> schemaFieldList) {
                this.schemaFieldList = schemaFieldList;
                return this;
            }

            public IcebergSchemaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3tables.CfnTable.IcebergMetadataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IcebergMetadataProperty
    extends JsiiSerializable {
        @NotNull
        public Object getIcebergSchema();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IcebergMetadataProperty> {
            Object icebergSchema;

            public Builder icebergSchema(IResolvable icebergSchema) {
                this.icebergSchema = icebergSchema;
                return this;
            }

            public Builder icebergSchema(IcebergSchemaProperty icebergSchema) {
                this.icebergSchema = icebergSchema;
                return this;
            }

            public IcebergMetadataProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_s3tables.CfnTable.CompactionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CompactionProperty
    extends JsiiSerializable {
        @Nullable
        default public String getStatus() {
            return null;
        }

        @Nullable
        default public Number getTargetFileSizeMb() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CompactionProperty> {
            String status;
            Number targetFileSizeMb;

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public Builder targetFileSizeMb(Number targetFileSizeMb) {
                this.targetFileSizeMb = targetFileSizeMb;
                return this;
            }

            public CompactionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

