/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.transfer.CfnConnector;
import software.amazon.awscdk.services.transfer.CfnConnectorProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnConnector")
public class CfnConnector
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConnector.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConnector(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnector(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConnector(@NotNull Construct scope, @NotNull String id, @NotNull CfnConnectorProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrConnectorId() {
        return (String)Kernel.get((Object)this, (String)"attrConnectorId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrServiceManagedEgressIpAddresses() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrServiceManagedEgressIpAddresses", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getAccessRole() {
        return (String)Kernel.get((Object)this, (String)"accessRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setAccessRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"accessRole", (Object)Objects.requireNonNull(value, "accessRole is required"));
    }

    @NotNull
    public String getUrl() {
        return (String)Kernel.get((Object)this, (String)"url", (NativeType)NativeType.forClass(String.class));
    }

    public void setUrl(@NotNull String value) {
        Kernel.set((Object)this, (String)"url", (Object)Objects.requireNonNull(value, "url is required"));
    }

    @Nullable
    public Object getAs2Config() {
        return Kernel.get((Object)this, (String)"as2Config", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAs2Config(@Nullable Object value) {
        Kernel.set((Object)this, (String)"as2Config", (Object)value);
    }

    @Nullable
    public String getLoggingRole() {
        return (String)Kernel.get((Object)this, (String)"loggingRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setLoggingRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"loggingRole", (Object)value);
    }

    @Nullable
    public String getSecurityPolicyName() {
        return (String)Kernel.get((Object)this, (String)"securityPolicyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSecurityPolicyName(@Nullable String value) {
        Kernel.set((Object)this, (String)"securityPolicyName", (Object)value);
    }

    @Nullable
    public Object getSftpConfig() {
        return Kernel.get((Object)this, (String)"sftpConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSftpConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sftpConfig", (Object)value);
    }

    public void setSftpConfig(@Nullable SftpConfigProperty value) {
        Kernel.set((Object)this, (String)"sftpConfig", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConnector> {
        private final Construct scope;
        private final String id;
        private final CfnConnectorProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConnectorProps.Builder();
        }

        public Builder accessRole(String accessRole) {
            this.props.accessRole(accessRole);
            return this;
        }

        public Builder url(String url) {
            this.props.url(url);
            return this;
        }

        public Builder as2Config(Object as2Config) {
            this.props.as2Config(as2Config);
            return this;
        }

        public Builder loggingRole(String loggingRole) {
            this.props.loggingRole(loggingRole);
            return this;
        }

        public Builder securityPolicyName(String securityPolicyName) {
            this.props.securityPolicyName(securityPolicyName);
            return this;
        }

        public Builder sftpConfig(IResolvable sftpConfig) {
            this.props.sftpConfig(sftpConfig);
            return this;
        }

        public Builder sftpConfig(SftpConfigProperty sftpConfig) {
            this.props.sftpConfig(sftpConfig);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnConnector build() {
            return new CfnConnector(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnConnector.SftpConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SftpConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxConcurrentConnections() {
            return null;
        }

        @Nullable
        default public List<String> getTrustedHostKeys() {
            return null;
        }

        @Nullable
        default public String getUserSecretId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SftpConfigProperty> {
            Number maxConcurrentConnections;
            List<String> trustedHostKeys;
            String userSecretId;

            public Builder maxConcurrentConnections(Number maxConcurrentConnections) {
                this.maxConcurrentConnections = maxConcurrentConnections;
                return this;
            }

            public Builder trustedHostKeys(List<String> trustedHostKeys) {
                this.trustedHostKeys = trustedHostKeys;
                return this;
            }

            public Builder userSecretId(String userSecretId) {
                this.userSecretId = userSecretId;
                return this;
            }

            public SftpConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_transfer.CfnConnector.As2ConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface As2ConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBasicAuthSecretId() {
            return null;
        }

        @Nullable
        default public String getCompression() {
            return null;
        }

        @Nullable
        default public String getEncryptionAlgorithm() {
            return null;
        }

        @Nullable
        default public String getLocalProfileId() {
            return null;
        }

        @Nullable
        default public String getMdnResponse() {
            return null;
        }

        @Nullable
        default public String getMdnSigningAlgorithm() {
            return null;
        }

        @Nullable
        default public String getMessageSubject() {
            return null;
        }

        @Nullable
        default public String getPartnerProfileId() {
            return null;
        }

        @Nullable
        default public String getPreserveContentType() {
            return null;
        }

        @Nullable
        default public String getSigningAlgorithm() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<As2ConfigProperty> {
            String basicAuthSecretId;
            String compression;
            String encryptionAlgorithm;
            String localProfileId;
            String mdnResponse;
            String mdnSigningAlgorithm;
            String messageSubject;
            String partnerProfileId;
            String preserveContentType;
            String signingAlgorithm;

            public Builder basicAuthSecretId(String basicAuthSecretId) {
                this.basicAuthSecretId = basicAuthSecretId;
                return this;
            }

            public Builder compression(String compression) {
                this.compression = compression;
                return this;
            }

            public Builder encryptionAlgorithm(String encryptionAlgorithm) {
                this.encryptionAlgorithm = encryptionAlgorithm;
                return this;
            }

            public Builder localProfileId(String localProfileId) {
                this.localProfileId = localProfileId;
                return this;
            }

            public Builder mdnResponse(String mdnResponse) {
                this.mdnResponse = mdnResponse;
                return this;
            }

            public Builder mdnSigningAlgorithm(String mdnSigningAlgorithm) {
                this.mdnSigningAlgorithm = mdnSigningAlgorithm;
                return this;
            }

            public Builder messageSubject(String messageSubject) {
                this.messageSubject = messageSubject;
                return this;
            }

            public Builder partnerProfileId(String partnerProfileId) {
                this.partnerProfileId = partnerProfileId;
                return this;
            }

            public Builder preserveContentType(String preserveContentType) {
                this.preserveContentType = preserveContentType;
                return this;
            }

            public Builder signingAlgorithm(String signingAlgorithm) {
                this.signingAlgorithm = signingAlgorithm;
                return this;
            }

            public As2ConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

