package software.amazon.awscdk.pipelines;

/**
 * Options for customizing a single CodeBuild project.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IFileSetProducer source; // the repository source
 * String[] synthCommands; // Commands to synthesize your app
 * String[] installCommands;
 * // Commands to install your toolchain
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         // Standard CodePipeline properties...
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(source)
 *                 .commands(synthCommands)
 *                 .build())
 *         // Configure CodeBuild to use a drop-in Docker replacement.
 *         .codeBuildDefaults(CodeBuildOptions.builder()
 *                 .partialBuildSpec(BuildSpec.fromObject(Map.of(
 *                         "phases", Map.of(
 *                                 "install", Map.of(
 *                                         // Add the shell commands to install your drop-in Docker
 *                                         // replacement to the CodeBuild enviromment.
 *                                         "commands", installCommands)))))
 *                 .buildEnvironment(BuildEnvironment.builder()
 *                         .environmentVariables(Map.of(
 *                                 // Instruct the AWS CDK to use `drop-in-replacement` instead of
 *                                 // `docker` when building / publishing docker images.
 *                                 // e.g., `drop-in-replacement build . -f path/to/Dockerfile`
 *                                 "CDK_DOCKER", BuildEnvironmentVariable.builder().value("drop-in-replacement").build()))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:25.220Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.CodeBuildOptions")
@software.amazon.jsii.Jsii.Proxy(CodeBuildOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeBuildOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Partial build environment, will be combined with other build environments that apply.
     * <p>
     * Default: - Non-privileged build, SMALL instance, LinuxBuildImage.STANDARD_7_0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildEnvironment getBuildEnvironment() {
        return null;
    }

    /**
     * Caching strategy to use.
     * <p>
     * Default: - No cache
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.Cache getCache() {
        return null;
    }

    /**
     * ProjectFileSystemLocation objects for CodeBuild build projects.
     * <p>
     * A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
     * and type of a file system created using Amazon Elastic File System.
     * Requires a vpc to be set and privileged to be set to true.
     * <p>
     * Default: - no file system locations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> getFileSystemLocations() {
        return null;
    }

    /**
     * Information about logs for CodeBuild projects.
     * <p>
     * A CodeBuild project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
     * <p>
     * Default: - no log configuration is set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.LoggingOptions getLogging() {
        return null;
    }

    /**
     * Partial buildspec, will be combined with other buildspecs that apply.
     * <p>
     * The BuildSpec must be available inline--it cannot reference a file
     * on disk.
     * <p>
     * Default: - No initial BuildSpec
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BuildSpec getPartialBuildSpec() {
        return null;
    }

    /**
     * Policy statements to add to role.
     * <p>
     * Default: - No policy statements added to CodeBuild Project Role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicy() {
        return null;
    }

    /**
     * Which security group(s) to associate with the project network interfaces.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - Security group will be automatically created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * Which subnets to use.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - All private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * The number of minutes after which AWS CodeBuild stops the build if it's not complete.
     * <p>
     * For valid values, see the timeoutInMinutes field in the AWS
     * CodeBuild User Guide.
     * <p>
     * Default: Duration.hours(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * The VPC where to create the CodeBuild network interfaces in.
     * <p>
     * Default: - No VPC
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeBuildOptions> {
        software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment;
        software.amazon.awscdk.services.codebuild.Cache cache;
        java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        software.amazon.awscdk.services.codebuild.LoggingOptions logging;
        software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicy;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link CodeBuildOptions#getBuildEnvironment}
         * @param buildEnvironment Partial build environment, will be combined with other build environments that apply.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildEnvironment(software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
            this.buildEnvironment = buildEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getCache}
         * @param cache Caching strategy to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cache(software.amazon.awscdk.services.codebuild.Cache cache) {
            this.cache = cache;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getFileSystemLocations}
         * @param fileSystemLocations ProjectFileSystemLocation objects for CodeBuild build projects.
         *                            A ProjectFileSystemLocation object specifies the identifier, location, mountOptions, mountPoint,
         *                            and type of a file system created using Amazon Elastic File System.
         *                            Requires a vpc to be set and privileged to be set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder fileSystemLocations(java.util.List<? extends software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = (java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation>)fileSystemLocations;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getLogging}
         * @param logging Information about logs for CodeBuild projects.
         *                A CodeBuild project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.codebuild.LoggingOptions logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getPartialBuildSpec}
         * @param partialBuildSpec Partial buildspec, will be combined with other buildspecs that apply.
         *                         The BuildSpec must be available inline--it cannot reference a file
         *                         on disk.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partialBuildSpec(software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec) {
            this.partialBuildSpec = partialBuildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getRolePolicy}
         * @param rolePolicy Policy statements to add to role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rolePolicy(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> rolePolicy) {
            this.rolePolicy = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)rolePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getSecurityGroups}
         * @param securityGroups Which security group(s) to associate with the project network interfaces.
         *                       Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getSubnetSelection}
         * @param subnetSelection Which subnets to use.
         *                        Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getTimeout}
         * @param timeout The number of minutes after which AWS CodeBuild stops the build if it's not complete.
         *                For valid values, see the timeoutInMinutes field in the AWS
         *                CodeBuild User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CodeBuildOptions#getVpc}
         * @param vpc The VPC where to create the CodeBuild network interfaces in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeBuildOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeBuildOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeBuildOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeBuildOptions {
        private final software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment;
        private final software.amazon.awscdk.services.codebuild.Cache cache;
        private final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> fileSystemLocations;
        private final software.amazon.awscdk.services.codebuild.LoggingOptions logging;
        private final software.amazon.awscdk.services.codebuild.BuildSpec partialBuildSpec;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> rolePolicy;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildEnvironment = software.amazon.jsii.Kernel.get(this, "buildEnvironment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildEnvironment.class));
            this.cache = software.amazon.jsii.Kernel.get(this, "cache", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class));
            this.fileSystemLocations = software.amazon.jsii.Kernel.get(this, "fileSystemLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IFileSystemLocation.class)));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.LoggingOptions.class));
            this.partialBuildSpec = software.amazon.jsii.Kernel.get(this, "partialBuildSpec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class));
            this.rolePolicy = software.amazon.jsii.Kernel.get(this, "rolePolicy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildEnvironment = builder.buildEnvironment;
            this.cache = builder.cache;
            this.fileSystemLocations = (java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation>)builder.fileSystemLocations;
            this.logging = builder.logging;
            this.partialBuildSpec = builder.partialBuildSpec;
            this.rolePolicy = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.rolePolicy;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetSelection = builder.subnetSelection;
            this.timeout = builder.timeout;
            this.vpc = builder.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildEnvironment getBuildEnvironment() {
            return this.buildEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.Cache getCache() {
            return this.cache;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codebuild.IFileSystemLocation> getFileSystemLocations() {
            return this.fileSystemLocations;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.LoggingOptions getLogging() {
            return this.logging;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.BuildSpec getPartialBuildSpec() {
            return this.partialBuildSpec;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getRolePolicy() {
            return this.rolePolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildEnvironment() != null) {
                data.set("buildEnvironment", om.valueToTree(this.getBuildEnvironment()));
            }
            if (this.getCache() != null) {
                data.set("cache", om.valueToTree(this.getCache()));
            }
            if (this.getFileSystemLocations() != null) {
                data.set("fileSystemLocations", om.valueToTree(this.getFileSystemLocations()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getPartialBuildSpec() != null) {
                data.set("partialBuildSpec", om.valueToTree(this.getPartialBuildSpec()));
            }
            if (this.getRolePolicy() != null) {
                data.set("rolePolicy", om.valueToTree(this.getRolePolicy()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.CodeBuildOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeBuildOptions.Jsii$Proxy that = (CodeBuildOptions.Jsii$Proxy) o;

            if (this.buildEnvironment != null ? !this.buildEnvironment.equals(that.buildEnvironment) : that.buildEnvironment != null) return false;
            if (this.cache != null ? !this.cache.equals(that.cache) : that.cache != null) return false;
            if (this.fileSystemLocations != null ? !this.fileSystemLocations.equals(that.fileSystemLocations) : that.fileSystemLocations != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.partialBuildSpec != null ? !this.partialBuildSpec.equals(that.partialBuildSpec) : that.partialBuildSpec != null) return false;
            if (this.rolePolicy != null ? !this.rolePolicy.equals(that.rolePolicy) : that.rolePolicy != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.buildEnvironment != null ? this.buildEnvironment.hashCode() : 0;
            result = 31 * result + (this.cache != null ? this.cache.hashCode() : 0);
            result = 31 * result + (this.fileSystemLocations != null ? this.fileSystemLocations.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.partialBuildSpec != null ? this.partialBuildSpec.hashCode() : 0);
            result = 31 * result + (this.rolePolicy != null ? this.rolePolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
