package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a <code>CfnDomainNameAccessAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnDomainNameAccessAssociationProps cfnDomainNameAccessAssociationProps = CfnDomainNameAccessAssociationProps.builder()
 *         .accessAssociationSource("accessAssociationSource")
 *         .accessAssociationSourceType("accessAssociationSourceType")
 *         .domainNameArn("domainNameArn")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:07.968Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnDomainNameAccessAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainNameAccessAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainNameAccessAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the domain name access association source.
     * <p>
     * For a <code>VPCE</code> , the value is the VPC endpoint ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-accessassociationsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-accessassociationsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessAssociationSource();

    /**
     * The type of the domain name access association source.
     * <p>
     * Only <code>VPCE</code> is currently supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-accessassociationsourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-accessassociationsourcetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccessAssociationSourceType();

    /**
     * The ARN of the domain name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-domainnamearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-domainnamearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainNameArn();

    /**
     * The collection of tags.
     * <p>
     * Each tag element is associated with a given resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainnameaccessassociation.html#cfn-apigateway-domainnameaccessassociation-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainNameAccessAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainNameAccessAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainNameAccessAssociationProps> {
        java.lang.String accessAssociationSource;
        java.lang.String accessAssociationSourceType;
        java.lang.String domainNameArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDomainNameAccessAssociationProps#getAccessAssociationSource}
         * @param accessAssociationSource The identifier of the domain name access association source. This parameter is required.
         *                                For a <code>VPCE</code> , the value is the VPC endpoint ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessAssociationSource(java.lang.String accessAssociationSource) {
            this.accessAssociationSource = accessAssociationSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameAccessAssociationProps#getAccessAssociationSourceType}
         * @param accessAssociationSourceType The type of the domain name access association source. This parameter is required.
         *                                    Only <code>VPCE</code> is currently supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessAssociationSourceType(java.lang.String accessAssociationSourceType) {
            this.accessAssociationSourceType = accessAssociationSourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameAccessAssociationProps#getDomainNameArn}
         * @param domainNameArn The ARN of the domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainNameArn(java.lang.String domainNameArn) {
            this.domainNameArn = domainNameArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainNameAccessAssociationProps#getTags}
         * @param tags The collection of tags.
         *             Each tag element is associated with a given resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainNameAccessAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainNameAccessAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainNameAccessAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainNameAccessAssociationProps {
        private final java.lang.String accessAssociationSource;
        private final java.lang.String accessAssociationSourceType;
        private final java.lang.String domainNameArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessAssociationSource = software.amazon.jsii.Kernel.get(this, "accessAssociationSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessAssociationSourceType = software.amazon.jsii.Kernel.get(this, "accessAssociationSourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainNameArn = software.amazon.jsii.Kernel.get(this, "domainNameArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessAssociationSource = java.util.Objects.requireNonNull(builder.accessAssociationSource, "accessAssociationSource is required");
            this.accessAssociationSourceType = java.util.Objects.requireNonNull(builder.accessAssociationSourceType, "accessAssociationSourceType is required");
            this.domainNameArn = java.util.Objects.requireNonNull(builder.domainNameArn, "domainNameArn is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAccessAssociationSource() {
            return this.accessAssociationSource;
        }

        @Override
        public final java.lang.String getAccessAssociationSourceType() {
            return this.accessAssociationSourceType;
        }

        @Override
        public final java.lang.String getDomainNameArn() {
            return this.domainNameArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessAssociationSource", om.valueToTree(this.getAccessAssociationSource()));
            data.set("accessAssociationSourceType", om.valueToTree(this.getAccessAssociationSourceType()));
            data.set("domainNameArn", om.valueToTree(this.getDomainNameArn()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnDomainNameAccessAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainNameAccessAssociationProps.Jsii$Proxy that = (CfnDomainNameAccessAssociationProps.Jsii$Proxy) o;

            if (!accessAssociationSource.equals(that.accessAssociationSource)) return false;
            if (!accessAssociationSourceType.equals(that.accessAssociationSourceType)) return false;
            if (!domainNameArn.equals(that.domainNameArn)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessAssociationSource.hashCode();
            result = 31 * result + (this.accessAssociationSourceType.hashCode());
            result = 31 * result + (this.domainNameArn.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
