package software.amazon.awscdk.services.apigatewayv2;

/**
 * Supported HTTP methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketAwsIntegration;
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role apiRole;
 * Table table;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("$connect", WebSocketRouteOptions.builder()
 *         .integration(WebSocketAwsIntegration.Builder.create("DynamodbPutItem")
 *                 .integrationUri(String.format("arn:aws:apigateway:%s:dynamodb:action/PutItem", this.region))
 *                 .integrationMethod(HttpMethod.POST)
 *                 .credentialsRole(apiRole)
 *                 .requestTemplates(Map.of(
 *                         "application/json", JSON.stringify(Map.of(
 *                                 "TableName", table.getTableName(),
 *                                 "Item", Map.of(
 *                                         "id", Map.of(
 *                                                 "S", "$context.requestId"))))))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:08.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpMethod")
public enum HttpMethod {
    /**
     * HTTP ANY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ANY,
    /**
     * HTTP DELETE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * HTTP GET.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * HTTP HEAD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
    /**
     * HTTP OPTIONS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONS,
    /**
     * HTTP PATCH.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
    /**
     * HTTP POST.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * HTTP PUT.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
}
