package software.amazon.awscdk.services.apigatewayv2;

/**
 * Reference to an WebSocket authorizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * WebSocketAuthorizerAttributes webSocketAuthorizerAttributes = WebSocketAuthorizerAttributes.builder()
 *         .authorizerId("authorizerId")
 *         .authorizerType("authorizerType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:08.298Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketAuthorizerAttributes")
@software.amazon.jsii.Jsii.Proxy(WebSocketAuthorizerAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketAuthorizerAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * Id of the Authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerId();

    /**
     * Type of authorizer.
     * <p>
     * Possible values are:
     * <p>
     * <ul>
     * <li>CUSTOM - Lambda Authorizer</li>
     * <li>NONE - No Authorization</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerType();

    /**
     * @return a {@link Builder} of {@link WebSocketAuthorizerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketAuthorizerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketAuthorizerAttributes> {
        java.lang.String authorizerId;
        java.lang.String authorizerType;

        /**
         * Sets the value of {@link WebSocketAuthorizerAttributes#getAuthorizerId}
         * @param authorizerId Id of the Authorizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerId(java.lang.String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketAuthorizerAttributes#getAuthorizerType}
         * @param authorizerType Type of authorizer. This parameter is required.
         *                       Possible values are:
         *                       <p>
         *                       <ul>
         *                       <li>CUSTOM - Lambda Authorizer</li>
         *                       <li>NONE - No Authorization</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerType(java.lang.String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketAuthorizerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketAuthorizerAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketAuthorizerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketAuthorizerAttributes {
        private final java.lang.String authorizerId;
        private final java.lang.String authorizerType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizerId = software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerType = software.amazon.jsii.Kernel.get(this, "authorizerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizerId = java.util.Objects.requireNonNull(builder.authorizerId, "authorizerId is required");
            this.authorizerType = java.util.Objects.requireNonNull(builder.authorizerType, "authorizerType is required");
        }

        @Override
        public final java.lang.String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final java.lang.String getAuthorizerType() {
            return this.authorizerType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizerId", om.valueToTree(this.getAuthorizerId()));
            data.set("authorizerType", om.valueToTree(this.getAuthorizerType()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketAuthorizerAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketAuthorizerAttributes.Jsii$Proxy that = (WebSocketAuthorizerAttributes.Jsii$Proxy) o;

            if (!authorizerId.equals(that.authorizerId)) return false;
            return this.authorizerType.equals(that.authorizerType);
        }

        @Override
        public final int hashCode() {
            int result = this.authorizerId.hashCode();
            result = 31 * result + (this.authorizerType.hashCode());
            return result;
        }
    }
}
