package software.amazon.awscdk.services.appconfig;

/**
 * The deletion protection check options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * Alarm alarm;
 * CompositeAlarm compositeAlarm;
 * Bucket bucket;
 * // Environment deletion protection check
 * // Environment deletion protection check
 * Environment.Builder.create(this, "MyEnvironment")
 *         .application(application)
 *         .deletionProtectionCheck(DeletionProtectionCheck.APPLY)
 *         .build();
 * // configuration profile with deletion protection check
 * // configuration profile with deletion protection check
 * HostedConfiguration.Builder.create(this, "MyHostedConfigFromFile")
 *         .application(application)
 *         .content(ConfigurationContent.fromFile("config.json"))
 *         .deletionProtectionCheck(DeletionProtectionCheck.BYPASS)
 *         .build();
 * SourcedConfiguration.Builder.create(this, "MySourcedConfiguration")
 *         .application(application)
 *         .location(ConfigurationSource.fromBucket(bucket, "path/to/file.json"))
 *         .deletionProtectionCheck(DeletionProtectionCheck.ACCOUNT_DEFAULT)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:08.411Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.DeletionProtectionCheck")
public enum DeletionProtectionCheck {
    /**
     * The default setting, which uses account-level deletion protection.
     * <p>
     * To configure account-level deletion protection, use the UpdateAccountSettings API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACCOUNT_DEFAULT,
    /**
     * Instructs the deletion protection check to run, even if deletion protection is disabled at the account level.
     * <p>
     * APPLY also forces the deletion protection check to run against resources created in the past hour,
     * which are normally excluded from deletion protection checks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPLY,
    /**
     * Instructs AWS AppConfig to bypass the deletion protection check and delete an environment or a configuration profile even if deletion protection would have otherwise prevented it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BYPASS,
}
