package software.amazon.awscdk.services.appconfig;

/**
 * An AWS AppConfig deployment strategy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DeploymentStrategy.Builder.create(this, "MyDeploymentStrategy")
 *         .rolloutStrategy(RolloutStrategy.linear(RolloutStrategyProps.builder()
 *                 .growthFactor(20)
 *                 .deploymentDuration(Duration.minutes(30))
 *                 .finalBakeTime(Duration.minutes(30))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html">https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-creating-deployment-strategy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:08.411Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.DeploymentStrategy")
public class DeploymentStrategy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appconfig.IDeploymentStrategy {

    protected DeploymentStrategy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DeploymentStrategy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appconfig.DeploymentStrategy.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DeploymentStrategy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.DeploymentStrategyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a deployment strategy into the CDK using its Amazon Resource Name (ARN).
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the deployment strategy construct. This parameter is required.
     * @param deploymentStrategyArn The Amazon Resource Name (ARN) of the deployment strategy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IDeploymentStrategy fromDeploymentStrategyArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String deploymentStrategyArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.DeploymentStrategy.class, "fromDeploymentStrategyArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IDeploymentStrategy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(deploymentStrategyArn, "deploymentStrategyArn is required") });
    }

    /**
     * Imports a deployment strategy into the CDK using its ID.
     * <p>
     * @param scope The parent construct. This parameter is required.
     * @param id The name of the deployment strategy construct. This parameter is required.
     * @param deploymentStrategyId The ID of the deployment strategy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IDeploymentStrategy fromDeploymentStrategyId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.DeploymentStrategyId deploymentStrategyId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.DeploymentStrategy.class, "fromDeploymentStrategyId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IDeploymentStrategy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(deploymentStrategyId, "deploymentStrategyId is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The Amazon Resource Name (ARN) of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentStrategyArn() {
        return software.amazon.jsii.Kernel.get(this, "deploymentStrategyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentStrategyId() {
        return software.amazon.jsii.Kernel.get(this, "deploymentStrategyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The deployment duration in minutes of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDeploymentDurationInMinutes() {
        return software.amazon.jsii.Kernel.get(this, "deploymentDurationInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The description of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The final bake time in minutes of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getFinalBakeTimeInMinutes() {
        return software.amazon.jsii.Kernel.get(this, "finalBakeTimeInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The growth factor of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getGrowthFactor() {
        return software.amazon.jsii.Kernel.get(this, "growthFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The growth type of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.GrowthType getGrowthType() {
        return software.amazon.jsii.Kernel.get(this, "growthType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.GrowthType.class));
    }

    /**
     * The name of the deployment strategy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appconfig.DeploymentStrategy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appconfig.DeploymentStrategy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appconfig.DeploymentStrategyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appconfig.DeploymentStrategyProps.Builder();
        }

        /**
         * The rollout strategy for the deployment strategy.
         * <p>
         * You can use predefined deployment
         * strategies, such as RolloutStrategy.ALL_AT_ONCE, RolloutStrategy.LINEAR_50_PERCENT_EVERY_30_SECONDS,
         * or RolloutStrategy.CANARY_10_PERCENT_20_MINUTES.
         * <p>
         * @return {@code this}
         * @param rolloutStrategy The rollout strategy for the deployment strategy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rolloutStrategy(final software.amazon.awscdk.services.appconfig.RolloutStrategy rolloutStrategy) {
            this.props.rolloutStrategy(rolloutStrategy);
            return this;
        }

        /**
         * A name for the deployment strategy.
         * <p>
         * Default: - A name is generated.
         * <p>
         * @return {@code this}
         * @param deploymentStrategyName A name for the deployment strategy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStrategyName(final java.lang.String deploymentStrategyName) {
            this.props.deploymentStrategyName(deploymentStrategyName);
            return this;
        }

        /**
         * A description of the deployment strategy.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the deployment strategy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appconfig.DeploymentStrategy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appconfig.DeploymentStrategy build() {
            return new software.amazon.awscdk.services.appconfig.DeploymentStrategy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
