package software.amazon.awscdk.services.appmesh;

/**
 * The set of properties used when creating a Mesh.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stack infraStack;
 * Stack appStack;
 * Mesh mesh = Mesh.Builder.create(infraStack, "AppMesh")
 *         .meshName("myAwsMesh")
 *         .egressFilter(MeshFilterType.ALLOW_ALL)
 *         .build();
 * // the VirtualRouter will belong to 'appStack',
 * // even though the Mesh belongs to 'infraStack'
 * VirtualRouter router = VirtualRouter.Builder.create(appStack, "router")
 *         .mesh(mesh) // notice that mesh is a required property when creating a router with the 'new' statement
 *         .listeners(List.of(VirtualRouterListener.http(8081)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:08.864Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.MeshProps")
@software.amazon.jsii.Jsii.Proxy(MeshProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MeshProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Egress filter to be applied to the Mesh.
     * <p>
     * Default: DROP_ALL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.MeshFilterType getEgressFilter() {
        return null;
    }

    /**
     * The name of the Mesh being defined.
     * <p>
     * Default: - A name is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMeshName() {
        return null;
    }

    /**
     * Defines how upstream clients will discover VirtualNodes in the Mesh.
     * <p>
     * Default: - No Service Discovery
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.MeshServiceDiscovery getServiceDiscovery() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MeshProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MeshProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MeshProps> {
        software.amazon.awscdk.services.appmesh.MeshFilterType egressFilter;
        java.lang.String meshName;
        software.amazon.awscdk.services.appmesh.MeshServiceDiscovery serviceDiscovery;

        /**
         * Sets the value of {@link MeshProps#getEgressFilter}
         * @param egressFilter Egress filter to be applied to the Mesh.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressFilter(software.amazon.awscdk.services.appmesh.MeshFilterType egressFilter) {
            this.egressFilter = egressFilter;
            return this;
        }

        /**
         * Sets the value of {@link MeshProps#getMeshName}
         * @param meshName The name of the Mesh being defined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(java.lang.String meshName) {
            this.meshName = meshName;
            return this;
        }

        /**
         * Sets the value of {@link MeshProps#getServiceDiscovery}
         * @param serviceDiscovery Defines how upstream clients will discover VirtualNodes in the Mesh.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceDiscovery(software.amazon.awscdk.services.appmesh.MeshServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MeshProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MeshProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MeshProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MeshProps {
        private final software.amazon.awscdk.services.appmesh.MeshFilterType egressFilter;
        private final java.lang.String meshName;
        private final software.amazon.awscdk.services.appmesh.MeshServiceDiscovery serviceDiscovery;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.egressFilter = software.amazon.jsii.Kernel.get(this, "egressFilter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MeshFilterType.class));
            this.meshName = software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceDiscovery = software.amazon.jsii.Kernel.get(this, "serviceDiscovery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MeshServiceDiscovery.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.egressFilter = builder.egressFilter;
            this.meshName = builder.meshName;
            this.serviceDiscovery = builder.serviceDiscovery;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.MeshFilterType getEgressFilter() {
            return this.egressFilter;
        }

        @Override
        public final java.lang.String getMeshName() {
            return this.meshName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.MeshServiceDiscovery getServiceDiscovery() {
            return this.serviceDiscovery;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEgressFilter() != null) {
                data.set("egressFilter", om.valueToTree(this.getEgressFilter()));
            }
            if (this.getMeshName() != null) {
                data.set("meshName", om.valueToTree(this.getMeshName()));
            }
            if (this.getServiceDiscovery() != null) {
                data.set("serviceDiscovery", om.valueToTree(this.getServiceDiscovery()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.MeshProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MeshProps.Jsii$Proxy that = (MeshProps.Jsii$Proxy) o;

            if (this.egressFilter != null ? !this.egressFilter.equals(that.egressFilter) : that.egressFilter != null) return false;
            if (this.meshName != null ? !this.meshName.equals(that.meshName) : that.meshName != null) return false;
            return this.serviceDiscovery != null ? this.serviceDiscovery.equals(that.serviceDiscovery) : that.serviceDiscovery == null;
        }

        @Override
        public final int hashCode() {
            int result = this.egressFilter != null ? this.egressFilter.hashCode() : 0;
            result = 31 * result + (this.meshName != null ? this.meshName.hashCode() : 0);
            result = 31 * result + (this.serviceDiscovery != null ? this.serviceDiscovery.hashCode() : 0);
            return result;
        }
    }
}
