package software.amazon.awscdk.services.appsync;

/**
 * The authorization config in case the HTTP endpoint requires authorization.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * AppSyncAwsIamConfig appSyncAwsIamConfig = AppSyncAwsIamConfig.builder()
 *         .signingRegion("signingRegion")
 *         .signingServiceName("signingServiceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:09.002Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncAwsIamConfig")
@software.amazon.jsii.Jsii.Proxy(AppSyncAwsIamConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppSyncAwsIamConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The signing region for AWS IAM authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningRegion();

    /**
     * The signing service name for AWS IAM authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningServiceName();

    /**
     * @return a {@link Builder} of {@link AppSyncAwsIamConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppSyncAwsIamConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppSyncAwsIamConfig> {
        java.lang.String signingRegion;
        java.lang.String signingServiceName;

        /**
         * Sets the value of {@link AppSyncAwsIamConfig#getSigningRegion}
         * @param signingRegion The signing region for AWS IAM authorization. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingRegion(java.lang.String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncAwsIamConfig#getSigningServiceName}
         * @param signingServiceName The signing service name for AWS IAM authorization. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingServiceName(java.lang.String signingServiceName) {
            this.signingServiceName = signingServiceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppSyncAwsIamConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppSyncAwsIamConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppSyncAwsIamConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppSyncAwsIamConfig {
        private final java.lang.String signingRegion;
        private final java.lang.String signingServiceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.signingRegion = software.amazon.jsii.Kernel.get(this, "signingRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signingServiceName = software.amazon.jsii.Kernel.get(this, "signingServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.signingRegion = java.util.Objects.requireNonNull(builder.signingRegion, "signingRegion is required");
            this.signingServiceName = java.util.Objects.requireNonNull(builder.signingServiceName, "signingServiceName is required");
        }

        @Override
        public final java.lang.String getSigningRegion() {
            return this.signingRegion;
        }

        @Override
        public final java.lang.String getSigningServiceName() {
            return this.signingServiceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("signingRegion", om.valueToTree(this.getSigningRegion()));
            data.set("signingServiceName", om.valueToTree(this.getSigningServiceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AppSyncAwsIamConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppSyncAwsIamConfig.Jsii$Proxy that = (AppSyncAwsIamConfig.Jsii$Proxy) o;

            if (!signingRegion.equals(that.signingRegion)) return false;
            return this.signingServiceName.equals(that.signingServiceName);
        }

        @Override
        public final int hashCode() {
            int result = this.signingRegion.hashCode();
            result = 31 * result + (this.signingServiceName.hashCode());
            return result;
        }
    }
}
