package software.amazon.awscdk.services.appsync;

/**
 * Properties for the OpenSearch Data Source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.opensearchservice.*;
 * IApi api;
 * Domain domain;
 * Role role;
 * AppSyncOpenSearchDataSourceProps appSyncOpenSearchDataSourceProps = AppSyncOpenSearchDataSourceProps.builder()
 *         .api(api)
 *         .domain(domain)
 *         // the properties below are optional
 *         .description("description")
 *         .name("name")
 *         .serviceRole(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:09.015Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncOpenSearchDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(AppSyncOpenSearchDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppSyncOpenSearchDataSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.AppSyncBackedDataSourceProps {

    /**
     * The OpenSearch domain containing the endpoint for the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opensearchservice.IDomain getDomain();

    /**
     * @return a {@link Builder} of {@link AppSyncOpenSearchDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppSyncOpenSearchDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppSyncOpenSearchDataSourceProps> {
        software.amazon.awscdk.services.opensearchservice.IDomain domain;
        software.amazon.awscdk.services.iam.IRole serviceRole;
        software.amazon.awscdk.services.appsync.IApi api;
        java.lang.String description;
        java.lang.String name;

        /**
         * Sets the value of {@link AppSyncOpenSearchDataSourceProps#getDomain}
         * @param domain The OpenSearch domain containing the endpoint for the data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(software.amazon.awscdk.services.opensearchservice.IDomain domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncOpenSearchDataSourceProps#getServiceRole}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncOpenSearchDataSourceProps#getApi}
         * @param api The API to attach this data source to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.appsync.IApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncOpenSearchDataSourceProps#getDescription}
         * @param description The description of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncOpenSearchDataSourceProps#getName}
         * @param name The name of the data source.
         *             The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}.
         *             Any invalid characters will be automatically removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppSyncOpenSearchDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppSyncOpenSearchDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppSyncOpenSearchDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppSyncOpenSearchDataSourceProps {
        private final software.amazon.awscdk.services.opensearchservice.IDomain domain;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;
        private final software.amazon.awscdk.services.appsync.IApi api;
        private final java.lang.String description;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.opensearchservice.IDomain.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IApi.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domain = java.util.Objects.requireNonNull(builder.domain, "domain is required");
            this.serviceRole = builder.serviceRole;
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.description = builder.description;
            this.name = builder.name;
        }

        @Override
        public final software.amazon.awscdk.services.opensearchservice.IDomain getDomain() {
            return this.domain;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IApi getApi() {
            return this.api;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domain", om.valueToTree(this.getDomain()));
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }
            data.set("api", om.valueToTree(this.getApi()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AppSyncOpenSearchDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppSyncOpenSearchDataSourceProps.Jsii$Proxy that = (AppSyncOpenSearchDataSourceProps.Jsii$Proxy) o;

            if (!domain.equals(that.domain)) return false;
            if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
            if (!api.equals(that.api)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            result = 31 * result + (this.api.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
