package software.amazon.awscdk.services.batch;

/**
 * Maps the image to instance types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * ManagedEc2EcsComputeEnvironment.Builder.create(this, "myEc2ComputeEnv")
 *         .vpc(vpc)
 *         .images(List.of(EcsMachineImage.builder()
 *                 .imageType(EcsMachineImageType.ECS_AL2023)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:09.696Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsMachineImageType")
public enum EcsMachineImageType {
    /**
     * Tells Batch that this machine image runs on non-GPU AL2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS_AL2,
    /**
     * Tells Batch that this machine image runs on non-GPU AL2023 instances.
     * <p>
     * Amazon Linux 2023 does not support A1 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS_AL2023,
    /**
     * Tells Batch that this machine image runs on GPU instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS_AL2_NVIDIA,
}
