package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a <code>CfnResourceVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnResourceVersionProps cfnResourceVersionProps = CfnResourceVersionProps.builder()
 *         .schemaHandlerPackage("schemaHandlerPackage")
 *         .typeName("typeName")
 *         // the properties below are optional
 *         .executionRoleArn("executionRoleArn")
 *         .loggingConfig(LoggingConfigProperty.builder()
 *                 .logGroupName("logGroupName")
 *                 .logRoleArn("logRoleArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:10.303Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnResourceVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A URL to the S3 bucket for the resource project package that contains the necessary files for the resource you want to register.
     * <p>
     * For information on generating a schema handler package, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html">Modeling resource types to use with AWS CloudFormation</a> in the <em>AWS CloudFormation Command Line Interface (CLI) User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * To register the resource version, you must have <code>s3:GetObject</code> permissions to access the S3 objects.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-schemahandlerpackage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-schemahandlerpackage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaHandlerPackage();

    /**
     * The name of the resource being registered.
     * <p>
     * We recommend that resource names adhere to the following pattern: <em>company_or_organization</em> :: <em>service</em> :: <em>type</em> .
     * <p>
     * <blockquote>
     * <p>
     * The following organization namespaces are reserved and can't be used in your resource names:
     * <p>
     * <ul>
     * <li><code>Alexa</code></li>
     * <li><code>AMZN</code></li>
     * <li><code>Amazon</code></li>
     * <li><code>AWS</code></li>
     * <li><code>Custom</code></li>
     * <li><code>Dev</code></li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-typename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTypeName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the resource.
     * <p>
     * If your resource calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the resource type handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the resource type handler, thereby supplying your resource type with the appropriate credentials.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-executionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * Logging configuration information for a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-loggingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-resourceversion.html#cfn-cloudformation-resourceversion-loggingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceVersionProps> {
        java.lang.String schemaHandlerPackage;
        java.lang.String typeName;
        java.lang.String executionRoleArn;
        java.lang.Object loggingConfig;

        /**
         * Sets the value of {@link CfnResourceVersionProps#getSchemaHandlerPackage}
         * @param schemaHandlerPackage A URL to the S3 bucket for the resource project package that contains the necessary files for the resource you want to register. This parameter is required.
         *                             For information on generating a schema handler package, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html">Modeling resource types to use with AWS CloudFormation</a> in the <em>AWS CloudFormation Command Line Interface (CLI) User Guide</em> .
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             To register the resource version, you must have <code>s3:GetObject</code> permissions to access the S3 objects.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaHandlerPackage(java.lang.String schemaHandlerPackage) {
            this.schemaHandlerPackage = schemaHandlerPackage;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceVersionProps#getTypeName}
         * @param typeName The name of the resource being registered. This parameter is required.
         *                 We recommend that resource names adhere to the following pattern: <em>company_or_organization</em> :: <em>service</em> :: <em>type</em> .
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 The following organization namespaces are reserved and can't be used in your resource names:
         *                 <p>
         *                 <ul>
         *                 <li><code>Alexa</code></li>
         *                 <li><code>AMZN</code></li>
         *                 <li><code>Amazon</code></li>
         *                 <li><code>AWS</code></li>
         *                 <li><code>Custom</code></li>
         *                 <li><code>Dev</code></li>
         *                 </ul>
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceVersionProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the resource.
         *                         If your resource calls AWS APIs in any of its handlers, you must create an IAM execution role that includes the necessary permissions to call those AWS APIs, and provision that execution role in your account. When CloudFormation needs to invoke the resource type handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the resource type handler, thereby supplying your resource type with the appropriate credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceVersionProps#getLoggingConfig}
         * @param loggingConfig Logging configuration information for a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(software.amazon.awscdk.IResolvable loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceVersionProps#getLoggingConfig}
         * @param loggingConfig Logging configuration information for a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(software.amazon.awscdk.services.cloudformation.CfnResourceVersion.LoggingConfigProperty loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceVersionProps {
        private final java.lang.String schemaHandlerPackage;
        private final java.lang.String typeName;
        private final java.lang.String executionRoleArn;
        private final java.lang.Object loggingConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schemaHandlerPackage = software.amazon.jsii.Kernel.get(this, "schemaHandlerPackage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingConfig = software.amazon.jsii.Kernel.get(this, "loggingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schemaHandlerPackage = java.util.Objects.requireNonNull(builder.schemaHandlerPackage, "schemaHandlerPackage is required");
            this.typeName = java.util.Objects.requireNonNull(builder.typeName, "typeName is required");
            this.executionRoleArn = builder.executionRoleArn;
            this.loggingConfig = builder.loggingConfig;
        }

        @Override
        public final java.lang.String getSchemaHandlerPackage() {
            return this.schemaHandlerPackage;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.Object getLoggingConfig() {
            return this.loggingConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schemaHandlerPackage", om.valueToTree(this.getSchemaHandlerPackage()));
            data.set("typeName", om.valueToTree(this.getTypeName()));
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getLoggingConfig() != null) {
                data.set("loggingConfig", om.valueToTree(this.getLoggingConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnResourceVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceVersionProps.Jsii$Proxy that = (CfnResourceVersionProps.Jsii$Proxy) o;

            if (!schemaHandlerPackage.equals(that.schemaHandlerPackage)) return false;
            if (!typeName.equals(that.typeName)) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            return this.loggingConfig != null ? this.loggingConfig.equals(that.loggingConfig) : that.loggingConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schemaHandlerPackage.hashCode();
            result = 31 * result + (this.typeName.hashCode());
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.loggingConfig != null ? this.loggingConfig.hashCode() : 0);
            return result;
        }
    }
}
