package software.amazon.awscdk.services.cloudfront;

/**
 * The type of events that a CloudFront function can be invoked in response to.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket s3Bucket;
 * // Add a cloudfront Function to a Distribution
 * Function cfFunction = Function.Builder.create(this, "Function")
 *         .code(FunctionCode.fromInline("function handler(event) { return event.request }"))
 *         .runtime(FunctionRuntime.JS_2_0)
 *         .build();
 * Distribution.Builder.create(this, "distro")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(s3Bucket))
 *                 .functionAssociations(List.of(FunctionAssociation.builder()
 *                         .function(cfFunction)
 *                         .eventType(FunctionEventType.VIEWER_REQUEST)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:10.523Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FunctionEventType")
public enum FunctionEventType {
    /**
     * The viewer-request specifies the incoming request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIEWER_REQUEST,
    /**
     * The viewer-response specifies the outgoing response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIEWER_RESPONSE,
}
