package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for creating a Public Key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Validating signed URLs or signed cookies with Trusted Key Groups
 * // public key in PEM format
 * String publicKey;
 * PublicKey pubKey = PublicKey.Builder.create(this, "MyPubKey")
 *         .encodedKey(publicKey)
 *         .build();
 * KeyGroup keyGroup = KeyGroup.Builder.create(this, "MyKeyGroup")
 *         .items(List.of(pubKey))
 *         .build();
 * Distribution.Builder.create(this, "Dist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("www.example.com"))
 *                 .trustedKeyGroups(List.of(keyGroup))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:10.535Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.KeyGroupProps")
@software.amazon.jsii.Jsii.Proxy(KeyGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeyGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of public keys to add to the key group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudfront.IPublicKey> getItems();

    /**
     * A comment to describe the key group.
     * <p>
     * Default: - no comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * A name to identify the key group.
     * <p>
     * Default: - generated from the `id`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyGroupName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KeyGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeyGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeyGroupProps> {
        java.util.List<software.amazon.awscdk.services.cloudfront.IPublicKey> items;
        java.lang.String comment;
        java.lang.String keyGroupName;

        /**
         * Sets the value of {@link KeyGroupProps#getItems}
         * @param items A list of public keys to add to the key group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder items(java.util.List<? extends software.amazon.awscdk.services.cloudfront.IPublicKey> items) {
            this.items = (java.util.List<software.amazon.awscdk.services.cloudfront.IPublicKey>)items;
            return this;
        }

        /**
         * Sets the value of {@link KeyGroupProps#getComment}
         * @param comment A comment to describe the key group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link KeyGroupProps#getKeyGroupName}
         * @param keyGroupName A name to identify the key group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyGroupName(java.lang.String keyGroupName) {
            this.keyGroupName = keyGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeyGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeyGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeyGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyGroupProps {
        private final java.util.List<software.amazon.awscdk.services.cloudfront.IPublicKey> items;
        private final java.lang.String comment;
        private final java.lang.String keyGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IPublicKey.class)));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyGroupName = software.amazon.jsii.Kernel.get(this, "keyGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.items = (java.util.List<software.amazon.awscdk.services.cloudfront.IPublicKey>)java.util.Objects.requireNonNull(builder.items, "items is required");
            this.comment = builder.comment;
            this.keyGroupName = builder.keyGroupName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.IPublicKey> getItems() {
            return this.items;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getKeyGroupName() {
            return this.keyGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("items", om.valueToTree(this.getItems()));
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getKeyGroupName() != null) {
                data.set("keyGroupName", om.valueToTree(this.getKeyGroupName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.KeyGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeyGroupProps.Jsii$Proxy that = (KeyGroupProps.Jsii$Proxy) o;

            if (!items.equals(that.items)) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            return this.keyGroupName != null ? this.keyGroupName.equals(that.keyGroupName) : that.keyGroupName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.items.hashCode();
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.keyGroupName != null ? this.keyGroupName.hashCode() : 0);
            return result;
        }
    }
}
