package software.amazon.awscdk.services.cloudwatch;

/**
 * Properties for defining a <code>CfnAlarm</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CfnAlarmProps cfnAlarmProps = CfnAlarmProps.builder()
 *         .comparisonOperator("comparisonOperator")
 *         .evaluationPeriods(123)
 *         // the properties below are optional
 *         .actionsEnabled(false)
 *         .alarmActions(List.of("alarmActions"))
 *         .alarmDescription("alarmDescription")
 *         .alarmName("alarmName")
 *         .datapointsToAlarm(123)
 *         .dimensions(List.of(DimensionProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .evaluateLowSampleCountPercentile("evaluateLowSampleCountPercentile")
 *         .extendedStatistic("extendedStatistic")
 *         .insufficientDataActions(List.of("insufficientDataActions"))
 *         .metricName("metricName")
 *         .metrics(List.of(MetricDataQueryProperty.builder()
 *                 .id("id")
 *                 // the properties below are optional
 *                 .accountId("accountId")
 *                 .expression("expression")
 *                 .label("label")
 *                 .metricStat(MetricStatProperty.builder()
 *                         .metric(MetricProperty.builder()
 *                                 .dimensions(List.of(DimensionProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .metricName("metricName")
 *                                 .namespace("namespace")
 *                                 .build())
 *                         .period(123)
 *                         .stat("stat")
 *                         // the properties below are optional
 *                         .unit("unit")
 *                         .build())
 *                 .period(123)
 *                 .returnData(false)
 *                 .build()))
 *         .namespace("namespace")
 *         .okActions(List.of("okActions"))
 *         .period(123)
 *         .statistic("statistic")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .threshold(123)
 *         .thresholdMetricId("thresholdMetricId")
 *         .treatMissingData("treatMissingData")
 *         .unit("unit")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:10.723Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnAlarmProps")
@software.amazon.jsii.Jsii.Proxy(CfnAlarmProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAlarmProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The arithmetic operation to use when comparing the specified statistic and threshold.
     * <p>
     * The specified statistic value is used as the first operand.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-comparisonoperator</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

    /**
     * The number of periods over which data is compared to the specified threshold.
     * <p>
     * If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies that number. If you are setting an "M out of N" alarm, this value is the N, and <code>DatapointsToAlarm</code> is the M.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">Evaluating an Alarm</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-evaluationperiods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-evaluationperiods</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getEvaluationPeriods();

    /**
     * Indicates whether actions should be executed during any changes to the alarm state.
     * <p>
     * The default is TRUE.
     * <p>
     * Default: - true
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-actionsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-actionsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActionsEnabled() {
        return null;
    }

    /**
     * The list of actions to execute when this alarm transitions into an ALARM state from any other state.
     * <p>
     * Specify each action as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html">PutMetricAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-alarmactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-alarmactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlarmActions() {
        return null;
    }

    /**
     * The description of the alarm.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-alarmdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-alarmdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return null;
    }

    /**
     * The name of the alarm.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the alarm name.
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-alarmname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlarmName() {
        return null;
    }

    /**
     * The number of datapoints that must be breaching to trigger the alarm.
     * <p>
     * This is used only if you are setting an "M out of N" alarm. In that case, this value is the M, and the value that you set for <code>EvaluationPeriods</code> is the N value. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">Evaluating an Alarm</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * If you omit this parameter, CloudWatch uses the same value here that you set for <code>EvaluationPeriods</code> , and the alarm goes to alarm state if that many consecutive periods are breaching.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-datapointstoalarm</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDatapointsToAlarm() {
        return null;
    }

    /**
     * The dimensions for the metric associated with the alarm.
     * <p>
     * For an alarm based on a math expression, you can't specify <code>Dimensions</code> . Instead, you use <code>Metrics</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-dimensions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
        return null;
    }

    /**
     * Used only for alarms based on percentiles.
     * <p>
     * If <code>ignore</code> , the alarm state does not change during periods with too few data points to be statistically significant. If <code>evaluate</code> or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-evaluatelowsamplecountpercentile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-evaluatelowsamplecountpercentile</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEvaluateLowSampleCountPercentile() {
        return null;
    }

    /**
     * The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
     * <p>
     * For an alarm based on a metric, you must specify either <code>Statistic</code> or <code>ExtendedStatistic</code> but not both.
     * <p>
     * For an alarm based on a math expression, you can't specify <code>ExtendedStatistic</code> . Instead, you use <code>Metrics</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-extendedstatistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-extendedstatistic</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExtendedStatistic() {
        return null;
    }

    /**
     * The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state.
     * <p>
     * Each action is specified as an Amazon Resource Name (ARN).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-insufficientdataactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-insufficientdataactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsufficientDataActions() {
        return null;
    }

    /**
     * The name of the metric associated with the alarm.
     * <p>
     * This is required for an alarm based on a metric. For an alarm based on a math expression, you use <code>Metrics</code> instead and you can't specify <code>MetricName</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-metricname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetricName() {
        return null;
    }

    /**
     * An array that enables you to create an alarm based on the result of a metric math expression.
     * <p>
     * Each item in the array either retrieves a metric or performs a math expression.
     * <p>
     * If you specify the <code>Metrics</code> parameter, you cannot specify <code>MetricName</code> , <code>Dimensions</code> , <code>Period</code> , <code>Namespace</code> , <code>Statistic</code> , <code>ExtendedStatistic</code> , or <code>Unit</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-metrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-metrics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetrics() {
        return null;
    }

    /**
     * The namespace of the metric associated with the alarm.
     * <p>
     * This is required for an alarm based on a metric. For an alarm based on a math expression, you can't specify <code>Namespace</code> and you use <code>Metrics</code> instead.
     * <p>
     * For a list of namespaces for metrics from AWS services, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS Services That Publish CloudWatch Metrics.</a>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-namespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return null;
    }

    /**
     * The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
     * <p>
     * Each action is specified as an Amazon Resource Name (ARN).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-okactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-okactions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOkActions() {
        return null;
    }

    /**
     * The period, in seconds, over which the statistic is applied.
     * <p>
     * This is required for an alarm based on a metric. Valid values are 10, 20, 30, 60, and any multiple of 60.
     * <p>
     * For an alarm based on a math expression, you can't specify <code>Period</code> , and instead you use the <code>Metrics</code> parameter.
     * <p>
     * <em>Minimum:</em> 10
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-period">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-period</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPeriod() {
        return null;
    }

    /**
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code> .
     * <p>
     * For an alarm based on a metric, you must specify either <code>Statistic</code> or <code>ExtendedStatistic</code> but not both.
     * <p>
     * For an alarm based on a math expression, you can't specify <code>Statistic</code> . Instead, you use <code>Metrics</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-statistic</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
        return null;
    }

    /**
     * A list of key-value pairs to associate with the alarm.
     * <p>
     * You can associate as many as 50 tags with an alarm. To be able to associate tags with the alarm when you create the alarm, you must have the <code>cloudwatch:TagResource</code> permission.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The value to compare with the specified statistic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-threshold</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getThreshold() {
        return null;
    }

    /**
     * In an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code> function used as the threshold for the alarm.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-thresholdmetricid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-thresholdmetricid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThresholdMetricId() {
        return null;
    }

    /**
     * Sets how this alarm is to handle missing data points.
     * <p>
     * Valid values are <code>breaching</code> , <code>notBreaching</code> , <code>ignore</code> , and <code>missing</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data">Configuring How CloudWatch Alarms Treat Missing Data</a> in the <em>Amazon CloudWatch User Guide</em> .
     * <p>
     * If you omit this parameter, the default behavior of <code>missing</code> is used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-treatmissingdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-treatmissingdata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTreatMissingData() {
        return null;
    }

    /**
     * The unit of the metric associated with the alarm.
     * <p>
     * Specify this only if you are creating an alarm based on a single metric. Do not specify this if you are specifying a <code>Metrics</code> array.
     * <p>
     * You can specify the following values: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-alarm.html#cfn-cloudwatch-alarm-unit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAlarmProps> {
        java.lang.String comparisonOperator;
        java.lang.Number evaluationPeriods;
        java.lang.Object actionsEnabled;
        java.util.List<java.lang.String> alarmActions;
        java.lang.String alarmDescription;
        java.lang.String alarmName;
        java.lang.Number datapointsToAlarm;
        java.lang.Object dimensions;
        java.lang.String evaluateLowSampleCountPercentile;
        java.lang.String extendedStatistic;
        java.util.List<java.lang.String> insufficientDataActions;
        java.lang.String metricName;
        java.lang.Object metrics;
        java.lang.String namespace;
        java.util.List<java.lang.String> okActions;
        java.lang.Number period;
        java.lang.String statistic;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number threshold;
        java.lang.String thresholdMetricId;
        java.lang.String treatMissingData;
        java.lang.String unit;

        /**
         * Sets the value of {@link CfnAlarmProps#getComparisonOperator}
         * @param comparisonOperator The arithmetic operation to use when comparing the specified statistic and threshold. This parameter is required.
         *                           The specified statistic value is used as the first operand.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparisonOperator(java.lang.String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getEvaluationPeriods}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         *                          If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies that number. If you are setting an "M out of N" alarm, this value is the N, and <code>DatapointsToAlarm</code> is the M.
         *                          <p>
         *                          For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">Evaluating an Alarm</a> in the <em>Amazon CloudWatch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getActionsEnabled}
         * @param actionsEnabled Indicates whether actions should be executed during any changes to the alarm state.
         *                       The default is TRUE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(java.lang.Boolean actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getActionsEnabled}
         * @param actionsEnabled Indicates whether actions should be executed during any changes to the alarm state.
         *                       The default is TRUE.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(software.amazon.awscdk.IResolvable actionsEnabled) {
            this.actionsEnabled = actionsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getAlarmActions}
         * @param alarmActions The list of actions to execute when this alarm transitions into an ALARM state from any other state.
         *                     Specify each action as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutMetricAlarm.html">PutMetricAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmActions(java.util.List<java.lang.String> alarmActions) {
            this.alarmActions = alarmActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getAlarmDescription}
         * @param alarmDescription The description of the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(java.lang.String alarmDescription) {
            this.alarmDescription = alarmDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getAlarmName}
         * @param alarmName The name of the alarm.
         *                  If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the alarm name.
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(java.lang.String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getDatapointsToAlarm}
         * @param datapointsToAlarm The number of datapoints that must be breaching to trigger the alarm.
         *                          This is used only if you are setting an "M out of N" alarm. In that case, this value is the M, and the value that you set for <code>EvaluationPeriods</code> is the N value. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">Evaluating an Alarm</a> in the <em>Amazon CloudWatch User Guide</em> .
         *                          <p>
         *                          If you omit this parameter, CloudWatch uses the same value here that you set for <code>EvaluationPeriods</code> , and the alarm goes to alarm state if that many consecutive periods are breaching.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(java.lang.Number datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getDimensions}
         * @param dimensions The dimensions for the metric associated with the alarm.
         *                   For an alarm based on a math expression, you can't specify <code>Dimensions</code> . Instead, you use <code>Metrics</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getDimensions}
         * @param dimensions The dimensions for the metric associated with the alarm.
         *                   For an alarm based on a math expression, you can't specify <code>Dimensions</code> . Instead, you use <code>Metrics</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getEvaluateLowSampleCountPercentile}
         * @param evaluateLowSampleCountPercentile Used only for alarms based on percentiles.
         *                                         If <code>ignore</code> , the alarm state does not change during periods with too few data points to be statistically significant. If <code>evaluate</code> or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluateLowSampleCountPercentile(java.lang.String evaluateLowSampleCountPercentile) {
            this.evaluateLowSampleCountPercentile = evaluateLowSampleCountPercentile;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getExtendedStatistic}
         * @param extendedStatistic The percentile statistic for the metric associated with the alarm. Specify a value between p0.0 and p100.
         *                          For an alarm based on a metric, you must specify either <code>Statistic</code> or <code>ExtendedStatistic</code> but not both.
         *                          <p>
         *                          For an alarm based on a math expression, you can't specify <code>ExtendedStatistic</code> . Instead, you use <code>Metrics</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedStatistic(java.lang.String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getInsufficientDataActions}
         * @param insufficientDataActions The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state from any other state.
         *                                Each action is specified as an Amazon Resource Name (ARN).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insufficientDataActions(java.util.List<java.lang.String> insufficientDataActions) {
            this.insufficientDataActions = insufficientDataActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getMetricName}
         * @param metricName The name of the metric associated with the alarm.
         *                   This is required for an alarm based on a metric. For an alarm based on a math expression, you use <code>Metrics</code> instead and you can't specify <code>MetricName</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getMetrics}
         * @param metrics An array that enables you to create an alarm based on the result of a metric math expression.
         *                Each item in the array either retrieves a metric or performs a math expression.
         *                <p>
         *                If you specify the <code>Metrics</code> parameter, you cannot specify <code>MetricName</code> , <code>Dimensions</code> , <code>Period</code> , <code>Namespace</code> , <code>Statistic</code> , <code>ExtendedStatistic</code> , or <code>Unit</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(software.amazon.awscdk.IResolvable metrics) {
            this.metrics = metrics;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getMetrics}
         * @param metrics An array that enables you to create an alarm based on the result of a metric math expression.
         *                Each item in the array either retrieves a metric or performs a math expression.
         *                <p>
         *                If you specify the <code>Metrics</code> parameter, you cannot specify <code>MetricName</code> , <code>Dimensions</code> , <code>Period</code> , <code>Namespace</code> , <code>Statistic</code> , <code>ExtendedStatistic</code> , or <code>Unit</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(java.util.List<? extends java.lang.Object> metrics) {
            this.metrics = metrics;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getNamespace}
         * @param namespace The namespace of the metric associated with the alarm.
         *                  This is required for an alarm based on a metric. For an alarm based on a math expression, you can't specify <code>Namespace</code> and you use <code>Metrics</code> instead.
         *                  <p>
         *                  For a list of namespaces for metrics from AWS services, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html">AWS Services That Publish CloudWatch Metrics.</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getOkActions}
         * @param okActions The actions to execute when this alarm transitions to the <code>OK</code> state from any other state.
         *                  Each action is specified as an Amazon Resource Name (ARN).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder okActions(java.util.List<java.lang.String> okActions) {
            this.okActions = okActions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getPeriod}
         * @param period The period, in seconds, over which the statistic is applied.
         *               This is required for an alarm based on a metric. Valid values are 10, 20, 30, 60, and any multiple of 60.
         *               <p>
         *               For an alarm based on a math expression, you can't specify <code>Period</code> , and instead you use the <code>Metrics</code> parameter.
         *               <p>
         *               <em>Minimum:</em> 10
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(java.lang.Number period) {
            this.period = period;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getStatistic}
         * @param statistic The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use <code>ExtendedStatistic</code> .
         *                  For an alarm based on a metric, you must specify either <code>Statistic</code> or <code>ExtendedStatistic</code> but not both.
         *                  <p>
         *                  For an alarm based on a math expression, you can't specify <code>Statistic</code> . Instead, you use <code>Metrics</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(java.lang.String statistic) {
            this.statistic = statistic;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getTags}
         * @param tags A list of key-value pairs to associate with the alarm.
         *             You can associate as many as 50 tags with an alarm. To be able to associate tags with the alarm when you create the alarm, you must have the <code>cloudwatch:TagResource</code> permission.
         *             <p>
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getThreshold}
         * @param threshold The value to compare with the specified statistic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threshold(java.lang.Number threshold) {
            this.threshold = threshold;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getThresholdMetricId}
         * @param thresholdMetricId In an alarm based on an anomaly detection model, this is the ID of the <code>ANOMALY_DETECTION_BAND</code> function used as the threshold for the alarm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thresholdMetricId(java.lang.String thresholdMetricId) {
            this.thresholdMetricId = thresholdMetricId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getTreatMissingData}
         * @param treatMissingData Sets how this alarm is to handle missing data points.
         *                         Valid values are <code>breaching</code> , <code>notBreaching</code> , <code>ignore</code> , and <code>missing</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarms-and-missing-data">Configuring How CloudWatch Alarms Treat Missing Data</a> in the <em>Amazon CloudWatch User Guide</em> .
         *                         <p>
         *                         If you omit this parameter, the default behavior of <code>missing</code> is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatMissingData(java.lang.String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        /**
         * Sets the value of {@link CfnAlarmProps#getUnit}
         * @param unit The unit of the metric associated with the alarm.
         *             Specify this only if you are creating an alarm based on a single metric. Do not specify this if you are specifying a <code>Metrics</code> array.
         *             <p>
         *             You can specify the following values: Seconds, Microseconds, Milliseconds, Bytes, Kilobytes, Megabytes, Gigabytes, Terabytes, Bits, Kilobits, Megabits, Gigabits, Terabits, Percent, Count, Bytes/Second, Kilobytes/Second, Megabytes/Second, Gigabytes/Second, Terabytes/Second, Bits/Second, Kilobits/Second, Megabits/Second, Gigabits/Second, Terabits/Second, Count/Second, or None.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unit(java.lang.String unit) {
            this.unit = unit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAlarmProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAlarmProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAlarmProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAlarmProps {
        private final java.lang.String comparisonOperator;
        private final java.lang.Number evaluationPeriods;
        private final java.lang.Object actionsEnabled;
        private final java.util.List<java.lang.String> alarmActions;
        private final java.lang.String alarmDescription;
        private final java.lang.String alarmName;
        private final java.lang.Number datapointsToAlarm;
        private final java.lang.Object dimensions;
        private final java.lang.String evaluateLowSampleCountPercentile;
        private final java.lang.String extendedStatistic;
        private final java.util.List<java.lang.String> insufficientDataActions;
        private final java.lang.String metricName;
        private final java.lang.Object metrics;
        private final java.lang.String namespace;
        private final java.util.List<java.lang.String> okActions;
        private final java.lang.Number period;
        private final java.lang.String statistic;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number threshold;
        private final java.lang.String thresholdMetricId;
        private final java.lang.String treatMissingData;
        private final java.lang.String unit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.actionsEnabled = software.amazon.jsii.Kernel.get(this, "actionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.alarmActions = software.amazon.jsii.Kernel.get(this, "alarmActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.alarmDescription = software.amazon.jsii.Kernel.get(this, "alarmDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datapointsToAlarm = software.amazon.jsii.Kernel.get(this, "datapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.evaluateLowSampleCountPercentile = software.amazon.jsii.Kernel.get(this, "evaluateLowSampleCountPercentile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extendedStatistic = software.amazon.jsii.Kernel.get(this, "extendedStatistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insufficientDataActions = software.amazon.jsii.Kernel.get(this, "insufficientDataActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metrics = software.amazon.jsii.Kernel.get(this, "metrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.okActions = software.amazon.jsii.Kernel.get(this, "okActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.thresholdMetricId = software.amazon.jsii.Kernel.get(this, "thresholdMetricId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.treatMissingData = software.amazon.jsii.Kernel.get(this, "treatMissingData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
            this.evaluationPeriods = java.util.Objects.requireNonNull(builder.evaluationPeriods, "evaluationPeriods is required");
            this.actionsEnabled = builder.actionsEnabled;
            this.alarmActions = builder.alarmActions;
            this.alarmDescription = builder.alarmDescription;
            this.alarmName = builder.alarmName;
            this.datapointsToAlarm = builder.datapointsToAlarm;
            this.dimensions = builder.dimensions;
            this.evaluateLowSampleCountPercentile = builder.evaluateLowSampleCountPercentile;
            this.extendedStatistic = builder.extendedStatistic;
            this.insufficientDataActions = builder.insufficientDataActions;
            this.metricName = builder.metricName;
            this.metrics = builder.metrics;
            this.namespace = builder.namespace;
            this.okActions = builder.okActions;
            this.period = builder.period;
            this.statistic = builder.statistic;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.threshold = builder.threshold;
            this.thresholdMetricId = builder.thresholdMetricId;
            this.treatMissingData = builder.treatMissingData;
            this.unit = builder.unit;
        }

        @Override
        public final java.lang.String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final java.lang.Number getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final java.lang.Object getActionsEnabled() {
            return this.actionsEnabled;
        }

        @Override
        public final java.util.List<java.lang.String> getAlarmActions() {
            return this.alarmActions;
        }

        @Override
        public final java.lang.String getAlarmDescription() {
            return this.alarmDescription;
        }

        @Override
        public final java.lang.String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final java.lang.Number getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final java.lang.Object getDimensions() {
            return this.dimensions;
        }

        @Override
        public final java.lang.String getEvaluateLowSampleCountPercentile() {
            return this.evaluateLowSampleCountPercentile;
        }

        @Override
        public final java.lang.String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        @Override
        public final java.util.List<java.lang.String> getInsufficientDataActions() {
            return this.insufficientDataActions;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.Object getMetrics() {
            return this.metrics;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.util.List<java.lang.String> getOkActions() {
            return this.okActions;
        }

        @Override
        public final java.lang.Number getPeriod() {
            return this.period;
        }

        @Override
        public final java.lang.String getStatistic() {
            return this.statistic;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getThreshold() {
            return this.threshold;
        }

        @Override
        public final java.lang.String getThresholdMetricId() {
            return this.thresholdMetricId;
        }

        @Override
        public final java.lang.String getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        public final java.lang.String getUnit() {
            return this.unit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
            data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
            if (this.getActionsEnabled() != null) {
                data.set("actionsEnabled", om.valueToTree(this.getActionsEnabled()));
            }
            if (this.getAlarmActions() != null) {
                data.set("alarmActions", om.valueToTree(this.getAlarmActions()));
            }
            if (this.getAlarmDescription() != null) {
                data.set("alarmDescription", om.valueToTree(this.getAlarmDescription()));
            }
            if (this.getAlarmName() != null) {
                data.set("alarmName", om.valueToTree(this.getAlarmName()));
            }
            if (this.getDatapointsToAlarm() != null) {
                data.set("datapointsToAlarm", om.valueToTree(this.getDatapointsToAlarm()));
            }
            if (this.getDimensions() != null) {
                data.set("dimensions", om.valueToTree(this.getDimensions()));
            }
            if (this.getEvaluateLowSampleCountPercentile() != null) {
                data.set("evaluateLowSampleCountPercentile", om.valueToTree(this.getEvaluateLowSampleCountPercentile()));
            }
            if (this.getExtendedStatistic() != null) {
                data.set("extendedStatistic", om.valueToTree(this.getExtendedStatistic()));
            }
            if (this.getInsufficientDataActions() != null) {
                data.set("insufficientDataActions", om.valueToTree(this.getInsufficientDataActions()));
            }
            if (this.getMetricName() != null) {
                data.set("metricName", om.valueToTree(this.getMetricName()));
            }
            if (this.getMetrics() != null) {
                data.set("metrics", om.valueToTree(this.getMetrics()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getOkActions() != null) {
                data.set("okActions", om.valueToTree(this.getOkActions()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }
            if (this.getStatistic() != null) {
                data.set("statistic", om.valueToTree(this.getStatistic()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThreshold() != null) {
                data.set("threshold", om.valueToTree(this.getThreshold()));
            }
            if (this.getThresholdMetricId() != null) {
                data.set("thresholdMetricId", om.valueToTree(this.getThresholdMetricId()));
            }
            if (this.getTreatMissingData() != null) {
                data.set("treatMissingData", om.valueToTree(this.getTreatMissingData()));
            }
            if (this.getUnit() != null) {
                data.set("unit", om.valueToTree(this.getUnit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CfnAlarmProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAlarmProps.Jsii$Proxy that = (CfnAlarmProps.Jsii$Proxy) o;

            if (!comparisonOperator.equals(that.comparisonOperator)) return false;
            if (!evaluationPeriods.equals(that.evaluationPeriods)) return false;
            if (this.actionsEnabled != null ? !this.actionsEnabled.equals(that.actionsEnabled) : that.actionsEnabled != null) return false;
            if (this.alarmActions != null ? !this.alarmActions.equals(that.alarmActions) : that.alarmActions != null) return false;
            if (this.alarmDescription != null ? !this.alarmDescription.equals(that.alarmDescription) : that.alarmDescription != null) return false;
            if (this.alarmName != null ? !this.alarmName.equals(that.alarmName) : that.alarmName != null) return false;
            if (this.datapointsToAlarm != null ? !this.datapointsToAlarm.equals(that.datapointsToAlarm) : that.datapointsToAlarm != null) return false;
            if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
            if (this.evaluateLowSampleCountPercentile != null ? !this.evaluateLowSampleCountPercentile.equals(that.evaluateLowSampleCountPercentile) : that.evaluateLowSampleCountPercentile != null) return false;
            if (this.extendedStatistic != null ? !this.extendedStatistic.equals(that.extendedStatistic) : that.extendedStatistic != null) return false;
            if (this.insufficientDataActions != null ? !this.insufficientDataActions.equals(that.insufficientDataActions) : that.insufficientDataActions != null) return false;
            if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) return false;
            if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            if (this.okActions != null ? !this.okActions.equals(that.okActions) : that.okActions != null) return false;
            if (this.period != null ? !this.period.equals(that.period) : that.period != null) return false;
            if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.threshold != null ? !this.threshold.equals(that.threshold) : that.threshold != null) return false;
            if (this.thresholdMetricId != null ? !this.thresholdMetricId.equals(that.thresholdMetricId) : that.thresholdMetricId != null) return false;
            if (this.treatMissingData != null ? !this.treatMissingData.equals(that.treatMissingData) : that.treatMissingData != null) return false;
            return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comparisonOperator.hashCode();
            result = 31 * result + (this.evaluationPeriods.hashCode());
            result = 31 * result + (this.actionsEnabled != null ? this.actionsEnabled.hashCode() : 0);
            result = 31 * result + (this.alarmActions != null ? this.alarmActions.hashCode() : 0);
            result = 31 * result + (this.alarmDescription != null ? this.alarmDescription.hashCode() : 0);
            result = 31 * result + (this.alarmName != null ? this.alarmName.hashCode() : 0);
            result = 31 * result + (this.datapointsToAlarm != null ? this.datapointsToAlarm.hashCode() : 0);
            result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            result = 31 * result + (this.evaluateLowSampleCountPercentile != null ? this.evaluateLowSampleCountPercentile.hashCode() : 0);
            result = 31 * result + (this.extendedStatistic != null ? this.extendedStatistic.hashCode() : 0);
            result = 31 * result + (this.insufficientDataActions != null ? this.insufficientDataActions.hashCode() : 0);
            result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
            result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.okActions != null ? this.okActions.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.threshold != null ? this.threshold.hashCode() : 0);
            result = 31 * result + (this.thresholdMetricId != null ? this.thresholdMetricId.hashCode() : 0);
            result = 31 * result + (this.treatMissingData != null ? this.treatMissingData.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            return result;
        }
    }
}
