package software.amazon.awscdk.services.codebuild;

/**
 * BuildSpec for CodeBuild projects.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codebuild.*;
 * Project codebuildProject = Project.Builder.create(this, "Project")
 *         .projectName("MyTestProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("echo \"Hello, CodeBuild!\""))))))
 *         .build();
 * CodeBuildStartBuild task = CodeBuildStartBuild.Builder.create(this, "Task")
 *         .project(codebuildProject)
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .environmentVariablesOverride(Map.of(
 *                 "ZONE", BuildEnvironmentVariable.builder()
 *                         .type(BuildEnvironmentVariableType.PLAINTEXT)
 *                         .value(JsonPath.stringAt("$.envVariables.zone"))
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:10.857Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.BuildSpec")
public abstract class BuildSpec extends software.amazon.jsii.JsiiObject {

    protected BuildSpec(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BuildSpec(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected BuildSpec() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use the contents of a local file as the build spec string.
     * <p>
     * Use this if you have a local .yml or .json file that you want to use as the buildspec
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.BuildSpec.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec fromObject(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.BuildSpec.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Create a buildspec from an object that will be rendered as YAML in the resulting CloudFormation template.
     * <p>
     * @param value the object containing the buildspec that will be rendered as YAML. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec fromObjectToYaml(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.BuildSpec.class, "fromObjectToYaml", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Use a file from the source as buildspec.
     * <p>
     * Use this if you want to use a file different from 'buildspec.yml'`
     * <p>
     * @param filename This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec fromSourceFilename(final @org.jetbrains.annotations.NotNull java.lang.String filename) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.BuildSpec.class, "fromSourceFilename", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(filename, "filename is required") });
    }

    /**
     * Render the represented BuildSpec.
     * <p>
     * @param scope
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String toBuildSpec(final @org.jetbrains.annotations.Nullable software.constructs.Construct scope);

    /**
     * Render the represented BuildSpec.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String toBuildSpec();

    /**
     * Whether the buildspec is directly available or deferred until build-time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Boolean getIsImmediate();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codebuild.BuildSpec {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Whether the buildspec is directly available or deferred until build-time.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getIsImmediate() {
            return software.amazon.jsii.Kernel.get(this, "isImmediate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Render the represented BuildSpec.
         * <p>
         * @param scope
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String toBuildSpec(final @org.jetbrains.annotations.Nullable software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "toBuildSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { scope });
        }

        /**
         * Render the represented BuildSpec.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String toBuildSpec() {
            return software.amazon.jsii.Kernel.call(this, "toBuildSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
