package software.amazon.awscdk.services.codebuild;

/**
 * Cache options for CodeBuild Project.
 * <p>
 * A cache can store reusable pieces of your build environment and use them across multiple builds.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup;
 * CodeBuildStep.Builder.create("Synth")
 *         // ...standard ShellStep props...
 *         .commands(List.of())
 *         .env(Map.of())
 *         // If you are using a CodeBuildStep explicitly, set the 'cdk.out' directory
 *         // to be the synth step's output.
 *         .primaryOutputDirectory("cdk.out")
 *         // Control the name of the project
 *         .projectName("MyProject")
 *         // Control parts of the BuildSpec other than the regular 'build' and 'install' commands
 *         .partialBuildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         // Control the build environment
 *         .buildEnvironment(BuildEnvironment.builder()
 *                 .computeType(ComputeType.LARGE)
 *                 .privileged(true)
 *                 .build())
 *         .timeout(Duration.minutes(90))
 *         .fileSystemLocations(List.of(FileSystemLocation.efs(EfsFileSystemLocationProps.builder()
 *                 .identifier("myidentifier2")
 *                 .location("myclodation.mydnsroot.com:/loc")
 *                 .mountPoint("/media")
 *                 .mountOptions("opts")
 *                 .build())))
 *         // Control Elastic Network Interface creation
 *         .vpc(vpc)
 *         .subnetSelection(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_EGRESS).build())
 *         .securityGroups(List.of(mySecurityGroup))
 *         // Control caching
 *         .cache(Cache.bucket(new Bucket(this, "Cache")))
 *         // Additional policy statements for the execution role
 *         .rolePolicyStatements(List.of(
 *             PolicyStatement.Builder.create().build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-caching.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:10.858Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.Cache")
public abstract class Cache extends software.amazon.jsii.JsiiObject {

    protected Cache(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cache(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Cache() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create an S3 caching strategy.
     * <p>
     * @param bucket the S3 bucket to use for caching. This parameter is required.
     * @param options additional options to pass to the S3 caching.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.BucketCacheOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), options });
    }

    /**
     * Create an S3 caching strategy.
     * <p>
     * @param bucket the S3 bucket to use for caching. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required") });
    }

    /**
     * Create a local caching strategy.
     * <p>
     * @param modes the mode(s) to enable for local caching. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache local(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.LocalCacheMode... modes) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "local", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class), java.util.Arrays.<Object>stream(modes).toArray(Object[]::new));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.Cache none() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.Cache.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.Cache.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codebuild.Cache {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
