package software.amazon.awscdk.services.codebuild;

/**
 * Build environment type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Fleet fleet = Fleet.Builder.create(this, "Fleet")
 *         .computeType(FleetComputeType.MEDIUM)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .baseCapacity(1)
 *         .build();
 * Project.Builder.create(this, "Project")
 *         .environment(BuildEnvironment.builder()
 *                 .fleet(fleet)
 *                 .buildImage(LinuxBuildImage.STANDARD_7_0)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html#environment.types</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:10.924Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.EnvironmentType")
public enum EnvironmentType {
    /**
     * ARM container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM_CONTAINER,
    /**
     * Linux container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINUX_CONTAINER,
    /**
     * Linux GPU container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINUX_GPU_CONTAINER,
    /**
     * Windows Server 2019 container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_SERVER_2019_CONTAINER,
    /**
     * Windows Server 2022 container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_SERVER_2022_CONTAINER,
    /**
     * MacOS ARM container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC_ARM,
    /**
     * Linux EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINUX_EC2,
    /**
     * ARM EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM_EC2,
    /**
     * Windows EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WINDOWS_EC2,
}
