package software.amazon.awscdk.services.codedeploy;

/**
 * Complete base deployment config properties that are required to be supplied by the implementation of the BaseDeploymentConfig class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.codedeploy.*;
 * MinimumHealthyHosts minimumHealthyHosts;
 * MinimumHealthyHostsPerZone minimumHealthyHostsPerZone;
 * TrafficRouting trafficRouting;
 * BaseDeploymentConfigProps baseDeploymentConfigProps = BaseDeploymentConfigProps.builder()
 *         .computePlatform(ComputePlatform.SERVER)
 *         .deploymentConfigName("deploymentConfigName")
 *         .minimumHealthyHosts(minimumHealthyHosts)
 *         .trafficRouting(trafficRouting)
 *         .zonalConfig(ZonalConfig.builder()
 *                 .firstZoneMonitorDuration(Duration.minutes(30))
 *                 .minimumHealthyHostsPerZone(minimumHealthyHostsPerZone)
 *                 .monitorDuration(Duration.minutes(30))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.027Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.BaseDeploymentConfigProps")
@software.amazon.jsii.Jsii.Proxy(BaseDeploymentConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseDeploymentConfigProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codedeploy.BaseDeploymentConfigOptions {

    /**
     * The destination compute platform for the deployment.
     * <p>
     * Default: ComputePlatform.Server
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.ComputePlatform getComputePlatform() {
        return null;
    }

    /**
     * Minimum number of healthy hosts.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts() {
        return null;
    }

    /**
     * The configuration that specifies how traffic is shifted during a deployment.
     * <p>
     * Only applicable to ECS and Lambda deployments, and must not be specified for Server deployments.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.TrafficRouting getTrafficRouting() {
        return null;
    }

    /**
     * Configure CodeDeploy to deploy your application to one Availability Zone at a time within an AWS Region.
     * <p>
     * Default: - deploy your application to a random selection of hosts across a Region
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config">https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codedeploy.ZonalConfig getZonalConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseDeploymentConfigProps> {
        software.amazon.awscdk.services.codedeploy.ComputePlatform computePlatform;
        software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting;
        software.amazon.awscdk.services.codedeploy.ZonalConfig zonalConfig;
        java.lang.String deploymentConfigName;

        /**
         * Sets the value of {@link BaseDeploymentConfigProps#getComputePlatform}
         * @param computePlatform The destination compute platform for the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computePlatform(software.amazon.awscdk.services.codedeploy.ComputePlatform computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        /**
         * Sets the value of {@link BaseDeploymentConfigProps#getMinimumHealthyHosts}
         * @param minimumHealthyHosts Minimum number of healthy hosts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        /**
         * Sets the value of {@link BaseDeploymentConfigProps#getTrafficRouting}
         * @param trafficRouting The configuration that specifies how traffic is shifted during a deployment.
         *                       Only applicable to ECS and Lambda deployments, and must not be specified for Server deployments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trafficRouting(software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting) {
            this.trafficRouting = trafficRouting;
            return this;
        }

        /**
         * Sets the value of {@link BaseDeploymentConfigProps#getZonalConfig}
         * @param zonalConfig Configure CodeDeploy to deploy your application to one Availability Zone at a time within an AWS Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalConfig(software.amazon.awscdk.services.codedeploy.ZonalConfig zonalConfig) {
            this.zonalConfig = zonalConfig;
            return this;
        }

        /**
         * Sets the value of {@link BaseDeploymentConfigProps#getDeploymentConfigName}
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(java.lang.String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseDeploymentConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseDeploymentConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseDeploymentConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseDeploymentConfigProps {
        private final software.amazon.awscdk.services.codedeploy.ComputePlatform computePlatform;
        private final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts;
        private final software.amazon.awscdk.services.codedeploy.TrafficRouting trafficRouting;
        private final software.amazon.awscdk.services.codedeploy.ZonalConfig zonalConfig;
        private final java.lang.String deploymentConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computePlatform = software.amazon.jsii.Kernel.get(this, "computePlatform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ComputePlatform.class));
            this.minimumHealthyHosts = software.amazon.jsii.Kernel.get(this, "minimumHealthyHosts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts.class));
            this.trafficRouting = software.amazon.jsii.Kernel.get(this, "trafficRouting", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.TrafficRouting.class));
            this.zonalConfig = software.amazon.jsii.Kernel.get(this, "zonalConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.ZonalConfig.class));
            this.deploymentConfigName = software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computePlatform = builder.computePlatform;
            this.minimumHealthyHosts = builder.minimumHealthyHosts;
            this.trafficRouting = builder.trafficRouting;
            this.zonalConfig = builder.zonalConfig;
            this.deploymentConfigName = builder.deploymentConfigName;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.ComputePlatform getComputePlatform() {
            return this.computePlatform;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts getMinimumHealthyHosts() {
            return this.minimumHealthyHosts;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.TrafficRouting getTrafficRouting() {
            return this.trafficRouting;
        }

        @Override
        public final software.amazon.awscdk.services.codedeploy.ZonalConfig getZonalConfig() {
            return this.zonalConfig;
        }

        @Override
        public final java.lang.String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComputePlatform() != null) {
                data.set("computePlatform", om.valueToTree(this.getComputePlatform()));
            }
            if (this.getMinimumHealthyHosts() != null) {
                data.set("minimumHealthyHosts", om.valueToTree(this.getMinimumHealthyHosts()));
            }
            if (this.getTrafficRouting() != null) {
                data.set("trafficRouting", om.valueToTree(this.getTrafficRouting()));
            }
            if (this.getZonalConfig() != null) {
                data.set("zonalConfig", om.valueToTree(this.getZonalConfig()));
            }
            if (this.getDeploymentConfigName() != null) {
                data.set("deploymentConfigName", om.valueToTree(this.getDeploymentConfigName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codedeploy.BaseDeploymentConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseDeploymentConfigProps.Jsii$Proxy that = (BaseDeploymentConfigProps.Jsii$Proxy) o;

            if (this.computePlatform != null ? !this.computePlatform.equals(that.computePlatform) : that.computePlatform != null) return false;
            if (this.minimumHealthyHosts != null ? !this.minimumHealthyHosts.equals(that.minimumHealthyHosts) : that.minimumHealthyHosts != null) return false;
            if (this.trafficRouting != null ? !this.trafficRouting.equals(that.trafficRouting) : that.trafficRouting != null) return false;
            if (this.zonalConfig != null ? !this.zonalConfig.equals(that.zonalConfig) : that.zonalConfig != null) return false;
            return this.deploymentConfigName != null ? this.deploymentConfigName.equals(that.deploymentConfigName) : that.deploymentConfigName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computePlatform != null ? this.computePlatform.hashCode() : 0;
            result = 31 * result + (this.minimumHealthyHosts != null ? this.minimumHealthyHosts.hashCode() : 0);
            result = 31 * result + (this.trafficRouting != null ? this.trafficRouting.hashCode() : 0);
            result = 31 * result + (this.zonalConfig != null ? this.zonalConfig.hashCode() : 0);
            result = 31 * result + (this.deploymentConfigName != null ? this.deploymentConfigName.hashCode() : 0);
            return result;
        }
    }
}
