package software.amazon.awscdk.services.codedeploy;

/**
 * A custom Deployment Configuration for an EC2/on-premise Deployment Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ServerDeploymentConfig deploymentConfig = ServerDeploymentConfig.Builder.create(this, "DeploymentConfiguration")
 *         .deploymentConfigName("MyDeploymentConfiguration") // optional property
 *         // one of these is required, but both cannot be specified at the same time
 *         .minimumHealthyHosts(MinimumHealthyHosts.count(2))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.087Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.ServerDeploymentConfig")
public class ServerDeploymentConfig extends software.amazon.awscdk.services.codedeploy.BaseDeploymentConfig implements software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig {

    protected ServerDeploymentConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServerDeploymentConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL_AT_ONCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig.class, "ALL_AT_ONCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class));
        HALF_AT_A_TIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig.class, "HALF_AT_A_TIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class));
        ONE_AT_A_TIME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig.class, "ONE_AT_A_TIME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class));
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServerDeploymentConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.ServerDeploymentConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a custom Deployment Configuration for an EC2/on-premise Deployment Group defined either outside the CDK app, or in a different region.
     * <p>
     * @return a Construct representing a reference to an existing custom Deployment Configuration
     * @param scope the parent Construct for this new Construct. This parameter is required.
     * @param id the logical ID of this new Construct. This parameter is required.
     * @param serverDeploymentConfigName the properties of the referenced custom Deployment Configuration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig fromServerDeploymentConfigName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String serverDeploymentConfigName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig.class, "fromServerDeploymentConfigName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(serverDeploymentConfigName, "serverDeploymentConfigName is required") });
    }

    /**
     * The CodeDeployDefault.AllAtOnce predefined deployment configuration for EC2/on-premises compute platform.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server">https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig ALL_AT_ONCE;

    /**
     * The CodeDeployDefault.HalfAtATime predefined deployment configuration for EC2/on-premises compute platform.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server">https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig HALF_AT_A_TIME;

    /**
     * The CodeDeployDefault.OneAtATime predefined deployment configuration for EC2/on-premises compute platform.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server">https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html#deployment-configuration-server</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codedeploy.IServerDeploymentConfig ONE_AT_A_TIME;

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codedeploy.ServerDeploymentConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codedeploy.ServerDeploymentConfigProps.Builder();
        }

        /**
         * The physical, human-readable name of the Deployment Configuration.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param deploymentConfigName The physical, human-readable name of the Deployment Configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfigName(final java.lang.String deploymentConfigName) {
            this.props.deploymentConfigName(deploymentConfigName);
            return this;
        }

        /**
         * Minimum number of healthy hosts.
         * <p>
         * @return {@code this}
         * @param minimumHealthyHosts Minimum number of healthy hosts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumHealthyHosts(final software.amazon.awscdk.services.codedeploy.MinimumHealthyHosts minimumHealthyHosts) {
            this.props.minimumHealthyHosts(minimumHealthyHosts);
            return this;
        }

        /**
         * Configure CodeDeploy to deploy your application to one Availability Zone at a time within an AWS Region.
         * <p>
         * Default: - deploy your application to a random selection of hosts across a Region
         * <p>
         * @return {@code this}
         * @param zonalConfig Configure CodeDeploy to deploy your application to one Availability Zone at a time within an AWS Region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalConfig(final software.amazon.awscdk.services.codedeploy.ZonalConfig zonalConfig) {
            this.props.zonalConfig(zonalConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig build() {
            return new software.amazon.awscdk.services.codedeploy.ServerDeploymentConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
