package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of <code>Ec2DeployAction</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceOutput = new Artifact();
 * Pipeline pipeline = Pipeline.Builder.create(this, "MyPipeline")
 *         .pipelineType(PipelineType.V2)
 *         .build();
 * Ec2DeployAction deployAction = Ec2DeployAction.Builder.create()
 *         .actionName("Ec2Deploy")
 *         .input(sourceOutput)
 *         .instanceType(Ec2InstanceType.EC2)
 *         .instanceTagKey("Name")
 *         .instanceTagValue("MyInstance")
 *         .deploySpecifications(Ec2DeploySpecifications.inline(Ec2DeploySpecificationsInlineProps.builder()
 *                 .targetDirectory("/home/ec2-user/deploy")
 *                 .preScript("scripts/pre-deploy.sh")
 *                 .postScript("scripts/post-deploy.sh")
 *                 .build()))
 *         .build();
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(deployAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.285Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.Ec2DeployActionProps")
@software.amazon.jsii.Jsii.Proxy(Ec2DeployActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Ec2DeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The deploy specifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications getDeploySpecifications();

    /**
     * The input artifact to deploy to EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getInput();

    /**
     * The tag key of the instances that you created in Amazon EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceTagKey();

    /**
     * The type of instances or SSM nodes created in Amazon EC2.
     * <p>
     * You must have already created, tagged, and installed the SSM agent on all instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Ec2InstanceType getInstanceType();

    /**
     * The tag value of the instances that you created in Amazon EC2.
     * <p>
     * Default: - all instances with `instanceTagKey` will be matched
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceTagValue() {
        return null;
    }

    /**
     * The number or percentage of instances that can deploy in parallel.
     * <p>
     * Default: - No configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances getMaxBatch() {
        return null;
    }

    /**
     * Stop the task after the task fails on the specified number or percentage of instances.
     * <p>
     * Default: - No configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances getMaxError() {
        return null;
    }

    /**
     * The list of target groups for deployment. You must have already created the target groups.
     * <p>
     * Target groups provide a set of instances to process specific requests.
     * If the target group is specified, instances will be removed from the target group before deployment and added back to the target group after deployment.
     * <p>
     * Default: - No target groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup> getTargetGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Ec2DeployActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Ec2DeployActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Ec2DeployActionProps> {
        software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications deploySpecifications;
        software.amazon.awscdk.services.codepipeline.Artifact input;
        java.lang.String instanceTagKey;
        software.amazon.awscdk.services.codepipeline.actions.Ec2InstanceType instanceType;
        java.lang.String instanceTagValue;
        software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxBatch;
        software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxError;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup> targetGroups;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link Ec2DeployActionProps#getDeploySpecifications}
         * @param deploySpecifications The deploy specifications. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploySpecifications(software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications deploySpecifications) {
            this.deploySpecifications = deploySpecifications;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getInput}
         * @param input The input artifact to deploy to EC2 instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getInstanceTagKey}
         * @param instanceTagKey The tag key of the instances that you created in Amazon EC2. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTagKey(java.lang.String instanceTagKey) {
            this.instanceTagKey = instanceTagKey;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getInstanceType}
         * @param instanceType The type of instances or SSM nodes created in Amazon EC2. This parameter is required.
         *                     You must have already created, tagged, and installed the SSM agent on all instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.codepipeline.actions.Ec2InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getInstanceTagValue}
         * @param instanceTagValue The tag value of the instances that you created in Amazon EC2.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTagValue(java.lang.String instanceTagValue) {
            this.instanceTagValue = instanceTagValue;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getMaxBatch}
         * @param maxBatch The number or percentage of instances that can deploy in parallel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatch(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxBatch) {
            this.maxBatch = maxBatch;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getMaxError}
         * @param maxError Stop the task after the task fails on the specified number or percentage of instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxError(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxError) {
            this.maxError = maxError;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getTargetGroups}
         * @param targetGroups The list of target groups for deployment. You must have already created the target groups.
         *                     Target groups provide a set of instances to process specific requests.
         *                     If the target group is specified, instances will be removed from the target group before deployment and added back to the target group after deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targetGroups(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup> targetGroups) {
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup>)targetGroups;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link Ec2DeployActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Ec2DeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Ec2DeployActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Ec2DeployActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2DeployActionProps {
        private final software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications deploySpecifications;
        private final software.amazon.awscdk.services.codepipeline.Artifact input;
        private final java.lang.String instanceTagKey;
        private final software.amazon.awscdk.services.codepipeline.actions.Ec2InstanceType instanceType;
        private final java.lang.String instanceTagValue;
        private final software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxBatch;
        private final software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances maxError;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup> targetGroups;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploySpecifications = software.amazon.jsii.Kernel.get(this, "deploySpecifications", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.instanceTagKey = software.amazon.jsii.Kernel.get(this, "instanceTagKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Ec2InstanceType.class));
            this.instanceTagValue = software.amazon.jsii.Kernel.get(this, "instanceTagValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxBatch = software.amazon.jsii.Kernel.get(this, "maxBatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances.class));
            this.maxError = software.amazon.jsii.Kernel.get(this, "maxError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances.class));
            this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploySpecifications = java.util.Objects.requireNonNull(builder.deploySpecifications, "deploySpecifications is required");
            this.input = java.util.Objects.requireNonNull(builder.input, "input is required");
            this.instanceTagKey = java.util.Objects.requireNonNull(builder.instanceTagKey, "instanceTagKey is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.instanceTagValue = builder.instanceTagValue;
            this.maxBatch = builder.maxBatch;
            this.maxError = builder.maxError;
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup>)builder.targetGroups;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.Ec2DeploySpecifications getDeploySpecifications() {
            return this.deploySpecifications;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getInput() {
            return this.input;
        }

        @Override
        public final java.lang.String getInstanceTagKey() {
            return this.instanceTagKey;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.Ec2InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getInstanceTagValue() {
            return this.instanceTagValue;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances getMaxBatch() {
            return this.maxBatch;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances getMaxError() {
            return this.maxError;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deploySpecifications", om.valueToTree(this.getDeploySpecifications()));
            data.set("input", om.valueToTree(this.getInput()));
            data.set("instanceTagKey", om.valueToTree(this.getInstanceTagKey()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getInstanceTagValue() != null) {
                data.set("instanceTagValue", om.valueToTree(this.getInstanceTagValue()));
            }
            if (this.getMaxBatch() != null) {
                data.set("maxBatch", om.valueToTree(this.getMaxBatch()));
            }
            if (this.getMaxError() != null) {
                data.set("maxError", om.valueToTree(this.getMaxError()));
            }
            if (this.getTargetGroups() != null) {
                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.Ec2DeployActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Ec2DeployActionProps.Jsii$Proxy that = (Ec2DeployActionProps.Jsii$Proxy) o;

            if (!deploySpecifications.equals(that.deploySpecifications)) return false;
            if (!input.equals(that.input)) return false;
            if (!instanceTagKey.equals(that.instanceTagKey)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (this.instanceTagValue != null ? !this.instanceTagValue.equals(that.instanceTagValue) : that.instanceTagValue != null) return false;
            if (this.maxBatch != null ? !this.maxBatch.equals(that.maxBatch) : that.maxBatch != null) return false;
            if (this.maxError != null ? !this.maxError.equals(that.maxError) : that.maxError != null) return false;
            if (this.targetGroups != null ? !this.targetGroups.equals(that.targetGroups) : that.targetGroups != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploySpecifications.hashCode();
            result = 31 * result + (this.input.hashCode());
            result = 31 * result + (this.instanceTagKey.hashCode());
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.instanceTagValue != null ? this.instanceTagValue.hashCode() : 0);
            result = 31 * result + (this.maxBatch != null ? this.maxBatch.hashCode() : 0);
            result = 31 * result + (this.maxError != null ? this.maxError.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
