package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The type of instances or SSM nodes created in Amazon EC2.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceOutput = new Artifact();
 * Pipeline pipeline = Pipeline.Builder.create(this, "MyPipeline")
 *         .pipelineType(PipelineType.V2)
 *         .build();
 * Ec2DeployAction deployAction = Ec2DeployAction.Builder.create()
 *         .actionName("Ec2Deploy")
 *         .input(sourceOutput)
 *         .instanceType(Ec2InstanceType.EC2)
 *         .instanceTagKey("Name")
 *         .instanceTagValue("MyInstance")
 *         .deploySpecifications(Ec2DeploySpecifications.inline(Ec2DeploySpecificationsInlineProps.builder()
 *                 .targetDirectory("/home/ec2-user/deploy")
 *                 .preScript("scripts/pre-deploy.sh")
 *                 .postScript("scripts/post-deploy.sh")
 *                 .build()))
 *         .build();
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(deployAction))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-EC2Deploy.html#action-reference-EC2Deploy-parameters">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-EC2Deploy.html#action-reference-EC2Deploy-parameters</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.287Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.Ec2InstanceType")
public enum Ec2InstanceType {
    /**
     * Amazon EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EC2,
    /**
     * AWS System Manager (SSM) managed nodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SSM_MANAGED_NODE,
}
