package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline build action that uses AWS EcrBuildAndPublish.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.*;
 * Pipeline pipeline;
 * IRepository repository;
 * Artifact sourceOutput = new Artifact();
 * // your source repository
 * CodeStarConnectionsSourceAction sourceAction = CodeStarConnectionsSourceAction.Builder.create()
 *         .actionName("CodeStarConnectionsSourceAction")
 *         .output(sourceOutput)
 *         .connectionArn("your-connection-arn")
 *         .owner("your-owner")
 *         .repo("your-repo")
 *         .build();
 * EcrBuildAndPublishAction buildAction = EcrBuildAndPublishAction.Builder.create()
 *         .actionName("EcrBuildAndPublishAction")
 *         .repositoryName(repository.getRepositoryName())
 *         .registryType(RegistryType.PRIVATE)
 *         .dockerfileDirectoryPath("./my-dir") // The path indicates ./my-dir/Dockerfile in the source repository
 *         .imageTags(List.of("my-tag-1", "my-tag-2"))
 *         .input(sourceOutput)
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Source")
 *         .actions(List.of(sourceAction))
 *         .build());
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Build")
 *         .actions(List.of(buildAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.288Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.EcrBuildAndPublishAction")
public class EcrBuildAndPublishAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected EcrBuildAndPublishAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcrBuildAndPublishAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcrBuildAndPublishAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The variables emitted by this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishVariables getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishVariables.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The artifact produced by the source action that contains the Dockerfile needed to build the image.
         * <p>
         * @return {@code this}
         * @param input The artifact produced by the source action that contains the Dockerfile needed to build the image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.props.input(input);
            return this;
        }

        /**
         * The name of the ECR repository where the image is pushed.
         * <p>
         * @return {@code this}
         * @param repositoryName The name of the ECR repository where the image is pushed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * The directory path of Dockerfile used to build the image.
         * <p>
         * Optionally, you can provide an alternate directory path if Dockerfile is not at the root level.
         * <p>
         * Default: - the source repository root level
         * <p>
         * @return {@code this}
         * @param dockerfileDirectoryPath The directory path of Dockerfile used to build the image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerfileDirectoryPath(final java.lang.String dockerfileDirectoryPath) {
            this.props.dockerfileDirectoryPath(dockerfileDirectoryPath);
            return this;
        }

        /**
         * The tags used for the image.
         * <p>
         * Default: - latest
         * <p>
         * @return {@code this}
         * @param imageTags The tags used for the image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTags(final java.util.List<java.lang.String> imageTags) {
            this.props.imageTags(imageTags);
            return this;
        }

        /**
         * Specifies whether the repository is public or private.
         * <p>
         * Default: - RegistryType.PRIVATE
         * <p>
         * @return {@code this}
         * @param registryType Specifies whether the repository is public or private. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registryType(final software.amazon.awscdk.services.codepipeline.actions.RegistryType registryType) {
            this.props.registryType(registryType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.EcrBuildAndPublishAction(
                this.props.build()
            );
        }
    }
}
