package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The types of revision for a pipeline execution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * IPipeline targetPipeline = Pipeline.fromPipelineArn(this, "Pipeline", "arn:aws:codepipeline:us-east-1:123456789012:InvokePipelineAction"); // If targetPipeline is not created by cdk, import from arn.
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("stageName")
 *         .actions(List.of(PipelineInvokeAction.Builder.create()
 *                 .actionName("Invoke")
 *                 .targetPipeline(targetPipeline)
 *                 .variables(List.of(Variable.builder()
 *                         .name("name1")
 *                         .value("value1")
 *                         .build()))
 *                 .sourceRevisions(List.of(SourceRevision.builder()
 *                         .actionName("Source")
 *                         .revisionType(RevisionType.S3_OBJECT_VERSION_ID)
 *                         .revisionValue("testRevisionValue")
 *                         .build()))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.326Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.RevisionType")
public enum RevisionType {
    /**
     * The revision type is a commit id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMMIT_ID,
    /**
     * The revision type is an image digest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IMAGE_DIGEST,
    /**
     * The revision type is an s3 object version id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_OBJECT_VERSION_ID,
    /**
     * The revision type is an s3 object version key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_OBJECT_KEY,
}
