package software.amazon.awscdk.services.cognito;

/**
 * A scope for ResourceServer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * ResourceServerScope readOnlyScope = ResourceServerScope.Builder.create().scopeName("read").scopeDescription("Read-only access").build();
 * ResourceServerScope fullAccessScope = ResourceServerScope.Builder.create().scopeName("*").scopeDescription("Full access").build();
 * UserPoolResourceServer userServer = pool.addResourceServer("ResourceServer", UserPoolResourceServerOptions.builder()
 *         .identifier("users")
 *         .scopes(List.of(readOnlyScope, fullAccessScope))
 *         .build());
 * UserPoolClient readOnlyClient = pool.addClient("read-only-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, readOnlyScope)))
 *                 .build())
 *         .build());
 * UserPoolClient fullAccessClient = pool.addClient("full-access-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, fullAccessScope)))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.519Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.ResourceServerScope")
public class ResourceServerScope extends software.amazon.jsii.JsiiObject {

    protected ResourceServerScope(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResourceServerScope(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResourceServerScope(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.ResourceServerScopeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A description of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScopeDescription() {
        return software.amazon.jsii.Kernel.get(this, "scopeDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScopeName() {
        return software.amazon.jsii.Kernel.get(this, "scopeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.ResourceServerScope}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.ResourceServerScope> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cognito.ResourceServerScopeProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cognito.ResourceServerScopeProps.Builder();
        }

        /**
         * A description of the scope.
         * <p>
         * @return {@code this}
         * @param scopeDescription A description of the scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopeDescription(final java.lang.String scopeDescription) {
            this.props.scopeDescription(scopeDescription);
            return this;
        }

        /**
         * The name of the scope.
         * <p>
         * @return {@code this}
         * @param scopeName The name of the scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopeName(final java.lang.String scopeName) {
            this.props.scopeName(scopeName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.ResourceServerScope}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.ResourceServerScope build() {
            return new software.amazon.awscdk.services.cognito.ResourceServerScope(
                this.props.build()
            );
        }
    }
}
