package software.amazon.awscdk.services.cognito;

/**
 * Define a Cognito User Pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * pool.addClient("app-client", UserPoolClientOptions.builder()
 *         .oAuth(OAuthSettings.builder()
 *                 .flows(OAuthFlows.builder()
 *                         .authorizationCodeGrant(true)
 *                         .build())
 *                 .scopes(List.of(OAuthScope.OPENID))
 *                 .callbackUrls(List.of("https://my-app-domain.com/welcome"))
 *                 .logoutUrls(List.of("https://my-app-domain.com/signin"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.526Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPool")
public class UserPool extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cognito.IUserPool {

    protected UserPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPool.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing user pool based on its ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userPoolArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool fromUserPoolArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String userPoolArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPool.class, "fromUserPoolArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userPoolArn, "userPoolArn is required") });
    }

    /**
     * Import an existing user pool based on its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param userPoolId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool fromUserPoolId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String userPoolId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPool.class, "fromUserPoolId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(userPoolId, "userPoolId is required") });
    }

    /**
     * Add a new app client to this user pool.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.UserPoolClientOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addClient", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClient.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Add a new app client to this user pool.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClient addClient(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addClient", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClient.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Associate a domain to this user pool.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomain addDomain(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolDomainOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolDomain.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a new group to this user pool.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolGroup addGroup(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolGroupOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a new resource server to this user pool.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolResourceServer addResourceServer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolResourceServerOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addResourceServer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolResourceServer.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a lambda trigger to a user pool operation.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html</a>
     * @param operation This parameter is required.
     * @param fn This parameter is required.
     * @param lambdaVersion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTrigger(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolOperation operation, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.LambdaVersion lambdaVersion) {
        software.amazon.jsii.Kernel.call(this, "addTrigger", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(operation, "operation is required"), java.util.Objects.requireNonNull(fn, "fn is required"), lambdaVersion });
    }

    /**
     * Add a lambda trigger to a user pool operation.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html</a>
     * @param operation This parameter is required.
     * @param fn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTrigger(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolOperation operation, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        software.amazon.jsii.Kernel.call(this, "addTrigger", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(operation, "operation is required"), java.util.Objects.requireNonNull(fn, "fn is required") });
    }

    /**
     * Adds an IAM policy statement associated with this user pool to an IAM principal's policy.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Register an identity provider with this user pool.
     * <p>
     * @param provider This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerIdentityProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider provider) {
        software.amazon.jsii.Kernel.call(this, "registerIdentityProvider", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(provider, "provider is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Get all identity providers registered with this user pool.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider> getIdentityProviders() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "identityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider.class))));
    }

    /**
     * The ARN of the user pool.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn() {
        return software.amazon.jsii.Kernel.get(this, "userPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The physical ID of this user pool resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * User pool provider name.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolProviderName() {
        return software.amazon.jsii.Kernel.get(this, "userPoolProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * User pool provider URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolProviderUrl() {
        return software.amazon.jsii.Kernel.get(this, "userPoolProviderUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cognito.UserPoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * How will a user be able to recover their account?
         * <p>
         * Default: AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL
         * <p>
         * @return {@code this}
         * @param accountRecovery How will a user be able to recover their account?. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountRecovery(final software.amazon.awscdk.services.cognito.AccountRecovery accountRecovery) {
            this.props().accountRecovery(accountRecovery);
            return this;
        }

        /**
         * (deprecated) The user pool's Advanced Security Mode.
         * <p>
         * Default: - no value
         * <p>
         * @return {@code this}
         * @deprecated Advanced Security Mode is deprecated due to user pool feature plans. Use StandardThreatProtectionMode and CustomThreatProtectionMode to set Thread Protection level.
         * @param advancedSecurityMode The user pool's Advanced Security Mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder advancedSecurityMode(final software.amazon.awscdk.services.cognito.AdvancedSecurityMode advancedSecurityMode) {
            this.props().advancedSecurityMode(advancedSecurityMode);
            return this;
        }

        /**
         * Attributes which Cognito will look to verify automatically upon user sign up.
         * <p>
         * EMAIL and PHONE are the only available options.
         * <p>
         * Default: - If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default.
         * If absent, no attributes will be auto-verified.
         * <p>
         * @return {@code this}
         * @param autoVerify Attributes which Cognito will look to verify automatically upon user sign up. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoVerify(final software.amazon.awscdk.services.cognito.AutoVerifiedAttrs autoVerify) {
            this.props().autoVerify(autoVerify);
            return this;
        }

        /**
         * Define a set of custom attributes that can be configured for each user in the user pool.
         * <p>
         * Default: - No custom attributes.
         * <p>
         * @return {@code this}
         * @param customAttributes Define a set of custom attributes that can be configured for each user in the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAttributes(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.cognito.ICustomAttribute> customAttributes) {
            this.props().customAttributes(customAttributes);
            return this;
        }

        /**
         * This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates.
         * <p>
         * Default: - no key ID configured
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sender-triggers.html</a>
         * @param customSenderKmsKey This key will be used to encrypt temporary passwords and authorization codes that Amazon Cognito generates. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSenderKmsKey(final software.amazon.awscdk.services.kms.IKey customSenderKmsKey) {
            this.props().customSenderKmsKey(customSenderKmsKey);
            return this;
        }

        /**
         * The Type of Threat Protection Enabled for Custom Authentication.
         * <p>
         * This feature only functions if your FeaturePlan is set to FeaturePlan.PLUS
         * <p>
         * Default: - no value
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html</a>
         * @param customThreatProtectionMode The Type of Threat Protection Enabled for Custom Authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customThreatProtectionMode(final software.amazon.awscdk.services.cognito.CustomThreatProtectionMode customThreatProtectionMode) {
            this.props().customThreatProtectionMode(customThreatProtectionMode);
            return this;
        }

        /**
         * Indicates whether the user pool should have deletion protection enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether the user pool should have deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Device tracking settings.
         * <p>
         * Default: - see defaults on each property of DeviceTracking.
         * <p>
         * @return {@code this}
         * @param deviceTracking Device tracking settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceTracking(final software.amazon.awscdk.services.cognito.DeviceTracking deviceTracking) {
            this.props().deviceTracking(deviceTracking);
            return this;
        }

        /**
         * Email settings for a user pool.
         * <p>
         * Default: - cognito will use the default email configuration
         * <p>
         * @return {@code this}
         * @param email Email settings for a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(final software.amazon.awscdk.services.cognito.UserPoolEmail email) {
            this.props().email(email);
            return this;
        }

        /**
         * Setting this would explicitly enable or disable SMS role creation.
         * <p>
         * When left unspecified, CDK will determine based on other properties if a role is needed or not.
         * <p>
         * Default: - CDK will determine based on other properties of the user pool if an SMS role should be created or not.
         * <p>
         * @return {@code this}
         * @param enableSmsRole Setting this would explicitly enable or disable SMS role creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSmsRole(final java.lang.Boolean enableSmsRole) {
            this.props().enableSmsRole(enableSmsRole);
            return this;
        }

        /**
         * The user pool feature plan, or tier.
         * <p>
         * This parameter determines the eligibility of the user pool for features like managed login, access-token customization, and threat protection.
         * <p>
         * Default: - FeaturePlan.ESSENTIALS for a newly created user pool; FeaturePlan.LITE otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html</a>
         * @param featurePlan The user pool feature plan, or tier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featurePlan(final software.amazon.awscdk.services.cognito.FeaturePlan featurePlan) {
            this.props().featurePlan(featurePlan);
            return this;
        }

        /**
         * Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes.
         * <p>
         * EMAIL and PHONE are the only available options.
         * <p>
         * Default: - Nothing is kept.
         * <p>
         * @return {@code this}
         * @param keepOriginal Attributes which Cognito will look to handle changes to the value of your users' email address and phone number attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepOriginal(final software.amazon.awscdk.services.cognito.KeepOriginalAttrs keepOriginal) {
            this.props().keepOriginal(keepOriginal);
            return this;
        }

        /**
         * Lambda functions to use for supported Cognito triggers.
         * <p>
         * Default: - No Lambda triggers.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html</a>
         * @param lambdaTriggers Lambda functions to use for supported Cognito triggers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaTriggers(final software.amazon.awscdk.services.cognito.UserPoolTriggers lambdaTriggers) {
            this.props().lambdaTriggers(lambdaTriggers);
            return this;
        }

        /**
         * Configure whether users of this user pool can or are required use MFA to sign in.
         * <p>
         * Default: Mfa.OFF
         * <p>
         * @return {@code this}
         * @param mfa Configure whether users of this user pool can or are required use MFA to sign in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mfa(final software.amazon.awscdk.services.cognito.Mfa mfa) {
            this.props().mfa(mfa);
            return this;
        }

        /**
         * The SMS message template sent during MFA verification.
         * <p>
         * Use '{####}' in the template where Cognito should insert the verification code.
         * <p>
         * Default: 'Your authentication code is {####}.'
         * <p>
         * @return {@code this}
         * @param mfaMessage The SMS message template sent during MFA verification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mfaMessage(final java.lang.String mfaMessage) {
            this.props().mfaMessage(mfaMessage);
            return this;
        }

        /**
         * Configure the MFA types that users can use in this user pool.
         * <p>
         * Ignored if <code>mfa</code> is set to <code>OFF</code>.
         * <p>
         * Default: - { sms: true, otp: false, email: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`.
         * { sms: false, otp: false, email:false }, otherwise
         * <p>
         * @return {@code this}
         * @param mfaSecondFactor Configure the MFA types that users can use in this user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mfaSecondFactor(final software.amazon.awscdk.services.cognito.MfaSecondFactor mfaSecondFactor) {
            this.props().mfaSecondFactor(mfaSecondFactor);
            return this;
        }

        /**
         * The authentication domain that passkey providers must use as a relying party (RP) in their configuration.
         * <p>
         * Under the following conditions, the passkey relying party ID must be the fully-qualified domain name of your custom domain:
         * <p>
         * <ul>
         * <li>The user pool is configured for passkey authentication.</li>
         * <li>The user pool has a custom domain, whether or not it also has a prefix domain.</li>
         * <li>Your application performs authentication with managed login or the classic hosted UI.</li>
         * </ul>
         * <p>
         * Default: - No authentication domain
         * <p>
         * @return {@code this}
         * @param passkeyRelyingPartyId The authentication domain that passkey providers must use as a relying party (RP) in their configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passkeyRelyingPartyId(final java.lang.String passkeyRelyingPartyId) {
            this.props().passkeyRelyingPartyId(passkeyRelyingPartyId);
            return this;
        }

        /**
         * Your user-pool treatment for MFA with a passkey.
         * <p>
         * You can override other MFA options and require passkey MFA, or you can set it as preferred.
         * When passkey MFA is preferred, the hosted UI encourages users to register a passkey at sign-in.
         * <p>
         * Default: - Cognito default setting is PasskeyUserVerification.PREFERRED
         * <p>
         * @return {@code this}
         * @param passkeyUserVerification Your user-pool treatment for MFA with a passkey. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passkeyUserVerification(final software.amazon.awscdk.services.cognito.PasskeyUserVerification passkeyUserVerification) {
            this.props().passkeyUserVerification(passkeyUserVerification);
            return this;
        }

        /**
         * Password policy for this user pool.
         * <p>
         * Default: - see defaults on each property of PasswordPolicy.
         * <p>
         * @return {@code this}
         * @param passwordPolicy Password policy for this user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passwordPolicy(final software.amazon.awscdk.services.cognito.PasswordPolicy passwordPolicy) {
            this.props().passwordPolicy(passwordPolicy);
            return this;
        }

        /**
         * Policy to apply when the user pool is removed from the stack.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy Policy to apply when the user pool is removed from the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Whether self sign-up should be enabled.
         * <p>
         * To configure self sign-up configuration use the <code>userVerification</code> property.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param selfSignUpEnabled Whether self sign-up should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfSignUpEnabled(final java.lang.Boolean selfSignUpEnabled) {
            this.props().selfSignUpEnabled(selfSignUpEnabled);
            return this;
        }

        /**
         * Methods in which a user registers or signs in to a user pool.
         * <p>
         * Allows either username with aliases OR sign in with email, phone, or both.
         * <p>
         * Read the sections on usernames and aliases to learn more -
         * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         * <p>
         * To match with 'Option 1' in the above link, with a verified email, this property should be set to
         * <code>{ username: true, email: true }</code>. To match with 'Option 2' in the above link with both a verified email and phone
         * number, this property should be set to <code>{ email: true, phone: true }</code>.
         * <p>
         * Default: { username: true }
         * <p>
         * @return {@code this}
         * @param signInAliases Methods in which a user registers or signs in to a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signInAliases(final software.amazon.awscdk.services.cognito.SignInAliases signInAliases) {
            this.props().signInAliases(signInAliases);
            return this;
        }

        /**
         * Whether sign-in aliases should be evaluated with case sensitivity.
         * <p>
         * For example, when this option is set to false, users will be able to sign in using either <code>MyUsername</code> or <code>myusername</code>.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param signInCaseSensitive Whether sign-in aliases should be evaluated with case sensitivity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signInCaseSensitive(final java.lang.Boolean signInCaseSensitive) {
            this.props().signInCaseSensitive(signInCaseSensitive);
            return this;
        }

        /**
         * Sign-in policy for this user pool.
         * <p>
         * Default: - see defaults on each property of SignInPolicy.
         * <p>
         * @return {@code this}
         * @param signInPolicy Sign-in policy for this user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signInPolicy(final software.amazon.awscdk.services.cognito.SignInPolicy signInPolicy) {
            this.props().signInPolicy(signInPolicy);
            return this;
        }

        /**
         * The IAM role that Cognito will assume while sending SMS messages.
         * <p>
         * Default: - a new IAM role is created.
         * <p>
         * @return {@code this}
         * @param smsRole The IAM role that Cognito will assume while sending SMS messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsRole(final software.amazon.awscdk.services.iam.IRole smsRole) {
            this.props().smsRole(smsRole);
            return this;
        }

        /**
         * The 'ExternalId' that Cognito service must be using when assuming the <code>smsRole</code>, if the role is restricted with an 'sts:ExternalId' conditional.
         * <p>
         * Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
         * <p>
         * This property will be ignored if <code>smsRole</code> is not specified.
         * <p>
         * Default: - No external id will be configured.
         * <p>
         * @return {@code this}
         * @param smsRoleExternalId The 'ExternalId' that Cognito service must be using when assuming the <code>smsRole</code>, if the role is restricted with an 'sts:ExternalId' conditional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smsRoleExternalId(final java.lang.String smsRoleExternalId) {
            this.props().smsRoleExternalId(smsRoleExternalId);
            return this;
        }

        /**
         * The region to integrate with SNS to send SMS messages.
         * <p>
         * This property will do nothing if SMS configuration is not configured.
         * <p>
         * Default: - The same region as the user pool, with a few exceptions - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html#user-pool-sms-settings-first-time
         * <p>
         * @return {@code this}
         * @param snsRegion The region to integrate with SNS to send SMS messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsRegion(final java.lang.String snsRegion) {
            this.props().snsRegion(snsRegion);
            return this;
        }

        /**
         * The set of attributes that are required for every user in the user pool.
         * <p>
         * Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
         * <p>
         * Default: - All standard attributes are optional and mutable.
         * <p>
         * @return {@code this}
         * @param standardAttributes The set of attributes that are required for every user in the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder standardAttributes(final software.amazon.awscdk.services.cognito.StandardAttributes standardAttributes) {
            this.props().standardAttributes(standardAttributes);
            return this;
        }

        /**
         * The Type of Threat Protection Enabled for Standard Authentication.
         * <p>
         * This feature only functions if your FeaturePlan is set to FeaturePlan.PLUS
         * <p>
         * Default: - StandardThreatProtectionMode.NO_ENFORCEMENT
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-userpool-userpooladdons.html</a>
         * @param standardThreatProtectionMode The Type of Threat Protection Enabled for Standard Authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder standardThreatProtectionMode(final software.amazon.awscdk.services.cognito.StandardThreatProtectionMode standardThreatProtectionMode) {
            this.props().standardThreatProtectionMode(standardThreatProtectionMode);
            return this;
        }

        /**
         * Configuration around admins signing up users into a user pool.
         * <p>
         * Default: - see defaults in UserInvitationConfig.
         * <p>
         * @return {@code this}
         * @param userInvitation Configuration around admins signing up users into a user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userInvitation(final software.amazon.awscdk.services.cognito.UserInvitationConfig userInvitation) {
            this.props().userInvitation(userInvitation);
            return this;
        }

        /**
         * Name of the user pool.
         * <p>
         * Default: - automatically generated name by CloudFormation at deploy time.
         * <p>
         * @return {@code this}
         * @param userPoolName Name of the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolName(final java.lang.String userPoolName) {
            this.props().userPoolName(userPoolName);
            return this;
        }

        /**
         * Configuration around users signing themselves up to the user pool.
         * <p>
         * Enable or disable self sign-up via the <code>selfSignUpEnabled</code> property.
         * <p>
         * Default: - see defaults in UserVerificationConfig.
         * <p>
         * @return {@code this}
         * @param userVerification Configuration around users signing themselves up to the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userVerification(final software.amazon.awscdk.services.cognito.UserVerificationConfig userVerification) {
            this.props().userVerification(userVerification);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPool build() {
            return new software.amazon.awscdk.services.cognito.UserPool(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cognito.UserPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cognito.UserPoolProps.Builder();
            }
            return this.props;
        }
    }
}
