package software.amazon.awscdk.services.cognito.identitypool;

/**
 * Login Provider for identity federation using Apple credentials.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .authenticationProviders(IdentityPoolAuthenticationProviders.builder()
 *                 .amazon(IdentityPoolAmazonLoginProvider.builder()
 *                         .appId("amzn1.application.12312k3j234j13rjiwuenf")
 *                         .build())
 *                 .facebook(IdentityPoolFacebookLoginProvider.builder()
 *                         .appId("1234567890123")
 *                         .build())
 *                 .google(IdentityPoolGoogleLoginProvider.builder()
 *                         .clientId("12345678012.apps.googleusercontent.com")
 *                         .build())
 *                 .apple(IdentityPoolAppleLoginProvider.builder()
 *                         .servicesId("com.myappleapp.auth")
 *                         .build())
 *                 .twitter(IdentityPoolTwitterLoginProvider.builder()
 *                         .consumerKey("my-twitter-id")
 *                         .consumerSecret("my-twitter-secret")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.574Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito_identitypool.IdentityPoolAppleLoginProvider")
@software.amazon.jsii.Jsii.Proxy(IdentityPoolAppleLoginProvider.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdentityPoolAppleLoginProvider extends software.amazon.jsii.JsiiSerializable {

    /**
     * Services ID for Apple identity federation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServicesId();

    /**
     * @return a {@link Builder} of {@link IdentityPoolAppleLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityPoolAppleLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityPoolAppleLoginProvider> {
        java.lang.String servicesId;

        /**
         * Sets the value of {@link IdentityPoolAppleLoginProvider#getServicesId}
         * @param servicesId Services ID for Apple identity federation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder servicesId(java.lang.String servicesId) {
            this.servicesId = servicesId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityPoolAppleLoginProvider}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdentityPoolAppleLoginProvider build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityPoolAppleLoginProvider}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityPoolAppleLoginProvider {
        private final java.lang.String servicesId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.servicesId = software.amazon.jsii.Kernel.get(this, "servicesId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.servicesId = java.util.Objects.requireNonNull(builder.servicesId, "servicesId is required");
        }

        @Override
        public final java.lang.String getServicesId() {
            return this.servicesId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("servicesId", om.valueToTree(this.getServicesId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito_identitypool.IdentityPoolAppleLoginProvider"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityPoolAppleLoginProvider.Jsii$Proxy that = (IdentityPoolAppleLoginProvider.Jsii$Proxy) o;

            return this.servicesId.equals(that.servicesId);
        }

        @Override
        public final int hashCode() {
            int result = this.servicesId.hashCode();
            return result;
        }
    }
}
