package software.amazon.awscdk.services.config;

/**
 * Properties for defining a <code>CfnConformancePack</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * Object templateSsmDocumentDetails;
 * CfnConformancePackProps cfnConformancePackProps = CfnConformancePackProps.builder()
 *         .conformancePackName("conformancePackName")
 *         // the properties below are optional
 *         .conformancePackInputParameters(List.of(ConformancePackInputParameterProperty.builder()
 *                 .parameterName("parameterName")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .deliveryS3Bucket("deliveryS3Bucket")
 *         .deliveryS3KeyPrefix("deliveryS3KeyPrefix")
 *         .templateBody("templateBody")
 *         .templateS3Uri("templateS3Uri")
 *         .templateSsmDocumentDetails(templateSsmDocumentDetails)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:11.646Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConformancePackProps")
@software.amazon.jsii.Jsii.Proxy(CfnConformancePackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConformancePackProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the conformance pack you want to create.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConformancePackName();

    /**
     * A list of ConformancePackInputParameter objects.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackinputparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackinputparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConformancePackInputParameters() {
        return null;
    }

    /**
     * The name of the Amazon S3 bucket where AWS Config stores conformance pack templates.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3bucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryS3Bucket() {
        return null;
    }

    /**
     * The prefix for the Amazon S3 bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3keyprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryS3KeyPrefix() {
        return null;
    }

    /**
     * A string containing full conformance pack template body.
     * <p>
     * Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
     * <p>
     * <blockquote>
     * <p>
     * You can only use a YAML template with two resource types: config rule ( <code>AWS::Config::ConfigRule</code> ) and a remediation action ( <code>AWS::Config::RemediationConfiguration</code> ).
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatebody</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateBody() {
        return null;
    }

    /**
     * Location of file containing the template body (s3://bucketname/prefix).
     * <p>
     * The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket.
     * <p>
     * <blockquote>
     * <p>
     * You must have access to read Amazon S3 bucket.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templates3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templates3uri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateS3Uri() {
        return null;
    }

    /**
     * An object that contains the name or Amazon Resource Name (ARN) of the AWS Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatessmdocumentdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatessmdocumentdetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTemplateSsmDocumentDetails() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConformancePackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConformancePackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConformancePackProps> {
        java.lang.String conformancePackName;
        java.lang.Object conformancePackInputParameters;
        java.lang.String deliveryS3Bucket;
        java.lang.String deliveryS3KeyPrefix;
        java.lang.String templateBody;
        java.lang.String templateS3Uri;
        java.lang.Object templateSsmDocumentDetails;

        /**
         * Sets the value of {@link CfnConformancePackProps#getConformancePackName}
         * @param conformancePackName Name of the conformance pack you want to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conformancePackName(java.lang.String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConformancePackProps#getConformancePackInputParameters}
         * @param conformancePackInputParameters A list of ConformancePackInputParameter objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conformancePackInputParameters(software.amazon.awscdk.IResolvable conformancePackInputParameters) {
            this.conformancePackInputParameters = conformancePackInputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnConformancePackProps#getConformancePackInputParameters}
         * @param conformancePackInputParameters A list of ConformancePackInputParameter objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conformancePackInputParameters(java.util.List<? extends java.lang.Object> conformancePackInputParameters) {
            this.conformancePackInputParameters = conformancePackInputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnConformancePackProps#getDeliveryS3Bucket}
         * @param deliveryS3Bucket The name of the Amazon S3 bucket where AWS Config stores conformance pack templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryS3Bucket(java.lang.String deliveryS3Bucket) {
            this.deliveryS3Bucket = deliveryS3Bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnConformancePackProps#getDeliveryS3KeyPrefix}
         * @param deliveryS3KeyPrefix The prefix for the Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryS3KeyPrefix(java.lang.String deliveryS3KeyPrefix) {
            this.deliveryS3KeyPrefix = deliveryS3KeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnConformancePackProps#getTemplateBody}
         * @param templateBody A string containing full conformance pack template body.
         *                     Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     You can only use a YAML template with two resource types: config rule ( <code>AWS::Config::ConfigRule</code> ) and a remediation action ( <code>AWS::Config::RemediationConfiguration</code> ).
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateBody(java.lang.String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnConformancePackProps#getTemplateS3Uri}
         * @param templateS3Uri Location of file containing the template body (s3://bucketname/prefix).
         *                      The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket.
         *                      <p>
         *                      <blockquote>
         *                      <p>
         *                      You must have access to read Amazon S3 bucket.
         *                      <p>
         *                      </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateS3Uri(java.lang.String templateS3Uri) {
            this.templateS3Uri = templateS3Uri;
            return this;
        }

        /**
         * Sets the value of {@link CfnConformancePackProps#getTemplateSsmDocumentDetails}
         * @param templateSsmDocumentDetails An object that contains the name or Amazon Resource Name (ARN) of the AWS Systems Manager document (SSM document) and the version of the SSM document that is used to create a conformance pack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSsmDocumentDetails(java.lang.Object templateSsmDocumentDetails) {
            this.templateSsmDocumentDetails = templateSsmDocumentDetails;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConformancePackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConformancePackProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConformancePackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConformancePackProps {
        private final java.lang.String conformancePackName;
        private final java.lang.Object conformancePackInputParameters;
        private final java.lang.String deliveryS3Bucket;
        private final java.lang.String deliveryS3KeyPrefix;
        private final java.lang.String templateBody;
        private final java.lang.String templateS3Uri;
        private final java.lang.Object templateSsmDocumentDetails;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.conformancePackName = software.amazon.jsii.Kernel.get(this, "conformancePackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.conformancePackInputParameters = software.amazon.jsii.Kernel.get(this, "conformancePackInputParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deliveryS3Bucket = software.amazon.jsii.Kernel.get(this, "deliveryS3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryS3KeyPrefix = software.amazon.jsii.Kernel.get(this, "deliveryS3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateBody = software.amazon.jsii.Kernel.get(this, "templateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateS3Uri = software.amazon.jsii.Kernel.get(this, "templateS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templateSsmDocumentDetails = software.amazon.jsii.Kernel.get(this, "templateSsmDocumentDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.conformancePackName = java.util.Objects.requireNonNull(builder.conformancePackName, "conformancePackName is required");
            this.conformancePackInputParameters = builder.conformancePackInputParameters;
            this.deliveryS3Bucket = builder.deliveryS3Bucket;
            this.deliveryS3KeyPrefix = builder.deliveryS3KeyPrefix;
            this.templateBody = builder.templateBody;
            this.templateS3Uri = builder.templateS3Uri;
            this.templateSsmDocumentDetails = builder.templateSsmDocumentDetails;
        }

        @Override
        public final java.lang.String getConformancePackName() {
            return this.conformancePackName;
        }

        @Override
        public final java.lang.Object getConformancePackInputParameters() {
            return this.conformancePackInputParameters;
        }

        @Override
        public final java.lang.String getDeliveryS3Bucket() {
            return this.deliveryS3Bucket;
        }

        @Override
        public final java.lang.String getDeliveryS3KeyPrefix() {
            return this.deliveryS3KeyPrefix;
        }

        @Override
        public final java.lang.String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final java.lang.String getTemplateS3Uri() {
            return this.templateS3Uri;
        }

        @Override
        public final java.lang.Object getTemplateSsmDocumentDetails() {
            return this.templateSsmDocumentDetails;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("conformancePackName", om.valueToTree(this.getConformancePackName()));
            if (this.getConformancePackInputParameters() != null) {
                data.set("conformancePackInputParameters", om.valueToTree(this.getConformancePackInputParameters()));
            }
            if (this.getDeliveryS3Bucket() != null) {
                data.set("deliveryS3Bucket", om.valueToTree(this.getDeliveryS3Bucket()));
            }
            if (this.getDeliveryS3KeyPrefix() != null) {
                data.set("deliveryS3KeyPrefix", om.valueToTree(this.getDeliveryS3KeyPrefix()));
            }
            if (this.getTemplateBody() != null) {
                data.set("templateBody", om.valueToTree(this.getTemplateBody()));
            }
            if (this.getTemplateS3Uri() != null) {
                data.set("templateS3Uri", om.valueToTree(this.getTemplateS3Uri()));
            }
            if (this.getTemplateSsmDocumentDetails() != null) {
                data.set("templateSsmDocumentDetails", om.valueToTree(this.getTemplateSsmDocumentDetails()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConformancePackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConformancePackProps.Jsii$Proxy that = (CfnConformancePackProps.Jsii$Proxy) o;

            if (!conformancePackName.equals(that.conformancePackName)) return false;
            if (this.conformancePackInputParameters != null ? !this.conformancePackInputParameters.equals(that.conformancePackInputParameters) : that.conformancePackInputParameters != null) return false;
            if (this.deliveryS3Bucket != null ? !this.deliveryS3Bucket.equals(that.deliveryS3Bucket) : that.deliveryS3Bucket != null) return false;
            if (this.deliveryS3KeyPrefix != null ? !this.deliveryS3KeyPrefix.equals(that.deliveryS3KeyPrefix) : that.deliveryS3KeyPrefix != null) return false;
            if (this.templateBody != null ? !this.templateBody.equals(that.templateBody) : that.templateBody != null) return false;
            if (this.templateS3Uri != null ? !this.templateS3Uri.equals(that.templateS3Uri) : that.templateS3Uri != null) return false;
            return this.templateSsmDocumentDetails != null ? this.templateSsmDocumentDetails.equals(that.templateSsmDocumentDetails) : that.templateSsmDocumentDetails == null;
        }

        @Override
        public final int hashCode() {
            int result = this.conformancePackName.hashCode();
            result = 31 * result + (this.conformancePackInputParameters != null ? this.conformancePackInputParameters.hashCode() : 0);
            result = 31 * result + (this.deliveryS3Bucket != null ? this.deliveryS3Bucket.hashCode() : 0);
            result = 31 * result + (this.deliveryS3KeyPrefix != null ? this.deliveryS3KeyPrefix.hashCode() : 0);
            result = 31 * result + (this.templateBody != null ? this.templateBody.hashCode() : 0);
            result = 31 * result + (this.templateS3Uri != null ? this.templateS3Uri.hashCode() : 0);
            result = 31 * result + (this.templateSsmDocumentDetails != null ? this.templateSsmDocumentDetails.hashCode() : 0);
            return result;
        }
    }
}
