package software.amazon.awscdk.services.deadline;

/**
 * Properties for defining a <code>CfnFleet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.deadline.*;
 * CfnFleetProps cfnFleetProps = CfnFleetProps.builder()
 *         .configuration(FleetConfigurationProperty.builder()
 *                 .customerManaged(CustomerManagedFleetConfigurationProperty.builder()
 *                         .mode("mode")
 *                         .workerCapabilities(CustomerManagedWorkerCapabilitiesProperty.builder()
 *                                 .cpuArchitectureType("cpuArchitectureType")
 *                                 .memoryMiB(MemoryMiBRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .osFamily("osFamily")
 *                                 .vCpuCount(VCpuCountRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .acceleratorCount(AcceleratorCountRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
 *                                         .min(123)
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build()))
 *                                 .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
 *                                         .name("name")
 *                                         .values(List.of("values"))
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .storageProfileId("storageProfileId")
 *                         .tagPropagationMode("tagPropagationMode")
 *                         .build())
 *                 .serviceManagedEc2(ServiceManagedEc2FleetConfigurationProperty.builder()
 *                         .instanceCapabilities(ServiceManagedEc2InstanceCapabilitiesProperty.builder()
 *                                 .cpuArchitectureType("cpuArchitectureType")
 *                                 .memoryMiB(MemoryMiBRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .osFamily("osFamily")
 *                                 .vCpuCount(VCpuCountRangeProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .acceleratorCapabilities(AcceleratorCapabilitiesProperty.builder()
 *                                         .selections(List.of(AcceleratorSelectionProperty.builder()
 *                                                 .name("name")
 *                                                 // the properties below are optional
 *                                                 .runtime("runtime")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .count(AcceleratorCountRangeProperty.builder()
 *                                                 .min(123)
 *                                                 // the properties below are optional
 *                                                 .max(123)
 *                                                 .build())
 *                                         .build())
 *                                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
 *                                 .customAmounts(List.of(FleetAmountCapabilityProperty.builder()
 *                                         .min(123)
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build()))
 *                                 .customAttributes(List.of(FleetAttributeCapabilityProperty.builder()
 *                                         .name("name")
 *                                         .values(List.of("values"))
 *                                         .build()))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .rootEbsVolume(Ec2EbsVolumeProperty.builder()
 *                                         .iops(123)
 *                                         .sizeGiB(123)
 *                                         .throughputMiB(123)
 *                                         .build())
 *                                 .build())
 *                         .instanceMarketOptions(ServiceManagedEc2InstanceMarketOptionsProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         // the properties below are optional
 *                         .storageProfileId("storageProfileId")
 *                         .build())
 *                 .build())
 *         .displayName("displayName")
 *         .farmId("farmId")
 *         .maxWorkerCount(123)
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .description("description")
 *         .hostConfiguration(HostConfigurationProperty.builder()
 *                 .scriptBody("scriptBody")
 *                 // the properties below are optional
 *                 .scriptTimeoutSeconds(123)
 *                 .build())
 *         .minWorkerCount(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:12.193Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_deadline.CfnFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration details for the fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * The display name of the fleet summary to update.
     * <p>
     * <blockquote>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

    /**
     * The farm ID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-farmid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-farmid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFarmId();

    /**
     * The maximum number of workers specified in the fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-maxworkercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-maxworkercount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxWorkerCount();

    /**
     * The IAM role that workers in the fleet use when processing jobs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * A description that helps identify what the fleet is used for.
     * <p>
     * <blockquote>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
     * <p>
     * </blockquote>
     * <p>
     * Default: - ""
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Provides a script that runs as a worker is starting up that you can use to provide additional configuration for workers in your fleet.
     * <p>
     * To remove a script from a fleet, use the <a href="https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html">UpdateFleet</a> operation with the <code>hostConfiguration</code> <code>scriptBody</code> parameter set to an empty string ("").
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-hostconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-hostconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHostConfiguration() {
        return null;
    }

    /**
     * The minimum number of workers in the fleet.
     * <p>
     * Default: - 0
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-minworkercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-minworkercount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinWorkerCount() {
        return null;
    }

    /**
     * The tags to add to your fleet.
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-deadline-fleet.html#cfn-deadline-fleet-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFleetProps> {
        java.lang.Object configuration;
        java.lang.String displayName;
        java.lang.String farmId;
        java.lang.Number maxWorkerCount;
        java.lang.String roleArn;
        java.lang.String description;
        java.lang.Object hostConfiguration;
        java.lang.Number minWorkerCount;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFleetProps#getConfiguration}
         * @param configuration The configuration details for the fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getConfiguration}
         * @param configuration The configuration details for the fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.deadline.CfnFleet.FleetConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDisplayName}
         * @param displayName The display name of the fleet summary to update. This parameter is required.
         *                    <blockquote>
         *                    <p>
         *                    This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFarmId}
         * @param farmId The farm ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder farmId(java.lang.String farmId) {
            this.farmId = farmId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMaxWorkerCount}
         * @param maxWorkerCount The maximum number of workers specified in the fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWorkerCount(java.lang.Number maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getRoleArn}
         * @param roleArn The IAM role that workers in the fleet use when processing jobs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDescription}
         * @param description A description that helps identify what the fleet is used for.
         *                    <blockquote>
         *                    <p>
         *                    This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getHostConfiguration}
         * @param hostConfiguration Provides a script that runs as a worker is starting up that you can use to provide additional configuration for workers in your fleet.
         *                          To remove a script from a fleet, use the <a href="https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html">UpdateFleet</a> operation with the <code>hostConfiguration</code> <code>scriptBody</code> parameter set to an empty string ("").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostConfiguration(software.amazon.awscdk.IResolvable hostConfiguration) {
            this.hostConfiguration = hostConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getHostConfiguration}
         * @param hostConfiguration Provides a script that runs as a worker is starting up that you can use to provide additional configuration for workers in your fleet.
         *                          To remove a script from a fleet, use the <a href="https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html">UpdateFleet</a> operation with the <code>hostConfiguration</code> <code>scriptBody</code> parameter set to an empty string ("").
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostConfiguration(software.amazon.awscdk.services.deadline.CfnFleet.HostConfigurationProperty hostConfiguration) {
            this.hostConfiguration = hostConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMinWorkerCount}
         * @param minWorkerCount The minimum number of workers in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minWorkerCount(java.lang.Number minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getTags}
         * @param tags The tags to add to your fleet.
         *             Each tag consists of a tag key and a tag value. Tag keys and values are both required, but tag values can be empty strings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFleetProps {
        private final java.lang.Object configuration;
        private final java.lang.String displayName;
        private final java.lang.String farmId;
        private final java.lang.Number maxWorkerCount;
        private final java.lang.String roleArn;
        private final java.lang.String description;
        private final java.lang.Object hostConfiguration;
        private final java.lang.Number minWorkerCount;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.farmId = software.amazon.jsii.Kernel.get(this, "farmId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxWorkerCount = software.amazon.jsii.Kernel.get(this, "maxWorkerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostConfiguration = software.amazon.jsii.Kernel.get(this, "hostConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.minWorkerCount = software.amazon.jsii.Kernel.get(this, "minWorkerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
            this.farmId = java.util.Objects.requireNonNull(builder.farmId, "farmId is required");
            this.maxWorkerCount = java.util.Objects.requireNonNull(builder.maxWorkerCount, "maxWorkerCount is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.description = builder.description;
            this.hostConfiguration = builder.hostConfiguration;
            this.minWorkerCount = builder.minWorkerCount;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getFarmId() {
            return this.farmId;
        }

        @Override
        public final java.lang.Number getMaxWorkerCount() {
            return this.maxWorkerCount;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getHostConfiguration() {
            return this.hostConfiguration;
        }

        @Override
        public final java.lang.Number getMinWorkerCount() {
            return this.minWorkerCount;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("displayName", om.valueToTree(this.getDisplayName()));
            data.set("farmId", om.valueToTree(this.getFarmId()));
            data.set("maxWorkerCount", om.valueToTree(this.getMaxWorkerCount()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHostConfiguration() != null) {
                data.set("hostConfiguration", om.valueToTree(this.getHostConfiguration()));
            }
            if (this.getMinWorkerCount() != null) {
                data.set("minWorkerCount", om.valueToTree(this.getMinWorkerCount()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_deadline.CfnFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFleetProps.Jsii$Proxy that = (CfnFleetProps.Jsii$Proxy) o;

            if (!configuration.equals(that.configuration)) return false;
            if (!displayName.equals(that.displayName)) return false;
            if (!farmId.equals(that.farmId)) return false;
            if (!maxWorkerCount.equals(that.maxWorkerCount)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.hostConfiguration != null ? !this.hostConfiguration.equals(that.hostConfiguration) : that.hostConfiguration != null) return false;
            if (this.minWorkerCount != null ? !this.minWorkerCount.equals(that.minWorkerCount) : that.minWorkerCount != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configuration.hashCode();
            result = 31 * result + (this.displayName.hashCode());
            result = 31 * result + (this.farmId.hashCode());
            result = 31 * result + (this.maxWorkerCount.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.hostConfiguration != null ? this.hostConfiguration.hashCode() : 0);
            result = 31 * result + (this.minWorkerCount != null ? this.minWorkerCount.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
