package software.amazon.awscdk.services.docdb;

/**
 * Properties that describe an existing instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdb.*;
 * DatabaseInstanceAttributes databaseInstanceAttributes = DatabaseInstanceAttributes.builder()
 *         .instanceEndpointAddress("instanceEndpointAddress")
 *         .instanceIdentifier("instanceIdentifier")
 *         .port(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:12.437Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DatabaseInstanceAttributes")
@software.amazon.jsii.Jsii.Proxy(DatabaseInstanceAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseInstanceAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The endpoint address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceEndpointAddress();

    /**
     * The instance identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceIdentifier();

    /**
     * The database port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPort();

    /**
     * @return a {@link Builder} of {@link DatabaseInstanceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseInstanceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseInstanceAttributes> {
        java.lang.String instanceEndpointAddress;
        java.lang.String instanceIdentifier;
        java.lang.Number port;

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getInstanceEndpointAddress}
         * @param instanceEndpointAddress The endpoint address. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceEndpointAddress(java.lang.String instanceEndpointAddress) {
            this.instanceEndpointAddress = instanceEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getInstanceIdentifier}
         * @param instanceIdentifier The instance identifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifier(java.lang.String instanceIdentifier) {
            this.instanceIdentifier = instanceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceAttributes#getPort}
         * @param port The database port. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseInstanceAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseInstanceAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseInstanceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInstanceAttributes {
        private final java.lang.String instanceEndpointAddress;
        private final java.lang.String instanceIdentifier;
        private final java.lang.Number port;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceEndpointAddress = software.amazon.jsii.Kernel.get(this, "instanceEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceIdentifier = software.amazon.jsii.Kernel.get(this, "instanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceEndpointAddress = java.util.Objects.requireNonNull(builder.instanceEndpointAddress, "instanceEndpointAddress is required");
            this.instanceIdentifier = java.util.Objects.requireNonNull(builder.instanceIdentifier, "instanceIdentifier is required");
            this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
        }

        @Override
        public final java.lang.String getInstanceEndpointAddress() {
            return this.instanceEndpointAddress;
        }

        @Override
        public final java.lang.String getInstanceIdentifier() {
            return this.instanceIdentifier;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceEndpointAddress", om.valueToTree(this.getInstanceEndpointAddress()));
            data.set("instanceIdentifier", om.valueToTree(this.getInstanceIdentifier()));
            data.set("port", om.valueToTree(this.getPort()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.DatabaseInstanceAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseInstanceAttributes.Jsii$Proxy that = (DatabaseInstanceAttributes.Jsii$Proxy) o;

            if (!instanceEndpointAddress.equals(that.instanceEndpointAddress)) return false;
            if (!instanceIdentifier.equals(that.instanceIdentifier)) return false;
            return this.port.equals(that.port);
        }

        @Override
        public final int hashCode() {
            int result = this.instanceEndpointAddress.hashCode();
            result = 31 * result + (this.instanceIdentifier.hashCode());
            result = 31 * result + (this.port.hashCode());
            return result;
        }
    }
}
