package software.amazon.awscdk.services.docdb;

/**
 * Construction properties for a DatabaseInstanceNew.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.docdb.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.rds.*;
 * CaCertificate caCertificate;
 * DatabaseCluster databaseCluster;
 * InstanceType instanceType;
 * DatabaseInstanceProps databaseInstanceProps = DatabaseInstanceProps.builder()
 *         .cluster(databaseCluster)
 *         .instanceType(instanceType)
 *         // the properties below are optional
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZone("availabilityZone")
 *         .caCertificate(caCertificate)
 *         .dbInstanceName("dbInstanceName")
 *         .enablePerformanceInsights(false)
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:12.437Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DatabaseInstanceProps")
@software.amazon.jsii.Jsii.Proxy(DatabaseInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DocumentDB database cluster the instance should launch into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.IDatabaseCluster getCluster();

    /**
     * The name of the compute and memory capacity classes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * The name of the Availability Zone where the DB instance will be located.
     * <p>
     * Default: - no preference
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The identifier of the CA certificate for this DB instance.
     * <p>
     * Specifying or updating this property triggers a reboot.
     * <p>
     * Default: - DocumentDB will choose a certificate authority
     * <p>
     * @see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html">https://docs.aws.amazon.com/documentdb/latest/developerguide/ca_cert_rotation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CaCertificate getCaCertificate() {
        return null;
    }

    /**
     * A name for the DB instance.
     * <p>
     * If you specify a name, AWS CloudFormation
     * converts it to lowercase.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceName() {
        return null;
    }

    /**
     * A value that indicates whether to enable Performance Insights for the DB Instance.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnablePerformanceInsights() {
        return null;
    }

    /**
     * The weekly time range (in UTC) during which system maintenance can occur.
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * Constraint: Minimum 30-minute window
     * <p>
     * Default: - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region, occurring on a random day of the week. To see
     * the time blocks available, see https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-maintain.html#maintenance-window
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
     * <p>
     * Default: RemovalPolicy.Retain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseInstanceProps> {
        software.amazon.awscdk.services.docdb.IDatabaseCluster cluster;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        java.lang.Boolean autoMinorVersionUpgrade;
        java.lang.String availabilityZone;
        software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        java.lang.String dbInstanceName;
        java.lang.Boolean enablePerformanceInsights;
        java.lang.String preferredMaintenanceWindow;
        software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Sets the value of {@link DatabaseInstanceProps#getCluster}
         * @param cluster The DocumentDB database cluster the instance should launch into. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.docdb.IDatabaseCluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getInstanceType}
         * @param instanceType The name of the compute and memory capacity classes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB instance during the maintenance window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getAvailabilityZone}
         * @param availabilityZone The name of the Availability Zone where the DB instance will be located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getCaCertificate}
         * @param caCertificate The identifier of the CA certificate for this DB instance.
         *                      Specifying or updating this property triggers a reboot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificate(software.amazon.awscdk.services.rds.CaCertificate caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getDbInstanceName}
         * @param dbInstanceName A name for the DB instance.
         *                       If you specify a name, AWS CloudFormation
         *                       converts it to lowercase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceName(java.lang.String dbInstanceName) {
            this.dbInstanceName = dbInstanceName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getEnablePerformanceInsights}
         * @param enablePerformanceInsights A value that indicates whether to enable Performance Insights for the DB Instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceInsights(java.lang.Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can occur.
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   Constraint: Minimum 30-minute window
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseInstanceProps#getRemovalPolicy}
         * @param removalPolicy The CloudFormation policy to apply when the instance is removed from the stack or replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseInstanceProps {
        private final software.amazon.awscdk.services.docdb.IDatabaseCluster cluster;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.Boolean autoMinorVersionUpgrade;
        private final java.lang.String availabilityZone;
        private final software.amazon.awscdk.services.rds.CaCertificate caCertificate;
        private final java.lang.String dbInstanceName;
        private final java.lang.Boolean enablePerformanceInsights;
        private final java.lang.String preferredMaintenanceWindow;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.IDatabaseCluster.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.caCertificate = software.amazon.jsii.Kernel.get(this, "caCertificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CaCertificate.class));
            this.dbInstanceName = software.amazon.jsii.Kernel.get(this, "dbInstanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enablePerformanceInsights = software.amazon.jsii.Kernel.get(this, "enablePerformanceInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.availabilityZone = builder.availabilityZone;
            this.caCertificate = builder.caCertificate;
            this.dbInstanceName = builder.dbInstanceName;
            this.enablePerformanceInsights = builder.enablePerformanceInsights;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.removalPolicy = builder.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.docdb.IDatabaseCluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final software.amazon.awscdk.services.rds.CaCertificate getCaCertificate() {
            return this.caCertificate;
        }

        @Override
        public final java.lang.String getDbInstanceName() {
            return this.dbInstanceName;
        }

        @Override
        public final java.lang.Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getCaCertificate() != null) {
                data.set("caCertificate", om.valueToTree(this.getCaCertificate()));
            }
            if (this.getDbInstanceName() != null) {
                data.set("dbInstanceName", om.valueToTree(this.getDbInstanceName()));
            }
            if (this.getEnablePerformanceInsights() != null) {
                data.set("enablePerformanceInsights", om.valueToTree(this.getEnablePerformanceInsights()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.DatabaseInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseInstanceProps.Jsii$Proxy that = (DatabaseInstanceProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.caCertificate != null ? !this.caCertificate.equals(that.caCertificate) : that.caCertificate != null) return false;
            if (this.dbInstanceName != null ? !this.dbInstanceName.equals(that.dbInstanceName) : that.dbInstanceName != null) return false;
            if (this.enablePerformanceInsights != null ? !this.enablePerformanceInsights.equals(that.enablePerformanceInsights) : that.enablePerformanceInsights != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            return this.removalPolicy != null ? this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.caCertificate != null ? this.caCertificate.hashCode() : 0);
            result = 31 * result + (this.dbInstanceName != null ? this.dbInstanceName.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceInsights != null ? this.enablePerformanceInsights.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            return result;
        }
    }
}
