package software.amazon.awscdk.services.dynamodb;

/**
 * Properties used to configure maximum throughput for an on-demand table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TableV2 table = TableV2.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .billing(Billing.onDemand(MaxThroughputProps.builder()
 *                 .maxReadRequestUnits(100)
 *                 .maxWriteRequestUnits(115)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:12.546Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.MaxThroughputProps")
@software.amazon.jsii.Jsii.Proxy(MaxThroughputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MaxThroughputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The max read request units.
     * <p>
     * Default: - if table mode is on-demand and this property is undefined,
     * no maximum throughput limit will be put in place for read requests.
     * This property is only applicable for tables using on-demand mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReadRequestUnits() {
        return null;
    }

    /**
     * The max write request units.
     * <p>
     * Default: - if table mode is on-demand and this property is undefined,
     * no maximum throughput limit will be put in place for write requests.
     * This property is only applicable for tables using on-demand mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxWriteRequestUnits() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MaxThroughputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MaxThroughputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MaxThroughputProps> {
        java.lang.Number maxReadRequestUnits;
        java.lang.Number maxWriteRequestUnits;

        /**
         * Sets the value of {@link MaxThroughputProps#getMaxReadRequestUnits}
         * @param maxReadRequestUnits The max read request units.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReadRequestUnits(java.lang.Number maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
            return this;
        }

        /**
         * Sets the value of {@link MaxThroughputProps#getMaxWriteRequestUnits}
         * @param maxWriteRequestUnits The max write request units.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWriteRequestUnits(java.lang.Number maxWriteRequestUnits) {
            this.maxWriteRequestUnits = maxWriteRequestUnits;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MaxThroughputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MaxThroughputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MaxThroughputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaxThroughputProps {
        private final java.lang.Number maxReadRequestUnits;
        private final java.lang.Number maxWriteRequestUnits;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxReadRequestUnits = software.amazon.jsii.Kernel.get(this, "maxReadRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxWriteRequestUnits = software.amazon.jsii.Kernel.get(this, "maxWriteRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxReadRequestUnits = builder.maxReadRequestUnits;
            this.maxWriteRequestUnits = builder.maxWriteRequestUnits;
        }

        @Override
        public final java.lang.Number getMaxReadRequestUnits() {
            return this.maxReadRequestUnits;
        }

        @Override
        public final java.lang.Number getMaxWriteRequestUnits() {
            return this.maxWriteRequestUnits;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxReadRequestUnits() != null) {
                data.set("maxReadRequestUnits", om.valueToTree(this.getMaxReadRequestUnits()));
            }
            if (this.getMaxWriteRequestUnits() != null) {
                data.set("maxWriteRequestUnits", om.valueToTree(this.getMaxWriteRequestUnits()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.MaxThroughputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MaxThroughputProps.Jsii$Proxy that = (MaxThroughputProps.Jsii$Proxy) o;

            if (this.maxReadRequestUnits != null ? !this.maxReadRequestUnits.equals(that.maxReadRequestUnits) : that.maxReadRequestUnits != null) return false;
            return this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.equals(that.maxWriteRequestUnits) : that.maxWriteRequestUnits == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxReadRequestUnits != null ? this.maxReadRequestUnits.hashCode() : 0;
            result = 31 * result + (this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.hashCode() : 0);
            return result;
        }
    }
}
