package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnSubnet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object privateDnsNameOptionsOnLaunch;
 * CfnSubnetProps cfnSubnetProps = CfnSubnetProps.builder()
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .assignIpv6AddressOnCreation(false)
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .cidrBlock("cidrBlock")
 *         .enableDns64(false)
 *         .enableLniAtDeviceIndex(123)
 *         .ipv4IpamPoolId("ipv4IpamPoolId")
 *         .ipv4NetmaskLength(123)
 *         .ipv6CidrBlock("ipv6CidrBlock")
 *         .ipv6IpamPoolId("ipv6IpamPoolId")
 *         .ipv6Native(false)
 *         .ipv6NetmaskLength(123)
 *         .mapPublicIpOnLaunch(false)
 *         .outpostArn("outpostArn")
 *         .privateDnsNameOptionsOnLaunch(privateDnsNameOptionsOnLaunch)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.024Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnSubnetProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubnetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubnetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the VPC the subnet is in.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is <code>false</code> .
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify an IPv6 CIDR block.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssignIpv6AddressOnCreation() {
        return null;
    }

    /**
     * The Availability Zone of the subnet.
     * <p>
     * If you update this property, you must also update the <code>CidrBlock</code> property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The AZ ID of the subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzoneid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return null;
    }

    /**
     * The IPv4 CIDR block assigned to the subnet.
     * <p>
     * If you update this property, we create a new subnet, and then delete the existing one.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrBlock() {
        return null;
    }

    /**
     * Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
     * <p>
     * <blockquote>
     * <p>
     * You must first configure a NAT gateway in a public subnet (separate from the subnet containing the IPv6-only workloads). For example, the subnet containing the NAT gateway should have a <code>0.0.0.0/0</code> route pointing to the internet gateway. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough">Configure DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-enabledns64">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-enabledns64</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDns64() {
        return null;
    }

    /**
     * Indicates the device position for local network interfaces in this subnet.
     * <p>
     * For example, <code>1</code> indicates local network interfaces in this subnet are the secondary network interface (eth1).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-enablelniatdeviceindex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-enablelniatdeviceindex</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEnableLniAtDeviceIndex() {
        return null;
    }

    /**
     * An IPv4 IPAM pool ID for the subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv4ipampoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv4ipampoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv4IpamPoolId() {
        return null;
    }

    /**
     * An IPv4 netmask length for the subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv4netmasklength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv4netmasklength</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv4NetmaskLength() {
        return null;
    }

    /**
     * The IPv6 CIDR block.
     * <p>
     * If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify an IPv6 CIDR block.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6CidrBlock() {
        return null;
    }

    /**
     * An IPv6 IPAM pool ID for the subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6ipampoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6ipampoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv6IpamPoolId() {
        return null;
    }

    /**
     * Indicates whether this is an IPv6 only subnet.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6native">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6native</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Native() {
        return null;
    }

    /**
     * An IPv6 netmask length for the subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6netmasklength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6netmasklength</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6NetmaskLength() {
        return null;
    }

    /**
     * Indicates whether instances launched in this subnet receive a public IPv4 address. The default value is <code>false</code> .
     * <p>
     * AWS charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <em>Public IPv4 Address</em> tab on the <a href="https://docs.aws.amazon.com/vpc/pricing/">VPC pricing page</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMapPublicIpOnLaunch() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-outpostarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-outpostarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutpostArn() {
        return null;
    }

    /**
     * The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
     * <p>
     * Available options:
     * <p>
     * <ul>
     * <li>EnableResourceNameDnsAAAARecord (true | false)</li>
     * <li>EnableResourceNameDnsARecord (true | false)</li>
     * <li>HostnameType (ip-name | resource-name)</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-privatednsnameoptionsonlaunch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-privatednsnameoptionsonlaunch</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateDnsNameOptionsOnLaunch() {
        return null;
    }

    /**
     * Any tags assigned to the subnet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubnetProps> {
        java.lang.String vpcId;
        java.lang.Object assignIpv6AddressOnCreation;
        java.lang.String availabilityZone;
        java.lang.String availabilityZoneId;
        java.lang.String cidrBlock;
        java.lang.Object enableDns64;
        java.lang.Number enableLniAtDeviceIndex;
        java.lang.String ipv4IpamPoolId;
        java.lang.Number ipv4NetmaskLength;
        java.lang.String ipv6CidrBlock;
        java.lang.String ipv6IpamPoolId;
        java.lang.Object ipv6Native;
        java.lang.Number ipv6NetmaskLength;
        java.lang.Object mapPublicIpOnLaunch;
        java.lang.String outpostArn;
        java.lang.Object privateDnsNameOptionsOnLaunch;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSubnetProps#getVpcId}
         * @param vpcId The ID of the VPC the subnet is in. This parameter is required.
         *              If you update this property, you must also update the <code>CidrBlock</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAssignIpv6AddressOnCreation}
         * @param assignIpv6AddressOnCreation Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is <code>false</code> .
         *                                    If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify an IPv6 CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignIpv6AddressOnCreation(java.lang.Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAssignIpv6AddressOnCreation}
         * @param assignIpv6AddressOnCreation Indicates whether a network interface created in this subnet receives an IPv6 address. The default value is <code>false</code> .
         *                                    If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify an IPv6 CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignIpv6AddressOnCreation(software.amazon.awscdk.IResolvable assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone of the subnet.
         *                         If you update this property, you must also update the <code>CidrBlock</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getAvailabilityZoneId}
         * @param availabilityZoneId The AZ ID of the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(java.lang.String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getCidrBlock}
         * @param cidrBlock The IPv4 CIDR block assigned to the subnet.
         *                  If you update this property, we create a new subnet, and then delete the existing one.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getEnableDns64}
         * @param enableDns64 Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         *                    <blockquote>
         *                    <p>
         *                    You must first configure a NAT gateway in a public subnet (separate from the subnet containing the IPv6-only workloads). For example, the subnet containing the NAT gateway should have a <code>0.0.0.0/0</code> route pointing to the internet gateway. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough">Configure DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDns64(java.lang.Boolean enableDns64) {
            this.enableDns64 = enableDns64;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getEnableDns64}
         * @param enableDns64 Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses for IPv4-only destinations.
         *                    <blockquote>
         *                    <p>
         *                    You must first configure a NAT gateway in a public subnet (separate from the subnet containing the IPv6-only workloads). For example, the subnet containing the NAT gateway should have a <code>0.0.0.0/0</code> route pointing to the internet gateway. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough">Configure DNS64 and NAT64</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDns64(software.amazon.awscdk.IResolvable enableDns64) {
            this.enableDns64 = enableDns64;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getEnableLniAtDeviceIndex}
         * @param enableLniAtDeviceIndex Indicates the device position for local network interfaces in this subnet.
         *                               For example, <code>1</code> indicates local network interfaces in this subnet are the secondary network interface (eth1).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLniAtDeviceIndex(java.lang.Number enableLniAtDeviceIndex) {
            this.enableLniAtDeviceIndex = enableLniAtDeviceIndex;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv4IpamPoolId}
         * @param ipv4IpamPoolId An IPv4 IPAM pool ID for the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4IpamPoolId(java.lang.String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv4NetmaskLength}
         * @param ipv4NetmaskLength An IPv4 netmask length for the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4NetmaskLength(java.lang.Number ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6CidrBlock}
         * @param ipv6CidrBlock The IPv6 CIDR block.
         *                      If you specify <code>AssignIpv6AddressOnCreation</code> , you must also specify an IPv6 CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6CidrBlock(java.lang.String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6IpamPoolId}
         * @param ipv6IpamPoolId An IPv6 IPAM pool ID for the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6IpamPoolId(java.lang.String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6Native}
         * @param ipv6Native Indicates whether this is an IPv6 only subnet.
         *                   For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Native(java.lang.Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6Native}
         * @param ipv6Native Indicates whether this is an IPv6 only subnet.
         *                   For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#subnet-basics">Subnet basics</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Native(software.amazon.awscdk.IResolvable ipv6Native) {
            this.ipv6Native = ipv6Native;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getIpv6NetmaskLength}
         * @param ipv6NetmaskLength An IPv6 netmask length for the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6NetmaskLength(java.lang.Number ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getMapPublicIpOnLaunch}
         * @param mapPublicIpOnLaunch Indicates whether instances launched in this subnet receive a public IPv4 address. The default value is <code>false</code> .
         *                            AWS charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <em>Public IPv4 Address</em> tab on the <a href="https://docs.aws.amazon.com/vpc/pricing/">VPC pricing page</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(java.lang.Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getMapPublicIpOnLaunch}
         * @param mapPublicIpOnLaunch Indicates whether instances launched in this subnet receive a public IPv4 address. The default value is <code>false</code> .
         *                            AWS charges for all public IPv4 addresses, including public IPv4 addresses associated with running instances and Elastic IP addresses. For more information, see the <em>Public IPv4 Address</em> tab on the <a href="https://docs.aws.amazon.com/vpc/pricing/">VPC pricing page</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapPublicIpOnLaunch(software.amazon.awscdk.IResolvable mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getOutpostArn}
         * @param outpostArn The Amazon Resource Name (ARN) of the Outpost.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostArn(java.lang.String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getPrivateDnsNameOptionsOnLaunch}
         * @param privateDnsNameOptionsOnLaunch The hostname type for EC2 instances launched into this subnet and how DNS A and AAAA record queries to the instances should be handled.
         *                                      For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-naming.html">Amazon EC2 instance hostname types</a> in the <em>Amazon Elastic Compute Cloud User Guide</em> .
         *                                      <p>
         *                                      Available options:
         *                                      <p>
         *                                      <ul>
         *                                      <li>EnableResourceNameDnsAAAARecord (true | false)</li>
         *                                      <li>EnableResourceNameDnsARecord (true | false)</li>
         *                                      <li>HostnameType (ip-name | resource-name)</li>
         *                                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsNameOptionsOnLaunch(java.lang.Object privateDnsNameOptionsOnLaunch) {
            this.privateDnsNameOptionsOnLaunch = privateDnsNameOptionsOnLaunch;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubnetProps#getTags}
         * @param tags Any tags assigned to the subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubnetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubnetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubnetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubnetProps {
        private final java.lang.String vpcId;
        private final java.lang.Object assignIpv6AddressOnCreation;
        private final java.lang.String availabilityZone;
        private final java.lang.String availabilityZoneId;
        private final java.lang.String cidrBlock;
        private final java.lang.Object enableDns64;
        private final java.lang.Number enableLniAtDeviceIndex;
        private final java.lang.String ipv4IpamPoolId;
        private final java.lang.Number ipv4NetmaskLength;
        private final java.lang.String ipv6CidrBlock;
        private final java.lang.String ipv6IpamPoolId;
        private final java.lang.Object ipv6Native;
        private final java.lang.Number ipv6NetmaskLength;
        private final java.lang.Object mapPublicIpOnLaunch;
        private final java.lang.String outpostArn;
        private final java.lang.Object privateDnsNameOptionsOnLaunch;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assignIpv6AddressOnCreation = software.amazon.jsii.Kernel.get(this, "assignIpv6AddressOnCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneId = software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrBlock = software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableDns64 = software.amazon.jsii.Kernel.get(this, "enableDns64", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableLniAtDeviceIndex = software.amazon.jsii.Kernel.get(this, "enableLniAtDeviceIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ipv4IpamPoolId = software.amazon.jsii.Kernel.get(this, "ipv4IpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv4NetmaskLength = software.amazon.jsii.Kernel.get(this, "ipv4NetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ipv6CidrBlock = software.amazon.jsii.Kernel.get(this, "ipv6CidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6IpamPoolId = software.amazon.jsii.Kernel.get(this, "ipv6IpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6Native = software.amazon.jsii.Kernel.get(this, "ipv6Native", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ipv6NetmaskLength = software.amazon.jsii.Kernel.get(this, "ipv6NetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mapPublicIpOnLaunch = software.amazon.jsii.Kernel.get(this, "mapPublicIpOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outpostArn = software.amazon.jsii.Kernel.get(this, "outpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateDnsNameOptionsOnLaunch = software.amazon.jsii.Kernel.get(this, "privateDnsNameOptionsOnLaunch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
            this.availabilityZone = builder.availabilityZone;
            this.availabilityZoneId = builder.availabilityZoneId;
            this.cidrBlock = builder.cidrBlock;
            this.enableDns64 = builder.enableDns64;
            this.enableLniAtDeviceIndex = builder.enableLniAtDeviceIndex;
            this.ipv4IpamPoolId = builder.ipv4IpamPoolId;
            this.ipv4NetmaskLength = builder.ipv4NetmaskLength;
            this.ipv6CidrBlock = builder.ipv6CidrBlock;
            this.ipv6IpamPoolId = builder.ipv6IpamPoolId;
            this.ipv6Native = builder.ipv6Native;
            this.ipv6NetmaskLength = builder.ipv6NetmaskLength;
            this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
            this.outpostArn = builder.outpostArn;
            this.privateDnsNameOptionsOnLaunch = builder.privateDnsNameOptionsOnLaunch;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.Object getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final java.lang.Object getEnableDns64() {
            return this.enableDns64;
        }

        @Override
        public final java.lang.Number getEnableLniAtDeviceIndex() {
            return this.enableLniAtDeviceIndex;
        }

        @Override
        public final java.lang.String getIpv4IpamPoolId() {
            return this.ipv4IpamPoolId;
        }

        @Override
        public final java.lang.Number getIpv4NetmaskLength() {
            return this.ipv4NetmaskLength;
        }

        @Override
        public final java.lang.String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final java.lang.String getIpv6IpamPoolId() {
            return this.ipv6IpamPoolId;
        }

        @Override
        public final java.lang.Object getIpv6Native() {
            return this.ipv6Native;
        }

        @Override
        public final java.lang.Number getIpv6NetmaskLength() {
            return this.ipv6NetmaskLength;
        }

        @Override
        public final java.lang.Object getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        public final java.lang.String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final java.lang.Object getPrivateDnsNameOptionsOnLaunch() {
            return this.privateDnsNameOptionsOnLaunch;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getAssignIpv6AddressOnCreation() != null) {
                data.set("assignIpv6AddressOnCreation", om.valueToTree(this.getAssignIpv6AddressOnCreation()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getAvailabilityZoneId() != null) {
                data.set("availabilityZoneId", om.valueToTree(this.getAvailabilityZoneId()));
            }
            if (this.getCidrBlock() != null) {
                data.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            }
            if (this.getEnableDns64() != null) {
                data.set("enableDns64", om.valueToTree(this.getEnableDns64()));
            }
            if (this.getEnableLniAtDeviceIndex() != null) {
                data.set("enableLniAtDeviceIndex", om.valueToTree(this.getEnableLniAtDeviceIndex()));
            }
            if (this.getIpv4IpamPoolId() != null) {
                data.set("ipv4IpamPoolId", om.valueToTree(this.getIpv4IpamPoolId()));
            }
            if (this.getIpv4NetmaskLength() != null) {
                data.set("ipv4NetmaskLength", om.valueToTree(this.getIpv4NetmaskLength()));
            }
            if (this.getIpv6CidrBlock() != null) {
                data.set("ipv6CidrBlock", om.valueToTree(this.getIpv6CidrBlock()));
            }
            if (this.getIpv6IpamPoolId() != null) {
                data.set("ipv6IpamPoolId", om.valueToTree(this.getIpv6IpamPoolId()));
            }
            if (this.getIpv6Native() != null) {
                data.set("ipv6Native", om.valueToTree(this.getIpv6Native()));
            }
            if (this.getIpv6NetmaskLength() != null) {
                data.set("ipv6NetmaskLength", om.valueToTree(this.getIpv6NetmaskLength()));
            }
            if (this.getMapPublicIpOnLaunch() != null) {
                data.set("mapPublicIpOnLaunch", om.valueToTree(this.getMapPublicIpOnLaunch()));
            }
            if (this.getOutpostArn() != null) {
                data.set("outpostArn", om.valueToTree(this.getOutpostArn()));
            }
            if (this.getPrivateDnsNameOptionsOnLaunch() != null) {
                data.set("privateDnsNameOptionsOnLaunch", om.valueToTree(this.getPrivateDnsNameOptionsOnLaunch()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnSubnetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubnetProps.Jsii$Proxy that = (CfnSubnetProps.Jsii$Proxy) o;

            if (!vpcId.equals(that.vpcId)) return false;
            if (this.assignIpv6AddressOnCreation != null ? !this.assignIpv6AddressOnCreation.equals(that.assignIpv6AddressOnCreation) : that.assignIpv6AddressOnCreation != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.availabilityZoneId != null ? !this.availabilityZoneId.equals(that.availabilityZoneId) : that.availabilityZoneId != null) return false;
            if (this.cidrBlock != null ? !this.cidrBlock.equals(that.cidrBlock) : that.cidrBlock != null) return false;
            if (this.enableDns64 != null ? !this.enableDns64.equals(that.enableDns64) : that.enableDns64 != null) return false;
            if (this.enableLniAtDeviceIndex != null ? !this.enableLniAtDeviceIndex.equals(that.enableLniAtDeviceIndex) : that.enableLniAtDeviceIndex != null) return false;
            if (this.ipv4IpamPoolId != null ? !this.ipv4IpamPoolId.equals(that.ipv4IpamPoolId) : that.ipv4IpamPoolId != null) return false;
            if (this.ipv4NetmaskLength != null ? !this.ipv4NetmaskLength.equals(that.ipv4NetmaskLength) : that.ipv4NetmaskLength != null) return false;
            if (this.ipv6CidrBlock != null ? !this.ipv6CidrBlock.equals(that.ipv6CidrBlock) : that.ipv6CidrBlock != null) return false;
            if (this.ipv6IpamPoolId != null ? !this.ipv6IpamPoolId.equals(that.ipv6IpamPoolId) : that.ipv6IpamPoolId != null) return false;
            if (this.ipv6Native != null ? !this.ipv6Native.equals(that.ipv6Native) : that.ipv6Native != null) return false;
            if (this.ipv6NetmaskLength != null ? !this.ipv6NetmaskLength.equals(that.ipv6NetmaskLength) : that.ipv6NetmaskLength != null) return false;
            if (this.mapPublicIpOnLaunch != null ? !this.mapPublicIpOnLaunch.equals(that.mapPublicIpOnLaunch) : that.mapPublicIpOnLaunch != null) return false;
            if (this.outpostArn != null ? !this.outpostArn.equals(that.outpostArn) : that.outpostArn != null) return false;
            if (this.privateDnsNameOptionsOnLaunch != null ? !this.privateDnsNameOptionsOnLaunch.equals(that.privateDnsNameOptionsOnLaunch) : that.privateDnsNameOptionsOnLaunch != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpcId.hashCode();
            result = 31 * result + (this.assignIpv6AddressOnCreation != null ? this.assignIpv6AddressOnCreation.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneId != null ? this.availabilityZoneId.hashCode() : 0);
            result = 31 * result + (this.cidrBlock != null ? this.cidrBlock.hashCode() : 0);
            result = 31 * result + (this.enableDns64 != null ? this.enableDns64.hashCode() : 0);
            result = 31 * result + (this.enableLniAtDeviceIndex != null ? this.enableLniAtDeviceIndex.hashCode() : 0);
            result = 31 * result + (this.ipv4IpamPoolId != null ? this.ipv4IpamPoolId.hashCode() : 0);
            result = 31 * result + (this.ipv4NetmaskLength != null ? this.ipv4NetmaskLength.hashCode() : 0);
            result = 31 * result + (this.ipv6CidrBlock != null ? this.ipv6CidrBlock.hashCode() : 0);
            result = 31 * result + (this.ipv6IpamPoolId != null ? this.ipv6IpamPoolId.hashCode() : 0);
            result = 31 * result + (this.ipv6Native != null ? this.ipv6Native.hashCode() : 0);
            result = 31 * result + (this.ipv6NetmaskLength != null ? this.ipv6NetmaskLength.hashCode() : 0);
            result = 31 * result + (this.mapPublicIpOnLaunch != null ? this.mapPublicIpOnLaunch.hashCode() : 0);
            result = 31 * result + (this.outpostArn != null ? this.outpostArn.hashCode() : 0);
            result = 31 * result + (this.privateDnsNameOptionsOnLaunch != null ? this.privateDnsNameOptionsOnLaunch.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
