package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVerifiedAccessGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVerifiedAccessGroupProps cfnVerifiedAccessGroupProps = CfnVerifiedAccessGroupProps.builder()
 *         .verifiedAccessInstanceId("verifiedAccessInstanceId")
 *         // the properties below are optional
 *         .description("description")
 *         .policyDocument("policyDocument")
 *         .policyEnabled(false)
 *         .sseSpecification(SseSpecificationProperty.builder()
 *                 .customerManagedKeyEnabled(false)
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.131Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVerifiedAccessGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnVerifiedAccessGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVerifiedAccessGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the AWS Verified Access instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-verifiedaccessinstanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-verifiedaccessinstanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVerifiedAccessInstanceId();

    /**
     * A description for the AWS Verified Access group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Verified Access policy document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-policydocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-policydocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicyDocument() {
        return null;
    }

    /**
     * The status of the Verified Access policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-policyenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-policyenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyEnabled() {
        return null;
    }

    /**
     * The options for additional server side encryption.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-ssespecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return null;
    }

    /**
     * The tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-verifiedaccessgroup.html#cfn-ec2-verifiedaccessgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVerifiedAccessGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVerifiedAccessGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVerifiedAccessGroupProps> {
        java.lang.String verifiedAccessInstanceId;
        java.lang.String description;
        java.lang.String policyDocument;
        java.lang.Object policyEnabled;
        java.lang.Object sseSpecification;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getVerifiedAccessInstanceId}
         * @param verifiedAccessInstanceId The ID of the AWS Verified Access instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifiedAccessInstanceId(java.lang.String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getDescription}
         * @param description A description for the AWS Verified Access group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getPolicyDocument}
         * @param policyDocument The Verified Access policy document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getPolicyEnabled}
         * @param policyEnabled The status of the Verified Access policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyEnabled(java.lang.Boolean policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getPolicyEnabled}
         * @param policyEnabled The status of the Verified Access policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyEnabled(software.amazon.awscdk.IResolvable policyEnabled) {
            this.policyEnabled = policyEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getSseSpecification}
         * @param sseSpecification The options for additional server side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getSseSpecification}
         * @param sseSpecification The options for additional server side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.services.ec2.CfnVerifiedAccessGroup.SseSpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnVerifiedAccessGroupProps#getTags}
         * @param tags The tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVerifiedAccessGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVerifiedAccessGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVerifiedAccessGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVerifiedAccessGroupProps {
        private final java.lang.String verifiedAccessInstanceId;
        private final java.lang.String description;
        private final java.lang.String policyDocument;
        private final java.lang.Object policyEnabled;
        private final java.lang.Object sseSpecification;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.verifiedAccessInstanceId = software.amazon.jsii.Kernel.get(this, "verifiedAccessInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyEnabled = software.amazon.jsii.Kernel.get(this, "policyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseSpecification = software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.verifiedAccessInstanceId = java.util.Objects.requireNonNull(builder.verifiedAccessInstanceId, "verifiedAccessInstanceId is required");
            this.description = builder.description;
            this.policyDocument = builder.policyDocument;
            this.policyEnabled = builder.policyEnabled;
            this.sseSpecification = builder.sseSpecification;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final java.lang.Object getPolicyEnabled() {
            return this.policyEnabled;
        }

        @Override
        public final java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("verifiedAccessInstanceId", om.valueToTree(this.getVerifiedAccessInstanceId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }
            if (this.getPolicyEnabled() != null) {
                data.set("policyEnabled", om.valueToTree(this.getPolicyEnabled()));
            }
            if (this.getSseSpecification() != null) {
                data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVerifiedAccessGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVerifiedAccessGroupProps.Jsii$Proxy that = (CfnVerifiedAccessGroupProps.Jsii$Proxy) o;

            if (!verifiedAccessInstanceId.equals(that.verifiedAccessInstanceId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.policyDocument != null ? !this.policyDocument.equals(that.policyDocument) : that.policyDocument != null) return false;
            if (this.policyEnabled != null ? !this.policyEnabled.equals(that.policyEnabled) : that.policyEnabled != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.verifiedAccessInstanceId.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.policyDocument != null ? this.policyDocument.hashCode() : 0);
            result = 31 * result + (this.policyEnabled != null ? this.policyEnabled.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
