package software.amazon.awscdk.services.ec2;

/**
 * Options when executing a file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.assets.Asset;
 * Instance instance;
 * Asset asset = Asset.Builder.create(this, "Asset")
 *         .path("./configure.sh")
 *         .build();
 * String localPath = instance.userData.addS3DownloadCommand(S3DownloadOptions.builder()
 *         .bucket(asset.getBucket())
 *         .bucketKey(asset.getS3ObjectKey())
 *         .region("us-east-1")
 *         .build());
 * instance.userData.addExecuteFileCommand(ExecuteFileOptions.builder()
 *         .filePath(localPath)
 *         .arguments("--verbose -y")
 *         .build());
 * asset.grantRead(instance.getRole());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-24T11:33:13.177Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ExecuteFileOptions")
@software.amazon.jsii.Jsii.Proxy(ExecuteFileOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExecuteFileOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The path to the file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFilePath();

    /**
     * The arguments to be passed to the file.
     * <p>
     * Default: No arguments are passed to the file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getArguments() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExecuteFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExecuteFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExecuteFileOptions> {
        java.lang.String filePath;
        java.lang.String arguments;

        /**
         * Sets the value of {@link ExecuteFileOptions#getFilePath}
         * @param filePath The path to the file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filePath(java.lang.String filePath) {
            this.filePath = filePath;
            return this;
        }

        /**
         * Sets the value of {@link ExecuteFileOptions#getArguments}
         * @param arguments The arguments to be passed to the file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arguments(java.lang.String arguments) {
            this.arguments = arguments;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExecuteFileOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExecuteFileOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExecuteFileOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecuteFileOptions {
        private final java.lang.String filePath;
        private final java.lang.String arguments;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.filePath = software.amazon.jsii.Kernel.get(this, "filePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.arguments = software.amazon.jsii.Kernel.get(this, "arguments", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.filePath = java.util.Objects.requireNonNull(builder.filePath, "filePath is required");
            this.arguments = builder.arguments;
        }

        @Override
        public final java.lang.String getFilePath() {
            return this.filePath;
        }

        @Override
        public final java.lang.String getArguments() {
            return this.arguments;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("filePath", om.valueToTree(this.getFilePath()));
            if (this.getArguments() != null) {
                data.set("arguments", om.valueToTree(this.getArguments()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.ExecuteFileOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExecuteFileOptions.Jsii$Proxy that = (ExecuteFileOptions.Jsii$Proxy) o;

            if (!filePath.equals(that.filePath)) return false;
            return this.arguments != null ? this.arguments.equals(that.arguments) : that.arguments == null;
        }

        @Override
        public final int hashCode() {
            int result = this.filePath.hashCode();
            result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
            return result;
        }
    }
}
